/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembershipItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListMembershipItem.Builder, ListMembershipItem> {
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ListMembershipItem::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(ListMembershipItem::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ListMembershipItem::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ListMembershipItem::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipStatus").getter(getter(ListMembershipItem::membershipStatusAsString))
            .setter(setter(Builder::membershipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_ID_FIELD,
            ACCOUNT_ID_FIELD, REGION_FIELD, MEMBERSHIP_ARN_FIELD, MEMBERSHIP_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String membershipId;

    private final String accountId;

    private final String region;

    private final String membershipArn;

    private final String membershipStatus;

    private ListMembershipItem(BuilderImpl builder) {
        this.membershipId = builder.membershipId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.membershipArn = builder.membershipArn;
        this.membershipStatus = builder.membershipStatus;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link AwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return
     * @see AwsRegion
     */
    public final AwsRegion region() {
        return AwsRegion.fromValue(region);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link AwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return
     * @see AwsRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return
     * @see MembershipStatus
     */
    public final MembershipStatus membershipStatus() {
        return MembershipStatus.fromValue(membershipStatus);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return
     * @see MembershipStatus
     */
    public final String membershipStatusAsString() {
        return membershipStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembershipItem)) {
            return false;
        }
        ListMembershipItem other = (ListMembershipItem) obj;
        return Objects.equals(membershipId(), other.membershipId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(regionAsString(), other.regionAsString())
                && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(membershipStatusAsString(), other.membershipStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembershipItem").add("MembershipId", membershipId()).add("AccountId", accountId())
                .add("Region", regionAsString()).add("MembershipArn", membershipArn())
                .add("MembershipStatus", membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "membershipStatus":
            return Optional.ofNullable(clazz.cast(membershipStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembershipItem, T> g) {
        return obj -> g.apply((ListMembershipItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListMembershipItem> {
        /**
         * <p/>
         * 
         * @param membershipId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p/>
         * 
         * @param accountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p/>
         * 
         * @param region
         * @see AwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsRegion
         */
        Builder region(String region);

        /**
         * <p/>
         * 
         * @param region
         * @see AwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsRegion
         */
        Builder region(AwsRegion region);

        /**
         * <p/>
         * 
         * @param membershipArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p/>
         * 
         * @param membershipStatus
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder membershipStatus(String membershipStatus);

        /**
         * <p/>
         * 
         * @param membershipStatus
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder membershipStatus(MembershipStatus membershipStatus);
    }

    static final class BuilderImpl implements Builder {
        private String membershipId;

        private String accountId;

        private String region;

        private String membershipArn;

        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembershipItem model) {
            membershipId(model.membershipId);
            accountId(model.accountId);
            region(model.region);
            membershipArn(model.membershipArn);
            membershipStatus(model.membershipStatus);
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(AwsRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getMembershipStatus() {
            return membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(MembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        @Override
        public ListMembershipItem build() {
            return new ListMembershipItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
