/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>MembershipAccountsConfigurations</code> structure defines the configuration settings for managing
 * membership accounts withinAmazon Web Services.
 * </p>
 * <p>
 * This structure contains settings that determine how member accounts are configured and managed within your
 * organization, including:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Account configuration preferences
 * </p>
 * </li>
 * <li>
 * <p>
 * Membership validation rules
 * </p>
 * </li>
 * <li>
 * <p>
 * Account access settings
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can use this structure to define and maintain standardized configurations across multiple member accounts in your
 * organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipAccountsConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipAccountsConfigurations.Builder, MembershipAccountsConfigurations> {
    private static final SdkField<Boolean> COVER_ENTIRE_ORGANIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("coverEntireOrganization").getter(getter(MembershipAccountsConfigurations::coverEntireOrganization))
            .setter(setter(Builder::coverEntireOrganization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverEntireOrganization").build())
            .build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("organizationalUnits")
            .getter(getter(MembershipAccountsConfigurations::organizationalUnits))
            .setter(setter(Builder::organizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COVER_ENTIRE_ORGANIZATION_FIELD, ORGANIZATIONAL_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean coverEntireOrganization;

    private final List<String> organizationalUnits;

    private MembershipAccountsConfigurations(BuilderImpl builder) {
        this.coverEntireOrganization = builder.coverEntireOrganization;
        this.organizationalUnits = builder.organizationalUnits;
    }

    /**
     * <p>
     * The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
     * configuration applies to all accounts within an Amazon Web Services Organization.
     * </p>
     * <p>
     * When set to <code>true</code>, the configuration will be applied across all accounts in the organization. When
     * set to <code>false</code>, the configuration will only apply to specifically designated accounts under the AWS
     * Organizational Units specificied.
     * </p>
     * 
     * @return The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
     *         configuration applies to all accounts within an Amazon Web Services Organization. </p>
     *         <p>
     *         When set to <code>true</code>, the configuration will be applied across all accounts in the organization.
     *         When set to <code>false</code>, the configuration will only apply to specifically designated accounts
     *         under the AWS Organizational Units specificied.
     */
    public final Boolean coverEntireOrganization() {
        return coverEntireOrganization;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnits property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrganizationalUnits() {
        return organizationalUnits != null && !(organizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of organizational unit IDs that follow the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. These
     * IDs represent the organizational units within an Amazon Web Services Organizations structure that are covered by
     * the membership.
     * </p>
     * <p>
     * Each organizational unit ID in the list must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Begin with the prefix 'ou-'
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain between 4 and 32 alphanumeric characters in the first segment
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain between 8 and 32 alphanumeric characters in the second segment
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnits} method.
     * </p>
     * 
     * @return A list of organizational unit IDs that follow the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
     *         These IDs represent the organizational units within an Amazon Web Services Organizations structure that
     *         are covered by the membership. </p>
     *         <p>
     *         Each organizational unit ID in the list must:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Begin with the prefix 'ou-'
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain between 4 and 32 alphanumeric characters in the first segment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain between 8 and 32 alphanumeric characters in the second segment
     *         </p>
     *         </li>
     */
    public final List<String> organizationalUnits() {
        return organizationalUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coverEntireOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnits() ? organizationalUnits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipAccountsConfigurations)) {
            return false;
        }
        MembershipAccountsConfigurations other = (MembershipAccountsConfigurations) obj;
        return Objects.equals(coverEntireOrganization(), other.coverEntireOrganization())
                && hasOrganizationalUnits() == other.hasOrganizationalUnits()
                && Objects.equals(organizationalUnits(), other.organizationalUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipAccountsConfigurations").add("CoverEntireOrganization", coverEntireOrganization())
                .add("OrganizationalUnits", hasOrganizationalUnits() ? organizationalUnits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coverEntireOrganization":
            return Optional.ofNullable(clazz.cast(coverEntireOrganization()));
        case "organizationalUnits":
            return Optional.ofNullable(clazz.cast(organizationalUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coverEntireOrganization", COVER_ENTIRE_ORGANIZATION_FIELD);
        map.put("organizationalUnits", ORGANIZATIONAL_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipAccountsConfigurations, T> g) {
        return obj -> g.apply((MembershipAccountsConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipAccountsConfigurations> {
        /**
         * <p>
         * The <code>coverEntireOrganization</code> field is a boolean value that determines whether the membership
         * configuration applies to all accounts within an Amazon Web Services Organization.
         * </p>
         * <p>
         * When set to <code>true</code>, the configuration will be applied across all accounts in the organization.
         * When set to <code>false</code>, the configuration will only apply to specifically designated accounts under
         * the AWS Organizational Units specificied.
         * </p>
         * 
         * @param coverEntireOrganization
         *        The <code>coverEntireOrganization</code> field is a boolean value that determines whether the
         *        membership configuration applies to all accounts within an Amazon Web Services Organization. </p>
         *        <p>
         *        When set to <code>true</code>, the configuration will be applied across all accounts in the
         *        organization. When set to <code>false</code>, the configuration will only apply to specifically
         *        designated accounts under the AWS Organizational Units specificied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverEntireOrganization(Boolean coverEntireOrganization);

        /**
         * <p>
         * A list of organizational unit IDs that follow the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * These IDs represent the organizational units within an Amazon Web Services Organizations structure that are
         * covered by the membership.
         * </p>
         * <p>
         * Each organizational unit ID in the list must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Begin with the prefix 'ou-'
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain between 4 and 32 alphanumeric characters in the first segment
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain between 8 and 32 alphanumeric characters in the second segment
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationalUnits
         *        A list of organizational unit IDs that follow the pattern
         *        <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. These IDs represent the organizational units within an
         *        Amazon Web Services Organizations structure that are covered by the membership. </p>
         *        <p>
         *        Each organizational unit ID in the list must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Begin with the prefix 'ou-'
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain between 4 and 32 alphanumeric characters in the first segment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain between 8 and 32 alphanumeric characters in the second segment
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(Collection<String> organizationalUnits);

        /**
         * <p>
         * A list of organizational unit IDs that follow the pattern <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>.
         * These IDs represent the organizational units within an Amazon Web Services Organizations structure that are
         * covered by the membership.
         * </p>
         * <p>
         * Each organizational unit ID in the list must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Begin with the prefix 'ou-'
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain between 4 and 32 alphanumeric characters in the first segment
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain between 8 and 32 alphanumeric characters in the second segment
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationalUnits
         *        A list of organizational unit IDs that follow the pattern
         *        <code>ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}</code>. These IDs represent the organizational units within an
         *        Amazon Web Services Organizations structure that are covered by the membership. </p>
         *        <p>
         *        Each organizational unit ID in the list must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Begin with the prefix 'ou-'
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain between 4 and 32 alphanumeric characters in the first segment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain between 8 and 32 alphanumeric characters in the second segment
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(String... organizationalUnits);
    }

    static final class BuilderImpl implements Builder {
        private Boolean coverEntireOrganization;

        private List<String> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipAccountsConfigurations model) {
            coverEntireOrganization(model.coverEntireOrganization);
            organizationalUnits(model.organizationalUnits);
        }

        public final Boolean getCoverEntireOrganization() {
            return coverEntireOrganization;
        }

        public final void setCoverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
        }

        @Override
        public final Builder coverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
            return this;
        }

        public final Collection<String> getOrganizationalUnits() {
            if (organizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnits;
        }

        public final void setOrganizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(String... organizationalUnits) {
            organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        @Override
        public MembershipAccountsConfigurations build() {
            return new MembershipAccountsConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
