/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAwsLogSourceRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateAwsLogSourceRequest.Builder, CreateAwsLogSourceRequest> {
    private static final SdkField<Map<String, Map<String, List<String>>>> ENABLE_ALL_DIMENSIONS_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("enableAllDimensions")
            .getter(getter(CreateAwsLogSourceRequest::enableAllDimensions))
            .setter(setter(Builder::enableAllDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAllDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<List<String>> ENABLE_SINGLE_DIMENSION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enableSingleDimension")
            .getter(getter(CreateAwsLogSourceRequest::enableSingleDimension))
            .setter(setter(Builder::enableSingleDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSingleDimension").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> ENABLE_TWO_DIMENSIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("enableTwoDimensions")
            .getter(getter(CreateAwsLogSourceRequest::enableTwoDimensions))
            .setter(setter(Builder::enableTwoDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTwoDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> INPUT_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputOrder")
            .getter(getter(CreateAwsLogSourceRequest::inputOrderAsStrings))
            .setter(setter(Builder::inputOrderWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ALL_DIMENSIONS_FIELD,
            ENABLE_SINGLE_DIMENSION_FIELD, ENABLE_TWO_DIMENSIONS_FIELD, INPUT_ORDER_FIELD));

    private final Map<String, Map<String, List<String>>> enableAllDimensions;

    private final List<String> enableSingleDimension;

    private final Map<String, List<String>> enableTwoDimensions;

    private final List<String> inputOrder;

    private CreateAwsLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.enableAllDimensions = builder.enableAllDimensions;
        this.enableSingleDimension = builder.enableSingleDimension;
        this.enableTwoDimensions = builder.enableTwoDimensions;
        this.inputOrder = builder.inputOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableAllDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnableAllDimensions() {
        return enableAllDimensions != null && !(enableAllDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Enables specific sources in all Regions and source types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableAllDimensions} method.
     * </p>
     * 
     * @return Enables specific sources in all Regions and source types.
     */
    public final Map<String, Map<String, List<String>>> enableAllDimensions() {
        return enableAllDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableSingleDimension property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableSingleDimension() {
        return enableSingleDimension != null && !(enableSingleDimension instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables all sources in specific accounts or Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableSingleDimension} method.
     * </p>
     * 
     * @return Enables all sources in specific accounts or Regions.
     */
    public final List<String> enableSingleDimension() {
        return enableSingleDimension;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableTwoDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnableTwoDimensions() {
        return enableTwoDimensions != null && !(enableTwoDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Enables specific service sources in specific accounts or Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableTwoDimensions} method.
     * </p>
     * 
     * @return Enables specific service sources in specific accounts or Regions.
     */
    public final Map<String, List<String>> enableTwoDimensions() {
        return enableTwoDimensions;
    }

    /**
     * <p>
     * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
     *         account.
     */
    public final List<Dimension> inputOrder() {
        return DimensionSetCopier.copyStringToEnum(inputOrder);
    }

    /**
     * For responses, this returns true if the service returned a value for the InputOrder property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputOrder() {
        return inputOrder != null && !(inputOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
     *         account.
     */
    public final List<String> inputOrderAsStrings() {
        return inputOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableAllDimensions() ? enableAllDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableSingleDimension() ? enableSingleDimension() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableTwoDimensions() ? enableTwoDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputOrder() ? inputOrderAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAwsLogSourceRequest)) {
            return false;
        }
        CreateAwsLogSourceRequest other = (CreateAwsLogSourceRequest) obj;
        return hasEnableAllDimensions() == other.hasEnableAllDimensions()
                && Objects.equals(enableAllDimensions(), other.enableAllDimensions())
                && hasEnableSingleDimension() == other.hasEnableSingleDimension()
                && Objects.equals(enableSingleDimension(), other.enableSingleDimension())
                && hasEnableTwoDimensions() == other.hasEnableTwoDimensions()
                && Objects.equals(enableTwoDimensions(), other.enableTwoDimensions()) && hasInputOrder() == other.hasInputOrder()
                && Objects.equals(inputOrderAsStrings(), other.inputOrderAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAwsLogSourceRequest")
                .add("EnableAllDimensions", hasEnableAllDimensions() ? enableAllDimensions() : null)
                .add("EnableSingleDimension", hasEnableSingleDimension() ? enableSingleDimension() : null)
                .add("EnableTwoDimensions", hasEnableTwoDimensions() ? enableTwoDimensions() : null)
                .add("InputOrder", hasInputOrder() ? inputOrderAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableAllDimensions":
            return Optional.ofNullable(clazz.cast(enableAllDimensions()));
        case "enableSingleDimension":
            return Optional.ofNullable(clazz.cast(enableSingleDimension()));
        case "enableTwoDimensions":
            return Optional.ofNullable(clazz.cast(enableTwoDimensions()));
        case "inputOrder":
            return Optional.ofNullable(clazz.cast(inputOrderAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAwsLogSourceRequest, T> g) {
        return obj -> g.apply((CreateAwsLogSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAwsLogSourceRequest> {
        /**
         * <p>
         * Enables specific sources in all Regions and source types.
         * </p>
         * 
         * @param enableAllDimensions
         *        Enables specific sources in all Regions and source types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> enableAllDimensions);

        /**
         * <p>
         * Enables all sources in specific accounts or Regions.
         * </p>
         * 
         * @param enableSingleDimension
         *        Enables all sources in specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSingleDimension(Collection<String> enableSingleDimension);

        /**
         * <p>
         * Enables all sources in specific accounts or Regions.
         * </p>
         * 
         * @param enableSingleDimension
         *        Enables all sources in specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSingleDimension(String... enableSingleDimension);

        /**
         * <p>
         * Enables specific service sources in specific accounts or Regions.
         * </p>
         * 
         * @param enableTwoDimensions
         *        Enables specific service sources in specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTwoDimensions(Map<String, ? extends Collection<String>> enableTwoDimensions);

        /**
         * <p>
         * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
         * account.
         * </p>
         * 
         * @param inputOrder
         *        Specifies the input order to enable dimensions in Security Lake, namely region, source type, and
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(Collection<String> inputOrder);

        /**
         * <p>
         * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
         * account.
         * </p>
         * 
         * @param inputOrder
         *        Specifies the input order to enable dimensions in Security Lake, namely region, source type, and
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(String... inputOrder);

        /**
         * <p>
         * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
         * account.
         * </p>
         * 
         * @param inputOrder
         *        Specifies the input order to enable dimensions in Security Lake, namely region, source type, and
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Collection<Dimension> inputOrder);

        /**
         * <p>
         * Specifies the input order to enable dimensions in Security Lake, namely region, source type, and member
         * account.
         * </p>
         * 
         * @param inputOrder
         *        Specifies the input order to enable dimensions in Security Lake, namely region, source type, and
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Dimension... inputOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private Map<String, Map<String, List<String>>> enableAllDimensions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> enableSingleDimension = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> enableTwoDimensions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> inputOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAwsLogSourceRequest model) {
            super(model);
            enableAllDimensions(model.enableAllDimensions);
            enableSingleDimension(model.enableSingleDimension);
            enableTwoDimensions(model.enableTwoDimensions);
            inputOrderWithStrings(model.inputOrder);
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getEnableAllDimensions() {
            if (enableAllDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return enableAllDimensions;
        }

        public final void setEnableAllDimensions(
                Map<String, ? extends Map<String, ? extends Collection<String>>> enableAllDimensions) {
            this.enableAllDimensions = AllDimensionsMapCopier.copy(enableAllDimensions);
        }

        @Override
        public final Builder enableAllDimensions(
                Map<String, ? extends Map<String, ? extends Collection<String>>> enableAllDimensions) {
            this.enableAllDimensions = AllDimensionsMapCopier.copy(enableAllDimensions);
            return this;
        }

        public final Collection<String> getEnableSingleDimension() {
            if (enableSingleDimension instanceof SdkAutoConstructList) {
                return null;
            }
            return enableSingleDimension;
        }

        public final void setEnableSingleDimension(Collection<String> enableSingleDimension) {
            this.enableSingleDimension = InputSetCopier.copy(enableSingleDimension);
        }

        @Override
        public final Builder enableSingleDimension(Collection<String> enableSingleDimension) {
            this.enableSingleDimension = InputSetCopier.copy(enableSingleDimension);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableSingleDimension(String... enableSingleDimension) {
            enableSingleDimension(Arrays.asList(enableSingleDimension));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getEnableTwoDimensions() {
            if (enableTwoDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return enableTwoDimensions;
        }

        public final void setEnableTwoDimensions(Map<String, ? extends Collection<String>> enableTwoDimensions) {
            this.enableTwoDimensions = TwoDimensionsMapCopier.copy(enableTwoDimensions);
        }

        @Override
        public final Builder enableTwoDimensions(Map<String, ? extends Collection<String>> enableTwoDimensions) {
            this.enableTwoDimensions = TwoDimensionsMapCopier.copy(enableTwoDimensions);
            return this;
        }

        public final Collection<String> getInputOrder() {
            if (inputOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return inputOrder;
        }

        public final void setInputOrder(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
        }

        @Override
        public final Builder inputOrderWithStrings(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrderWithStrings(String... inputOrder) {
            inputOrderWithStrings(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public final Builder inputOrder(Collection<Dimension> inputOrder) {
            this.inputOrder = DimensionSetCopier.copyEnumToString(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrder(Dimension... inputOrder) {
            inputOrder(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAwsLogSourceRequest build() {
            return new CreateAwsLogSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
