/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomLogSourceResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<CreateCustomLogSourceResponse.Builder, CreateCustomLogSourceResponse> {
    private static final SdkField<String> CUSTOM_DATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDataLocation").getter(getter(CreateCustomLogSourceResponse::customDataLocation))
            .setter(setter(Builder::customDataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataLocation").build())
            .build();

    private static final SdkField<String> GLUE_CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueCrawlerName").getter(getter(CreateCustomLogSourceResponse::glueCrawlerName))
            .setter(setter(Builder::glueCrawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueCrawlerName").build()).build();

    private static final SdkField<String> GLUE_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueDatabaseName").getter(getter(CreateCustomLogSourceResponse::glueDatabaseName))
            .setter(setter(Builder::glueDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueDatabaseName").build()).build();

    private static final SdkField<String> GLUE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueTableName").getter(getter(CreateCustomLogSourceResponse::glueTableName))
            .setter(setter(Builder::glueTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueTableName").build()).build();

    private static final SdkField<String> LOG_PROVIDER_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logProviderAccessRoleArn").getter(getter(CreateCustomLogSourceResponse::logProviderAccessRoleArn))
            .setter(setter(Builder::logProviderAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logProviderAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_LOCATION_FIELD,
            GLUE_CRAWLER_NAME_FIELD, GLUE_DATABASE_NAME_FIELD, GLUE_TABLE_NAME_FIELD, LOG_PROVIDER_ACCESS_ROLE_ARN_FIELD));

    private final String customDataLocation;

    private final String glueCrawlerName;

    private final String glueDatabaseName;

    private final String glueTableName;

    private final String logProviderAccessRoleArn;

    private CreateCustomLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.customDataLocation = builder.customDataLocation;
        this.glueCrawlerName = builder.glueCrawlerName;
        this.glueDatabaseName = builder.glueDatabaseName;
        this.glueTableName = builder.glueTableName;
        this.logProviderAccessRoleArn = builder.logProviderAccessRoleArn;
    }

    /**
     * <p>
     * The location of the partition in the Security Lake S3 bucket.
     * </p>
     * 
     * @return The location of the partition in the Security Lake S3 bucket.
     */
    public final String customDataLocation() {
        return customDataLocation;
    }

    /**
     * <p>
     * The name of the Glue crawler.
     * </p>
     * 
     * @return The name of the Glue crawler.
     */
    public final String glueCrawlerName() {
        return glueCrawlerName;
    }

    /**
     * <p>
     * The Glue database where results are written, such as:
     * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     * </p>
     * 
     * @return The Glue database where results are written, such as:
     *         <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     */
    public final String glueDatabaseName() {
        return glueDatabaseName;
    }

    /**
     * <p>
     * The table name of the Glue crawler.
     * </p>
     * 
     * @return The table name of the Glue crawler.
     */
    public final String glueTableName() {
        return glueTableName;
    }

    /**
     * <p>
     * IAM Role ARN to be used by the entity putting logs into your Custom Source partition. Security Lake will apply
     * the correct access policies to this Role, but this Role must have the trust policy created manually. This Role's
     * name must start with the text 'Security Lake'. It must trust the <code>logProviderAccountId</code> to assume it.
     * </p>
     * 
     * @return IAM Role ARN to be used by the entity putting logs into your Custom Source partition. Security Lake will
     *         apply the correct access policies to this Role, but this Role must have the trust policy created
     *         manually. This Role's name must start with the text 'Security Lake'. It must trust the
     *         <code>logProviderAccountId</code> to assume it.
     */
    public final String logProviderAccessRoleArn() {
        return logProviderAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(glueCrawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(glueDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(glueTableName());
        hashCode = 31 * hashCode + Objects.hashCode(logProviderAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceResponse)) {
            return false;
        }
        CreateCustomLogSourceResponse other = (CreateCustomLogSourceResponse) obj;
        return Objects.equals(customDataLocation(), other.customDataLocation())
                && Objects.equals(glueCrawlerName(), other.glueCrawlerName())
                && Objects.equals(glueDatabaseName(), other.glueDatabaseName())
                && Objects.equals(glueTableName(), other.glueTableName())
                && Objects.equals(logProviderAccessRoleArn(), other.logProviderAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomLogSourceResponse").add("CustomDataLocation", customDataLocation())
                .add("GlueCrawlerName", glueCrawlerName()).add("GlueDatabaseName", glueDatabaseName())
                .add("GlueTableName", glueTableName()).add("LogProviderAccessRoleArn", logProviderAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDataLocation":
            return Optional.ofNullable(clazz.cast(customDataLocation()));
        case "glueCrawlerName":
            return Optional.ofNullable(clazz.cast(glueCrawlerName()));
        case "glueDatabaseName":
            return Optional.ofNullable(clazz.cast(glueDatabaseName()));
        case "glueTableName":
            return Optional.ofNullable(clazz.cast(glueTableName()));
        case "logProviderAccessRoleArn":
            return Optional.ofNullable(clazz.cast(logProviderAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceResponse, T> g) {
        return obj -> g.apply((CreateCustomLogSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomLogSourceResponse> {
        /**
         * <p>
         * The location of the partition in the Security Lake S3 bucket.
         * </p>
         * 
         * @param customDataLocation
         *        The location of the partition in the Security Lake S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataLocation(String customDataLocation);

        /**
         * <p>
         * The name of the Glue crawler.
         * </p>
         * 
         * @param glueCrawlerName
         *        The name of the Glue crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueCrawlerName(String glueCrawlerName);

        /**
         * <p>
         * The Glue database where results are written, such as:
         * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * </p>
         * 
         * @param glueDatabaseName
         *        The Glue database where results are written, such as:
         *        <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueDatabaseName(String glueDatabaseName);

        /**
         * <p>
         * The table name of the Glue crawler.
         * </p>
         * 
         * @param glueTableName
         *        The table name of the Glue crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueTableName(String glueTableName);

        /**
         * <p>
         * IAM Role ARN to be used by the entity putting logs into your Custom Source partition. Security Lake will
         * apply the correct access policies to this Role, but this Role must have the trust policy created manually.
         * This Role's name must start with the text 'Security Lake'. It must trust the
         * <code>logProviderAccountId</code> to assume it.
         * </p>
         * 
         * @param logProviderAccessRoleArn
         *        IAM Role ARN to be used by the entity putting logs into your Custom Source partition. Security Lake
         *        will apply the correct access policies to this Role, but this Role must have the trust policy created
         *        manually. This Role's name must start with the text 'Security Lake'. It must trust the
         *        <code>logProviderAccountId</code> to assume it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logProviderAccessRoleArn(String logProviderAccessRoleArn);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private String customDataLocation;

        private String glueCrawlerName;

        private String glueDatabaseName;

        private String glueTableName;

        private String logProviderAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceResponse model) {
            super(model);
            customDataLocation(model.customDataLocation);
            glueCrawlerName(model.glueCrawlerName);
            glueDatabaseName(model.glueDatabaseName);
            glueTableName(model.glueTableName);
            logProviderAccessRoleArn(model.logProviderAccessRoleArn);
        }

        public final String getCustomDataLocation() {
            return customDataLocation;
        }

        public final void setCustomDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
        }

        @Override
        public final Builder customDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
            return this;
        }

        public final String getGlueCrawlerName() {
            return glueCrawlerName;
        }

        public final void setGlueCrawlerName(String glueCrawlerName) {
            this.glueCrawlerName = glueCrawlerName;
        }

        @Override
        public final Builder glueCrawlerName(String glueCrawlerName) {
            this.glueCrawlerName = glueCrawlerName;
            return this;
        }

        public final String getGlueDatabaseName() {
            return glueDatabaseName;
        }

        public final void setGlueDatabaseName(String glueDatabaseName) {
            this.glueDatabaseName = glueDatabaseName;
        }

        @Override
        public final Builder glueDatabaseName(String glueDatabaseName) {
            this.glueDatabaseName = glueDatabaseName;
            return this;
        }

        public final String getGlueTableName() {
            return glueTableName;
        }

        public final void setGlueTableName(String glueTableName) {
            this.glueTableName = glueTableName;
        }

        @Override
        public final Builder glueTableName(String glueTableName) {
            this.glueTableName = glueTableName;
            return this;
        }

        public final String getLogProviderAccessRoleArn() {
            return logProviderAccessRoleArn;
        }

        public final void setLogProviderAccessRoleArn(String logProviderAccessRoleArn) {
            this.logProviderAccessRoleArn = logProviderAccessRoleArn;
        }

        @Override
        public final Builder logProviderAccessRoleArn(String logProviderAccessRoleArn) {
            this.logProviderAccessRoleArn = logProviderAccessRoleArn;
            return this;
        }

        @Override
        public CreateCustomLogSourceResponse build() {
            return new CreateCustomLogSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
