/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomLogSourceRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<DeleteCustomLogSourceRequest.Builder, DeleteCustomLogSourceRequest> {
    private static final SdkField<String> CUSTOM_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customSourceName").getter(getter(DeleteCustomLogSourceRequest::customSourceName))
            .setter(setter(Builder::customSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("customSourceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_SOURCE_NAME_FIELD));

    private final String customSourceName;

    private DeleteCustomLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.customSourceName = builder.customSourceName;
    }

    /**
     * <p>
     * The custom source name for the custome log source.
     * </p>
     * 
     * @return The custom source name for the custome log source.
     */
    public final String customSourceName() {
        return customSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomLogSourceRequest)) {
            return false;
        }
        DeleteCustomLogSourceRequest other = (DeleteCustomLogSourceRequest) obj;
        return Objects.equals(customSourceName(), other.customSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomLogSourceRequest").add("CustomSourceName", customSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customSourceName":
            return Optional.ofNullable(clazz.cast(customSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomLogSourceRequest, T> g) {
        return obj -> g.apply((DeleteCustomLogSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCustomLogSourceRequest> {
        /**
         * <p>
         * The custom source name for the custome log source.
         * </p>
         * 
         * @param customSourceName
         *        The custom source name for the custome log source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSourceName(String customSourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private String customSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomLogSourceRequest model) {
            super(model);
            customSourceName(model.customSourceName);
        }

        public final String getCustomSourceName() {
            return customSourceName;
        }

        public final void setCustomSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
        }

        @Override
        public final Builder customSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomLogSourceRequest build() {
            return new DeleteCustomLogSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
