/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDatalakeAutoEnableRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<DeleteDatalakeAutoEnableRequest.Builder, DeleteDatalakeAutoEnableRequest> {
    private static final SdkField<List<AutoEnableNewRegionConfiguration>> REMOVE_FROM_CONFIGURATION_FOR_NEW_ACCOUNTS_FIELD = SdkField
            .<List<AutoEnableNewRegionConfiguration>> builder(MarshallingType.LIST)
            .memberName("removeFromConfigurationForNewAccounts")
            .getter(getter(DeleteDatalakeAutoEnableRequest::removeFromConfigurationForNewAccounts))
            .setter(setter(Builder::removeFromConfigurationForNewAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("removeFromConfigurationForNewAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoEnableNewRegionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoEnableNewRegionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REMOVE_FROM_CONFIGURATION_FOR_NEW_ACCOUNTS_FIELD));

    private final List<AutoEnableNewRegionConfiguration> removeFromConfigurationForNewAccounts;

    private DeleteDatalakeAutoEnableRequest(BuilderImpl builder) {
        super(builder);
        this.removeFromConfigurationForNewAccounts = builder.removeFromConfigurationForNewAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveFromConfigurationForNewAccounts
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRemoveFromConfigurationForNewAccounts() {
        return removeFromConfigurationForNewAccounts != null
                && !(removeFromConfigurationForNewAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data for new
     * accounts in Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveFromConfigurationForNewAccounts}
     * method.
     * </p>
     * 
     * @return Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data
     *         for new accounts in Security Lake.
     */
    public final List<AutoEnableNewRegionConfiguration> removeFromConfigurationForNewAccounts() {
        return removeFromConfigurationForNewAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRemoveFromConfigurationForNewAccounts() ? removeFromConfigurationForNewAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDatalakeAutoEnableRequest)) {
            return false;
        }
        DeleteDatalakeAutoEnableRequest other = (DeleteDatalakeAutoEnableRequest) obj;
        return hasRemoveFromConfigurationForNewAccounts() == other.hasRemoveFromConfigurationForNewAccounts()
                && Objects.equals(removeFromConfigurationForNewAccounts(), other.removeFromConfigurationForNewAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DeleteDatalakeAutoEnableRequest")
                .add("RemoveFromConfigurationForNewAccounts",
                        hasRemoveFromConfigurationForNewAccounts() ? removeFromConfigurationForNewAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "removeFromConfigurationForNewAccounts":
            return Optional.ofNullable(clazz.cast(removeFromConfigurationForNewAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDatalakeAutoEnableRequest, T> g) {
        return obj -> g.apply((DeleteDatalakeAutoEnableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDatalakeAutoEnableRequest> {
        /**
         * <p>
         * Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data for
         * new accounts in Security Lake.
         * </p>
         * 
         * @param removeFromConfigurationForNewAccounts
         *        Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data
         *        for new accounts in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFromConfigurationForNewAccounts(
                Collection<AutoEnableNewRegionConfiguration> removeFromConfigurationForNewAccounts);

        /**
         * <p>
         * Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data for
         * new accounts in Security Lake.
         * </p>
         * 
         * @param removeFromConfigurationForNewAccounts
         *        Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data
         *        for new accounts in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFromConfigurationForNewAccounts(AutoEnableNewRegionConfiguration... removeFromConfigurationForNewAccounts);

        /**
         * <p>
         * Delete Amazon Security Lake with the specified configurations settings to stop ingesting security data for
         * new accounts in Security Lake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #removeFromConfigurationForNewAccounts(List<AutoEnableNewRegionConfiguration>)}.
         * 
         * @param removeFromConfigurationForNewAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeFromConfigurationForNewAccounts(java.util.Collection<AutoEnableNewRegionConfiguration>)
         */
        Builder removeFromConfigurationForNewAccounts(
                Consumer<AutoEnableNewRegionConfiguration.Builder>... removeFromConfigurationForNewAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<AutoEnableNewRegionConfiguration> removeFromConfigurationForNewAccounts = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDatalakeAutoEnableRequest model) {
            super(model);
            removeFromConfigurationForNewAccounts(model.removeFromConfigurationForNewAccounts);
        }

        public final List<AutoEnableNewRegionConfiguration.Builder> getRemoveFromConfigurationForNewAccounts() {
            List<AutoEnableNewRegionConfiguration.Builder> result = AutoEnableNewRegionConfigurationListCopier
                    .copyToBuilder(this.removeFromConfigurationForNewAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveFromConfigurationForNewAccounts(
                Collection<AutoEnableNewRegionConfiguration.BuilderImpl> removeFromConfigurationForNewAccounts) {
            this.removeFromConfigurationForNewAccounts = AutoEnableNewRegionConfigurationListCopier
                    .copyFromBuilder(removeFromConfigurationForNewAccounts);
        }

        @Override
        public final Builder removeFromConfigurationForNewAccounts(
                Collection<AutoEnableNewRegionConfiguration> removeFromConfigurationForNewAccounts) {
            this.removeFromConfigurationForNewAccounts = AutoEnableNewRegionConfigurationListCopier
                    .copy(removeFromConfigurationForNewAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFromConfigurationForNewAccounts(
                AutoEnableNewRegionConfiguration... removeFromConfigurationForNewAccounts) {
            removeFromConfigurationForNewAccounts(Arrays.asList(removeFromConfigurationForNewAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFromConfigurationForNewAccounts(
                Consumer<AutoEnableNewRegionConfiguration.Builder>... removeFromConfigurationForNewAccounts) {
            removeFromConfigurationForNewAccounts(Stream.of(removeFromConfigurationForNewAccounts)
                    .map(c -> AutoEnableNewRegionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDatalakeAutoEnableRequest build() {
            return new DeleteDatalakeAutoEnableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
