/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response element for actions which make changes namely create, update, or delete actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailuresResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<FailuresResponse.Builder, FailuresResponse> {
    private static final SdkField<List<Failures>> FAILURES_FIELD = SdkField
            .<List<Failures>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(FailuresResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failures> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failures::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(FailuresResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Failures> failures;

    private final String region;

    private FailuresResponse(BuilderImpl builder) {
        this.failures = builder.failures;
        this.region = builder.region;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of all failures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return List of all failures.
     */
    public final List<Failures> failures() {
        return failures;
    }

    /**
     * <p>
     * List of Regions where the failure occurred.
     * </p>
     * 
     * @return List of Regions where the failure occurred.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailuresResponse)) {
            return false;
        }
        FailuresResponse other = (FailuresResponse) obj;
        return hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailuresResponse").add("Failures", hasFailures() ? failures() : null).add("Region", region())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailuresResponse, T> g) {
        return obj -> g.apply((FailuresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailuresResponse> {
        /**
         * <p>
         * List of all failures.
         * </p>
         * 
         * @param failures
         *        List of all failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failures> failures);

        /**
         * <p>
         * List of all failures.
         * </p>
         * 
         * @param failures
         *        List of all failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failures... failures);

        /**
         * <p>
         * List of all failures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.Failures.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securitylake.model.Failures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.Failures.Builder#build()} is called immediately and
         * its result is passed to {@link #failures(List<Failures>)}.
         * 
         * @param failures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.Failures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<Failures>)
         */
        Builder failures(Consumer<Failures.Builder>... failures);

        /**
         * <p>
         * List of Regions where the failure occurred.
         * </p>
         * 
         * @param region
         *        List of Regions where the failure occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private List<Failures> failures = DefaultSdkAutoConstructList.getInstance();

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(FailuresResponse model) {
            failures(model.failures);
            region(model.region);
        }

        public final List<Failures.Builder> getFailures() {
            List<Failures.Builder> result = FailureslistCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failures.BuilderImpl> failures) {
            this.failures = FailureslistCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failures> failures) {
            this.failures = FailureslistCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failures... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failures.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failures.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public FailuresResponse build() {
            return new FailuresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
