/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLogSourcesRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<ListLogSourcesRequest.Builder, ListLogSourcesRequest> {
    private static final SdkField<List<String>> INPUT_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputOrder")
            .getter(getter(ListLogSourcesRequest::inputOrderAsStrings))
            .setter(setter(Builder::inputOrderWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Map<String, List<String>>>> LIST_ALL_DIMENSIONS_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("listAllDimensions")
            .getter(getter(ListLogSourcesRequest::listAllDimensions))
            .setter(setter(Builder::listAllDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAllDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<List<String>> LIST_SINGLE_DIMENSION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("listSingleDimension")
            .getter(getter(ListLogSourcesRequest::listSingleDimension))
            .setter(setter(Builder::listSingleDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listSingleDimension").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> LIST_TWO_DIMENSIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("listTwoDimensions")
            .getter(getter(ListLogSourcesRequest::listTwoDimensions))
            .setter(setter(Builder::listTwoDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listTwoDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLogSourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLogSourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ORDER_FIELD,
            LIST_ALL_DIMENSIONS_FIELD, LIST_SINGLE_DIMENSION_FIELD, LIST_TWO_DIMENSIONS_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> inputOrder;

    private final Map<String, Map<String, List<String>>> listAllDimensions;

    private final List<String> listSingleDimension;

    private final Map<String, List<String>> listTwoDimensions;

    private final Integer maxResults;

    private final String nextToken;

    private ListLogSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.inputOrder = builder.inputOrder;
        this.listAllDimensions = builder.listAllDimensions;
        this.listSingleDimension = builder.listSingleDimension;
        this.listTwoDimensions = builder.listTwoDimensions;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Lists the log sources in input order, namely Region, source type, and member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return Lists the log sources in input order, namely Region, source type, and member account.
     */
    public final List<Dimension> inputOrder() {
        return DimensionSetCopier.copyStringToEnum(inputOrder);
    }

    /**
     * For responses, this returns true if the service returned a value for the InputOrder property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputOrder() {
        return inputOrder != null && !(inputOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the log sources in input order, namely Region, source type, and member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return Lists the log sources in input order, namely Region, source type, and member account.
     */
    public final List<String> inputOrderAsStrings() {
        return inputOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListAllDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListAllDimensions() {
        return listAllDimensions != null && !(listAllDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List the view of log sources for enabled Security Lake accounts in all Regions and source types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListAllDimensions} method.
     * </p>
     * 
     * @return List the view of log sources for enabled Security Lake accounts in all Regions and source types.
     */
    public final Map<String, Map<String, List<String>>> listAllDimensions() {
        return listAllDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListSingleDimension property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListSingleDimension() {
        return listSingleDimension != null && !(listSingleDimension instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List the view of log sources for enabled Security Lake accounts for the entire region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListSingleDimension} method.
     * </p>
     * 
     * @return List the view of log sources for enabled Security Lake accounts for the entire region.
     */
    public final List<String> listSingleDimension() {
        return listSingleDimension;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListTwoDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListTwoDimensions() {
        return listTwoDimensions != null && !(listTwoDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Lists the log sources for the specified source types in enabled Security Lake accounts for the entire Region, for
     * selected member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListTwoDimensions} method.
     * </p>
     * 
     * @return Lists the log sources for the specified source types in enabled Security Lake accounts for the entire
     *         Region, for selected member accounts.
     */
    public final Map<String, List<String>> listTwoDimensions() {
        return listTwoDimensions;
    }

    /**
     * <p>
     * The maximum number of accounts for which the configuration is displayed.
     * </p>
     * 
     * @return The maximum number of accounts for which the configuration is displayed.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. You can make the call again using the returned token
     * to retrieve the next page.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. You can make the call again using the
     *         returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInputOrder() ? inputOrderAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListAllDimensions() ? listAllDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListSingleDimension() ? listSingleDimension() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListTwoDimensions() ? listTwoDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesRequest)) {
            return false;
        }
        ListLogSourcesRequest other = (ListLogSourcesRequest) obj;
        return hasInputOrder() == other.hasInputOrder() && Objects.equals(inputOrderAsStrings(), other.inputOrderAsStrings())
                && hasListAllDimensions() == other.hasListAllDimensions()
                && Objects.equals(listAllDimensions(), other.listAllDimensions())
                && hasListSingleDimension() == other.hasListSingleDimension()
                && Objects.equals(listSingleDimension(), other.listSingleDimension())
                && hasListTwoDimensions() == other.hasListTwoDimensions()
                && Objects.equals(listTwoDimensions(), other.listTwoDimensions())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLogSourcesRequest").add("InputOrder", hasInputOrder() ? inputOrderAsStrings() : null)
                .add("ListAllDimensions", hasListAllDimensions() ? listAllDimensions() : null)
                .add("ListSingleDimension", hasListSingleDimension() ? listSingleDimension() : null)
                .add("ListTwoDimensions", hasListTwoDimensions() ? listTwoDimensions() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputOrder":
            return Optional.ofNullable(clazz.cast(inputOrderAsStrings()));
        case "listAllDimensions":
            return Optional.ofNullable(clazz.cast(listAllDimensions()));
        case "listSingleDimension":
            return Optional.ofNullable(clazz.cast(listSingleDimension()));
        case "listTwoDimensions":
            return Optional.ofNullable(clazz.cast(listTwoDimensions()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogSourcesRequest, T> g) {
        return obj -> g.apply((ListLogSourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLogSourcesRequest> {
        /**
         * <p>
         * Lists the log sources in input order, namely Region, source type, and member account.
         * </p>
         * 
         * @param inputOrder
         *        Lists the log sources in input order, namely Region, source type, and member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(Collection<String> inputOrder);

        /**
         * <p>
         * Lists the log sources in input order, namely Region, source type, and member account.
         * </p>
         * 
         * @param inputOrder
         *        Lists the log sources in input order, namely Region, source type, and member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(String... inputOrder);

        /**
         * <p>
         * Lists the log sources in input order, namely Region, source type, and member account.
         * </p>
         * 
         * @param inputOrder
         *        Lists the log sources in input order, namely Region, source type, and member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Collection<Dimension> inputOrder);

        /**
         * <p>
         * Lists the log sources in input order, namely Region, source type, and member account.
         * </p>
         * 
         * @param inputOrder
         *        Lists the log sources in input order, namely Region, source type, and member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Dimension... inputOrder);

        /**
         * <p>
         * List the view of log sources for enabled Security Lake accounts in all Regions and source types.
         * </p>
         * 
         * @param listAllDimensions
         *        List the view of log sources for enabled Security Lake accounts in all Regions and source types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> listAllDimensions);

        /**
         * <p>
         * List the view of log sources for enabled Security Lake accounts for the entire region.
         * </p>
         * 
         * @param listSingleDimension
         *        List the view of log sources for enabled Security Lake accounts for the entire region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSingleDimension(Collection<String> listSingleDimension);

        /**
         * <p>
         * List the view of log sources for enabled Security Lake accounts for the entire region.
         * </p>
         * 
         * @param listSingleDimension
         *        List the view of log sources for enabled Security Lake accounts for the entire region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSingleDimension(String... listSingleDimension);

        /**
         * <p>
         * Lists the log sources for the specified source types in enabled Security Lake accounts for the entire Region,
         * for selected member accounts.
         * </p>
         * 
         * @param listTwoDimensions
         *        Lists the log sources for the specified source types in enabled Security Lake accounts for the entire
         *        Region, for selected member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listTwoDimensions(Map<String, ? extends Collection<String>> listTwoDimensions);

        /**
         * <p>
         * The maximum number of accounts for which the configuration is displayed.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of accounts for which the configuration is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If nextToken is returned, there are more results available. You can make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. You can make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<String> inputOrder = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Map<String, List<String>>> listAllDimensions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> listSingleDimension = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> listTwoDimensions = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogSourcesRequest model) {
            super(model);
            inputOrderWithStrings(model.inputOrder);
            listAllDimensions(model.listAllDimensions);
            listSingleDimension(model.listSingleDimension);
            listTwoDimensions(model.listTwoDimensions);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getInputOrder() {
            if (inputOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return inputOrder;
        }

        public final void setInputOrder(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
        }

        @Override
        public final Builder inputOrderWithStrings(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrderWithStrings(String... inputOrder) {
            inputOrderWithStrings(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public final Builder inputOrder(Collection<Dimension> inputOrder) {
            this.inputOrder = DimensionSetCopier.copyEnumToString(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrder(Dimension... inputOrder) {
            inputOrder(Arrays.asList(inputOrder));
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getListAllDimensions() {
            if (listAllDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return listAllDimensions;
        }

        public final void setListAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> listAllDimensions) {
            this.listAllDimensions = AllDimensionsMapCopier.copy(listAllDimensions);
        }

        @Override
        public final Builder listAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> listAllDimensions) {
            this.listAllDimensions = AllDimensionsMapCopier.copy(listAllDimensions);
            return this;
        }

        public final Collection<String> getListSingleDimension() {
            if (listSingleDimension instanceof SdkAutoConstructList) {
                return null;
            }
            return listSingleDimension;
        }

        public final void setListSingleDimension(Collection<String> listSingleDimension) {
            this.listSingleDimension = InputSetCopier.copy(listSingleDimension);
        }

        @Override
        public final Builder listSingleDimension(Collection<String> listSingleDimension) {
            this.listSingleDimension = InputSetCopier.copy(listSingleDimension);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listSingleDimension(String... listSingleDimension) {
            listSingleDimension(Arrays.asList(listSingleDimension));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getListTwoDimensions() {
            if (listTwoDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return listTwoDimensions;
        }

        public final void setListTwoDimensions(Map<String, ? extends Collection<String>> listTwoDimensions) {
            this.listTwoDimensions = TwoDimensionsMapCopier.copy(listTwoDimensions);
        }

        @Override
        public final Builder listTwoDimensions(Map<String, ? extends Collection<String>> listTwoDimensions) {
            this.listTwoDimensions = TwoDimensionsMapCopier.copy(listTwoDimensions);
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLogSourcesRequest build() {
            return new ListLogSourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
