/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retention settings for the destination Amazon S3 buckets in Security Lake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionSetting.Builder, RetentionSetting> {
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriod").getter(getter(RetentionSetting::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageClass").getter(getter(RetentionSetting::storageClassAsString))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_FIELD,
            STORAGE_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer retentionPeriod;

    private final String storageClass;

    private RetentionSetting(BuilderImpl builder) {
        this.retentionPeriod = builder.retentionPeriod;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * The retention period specifies a fixed period of time during which the Security Lake object remains locked. You
     * can specify the retention period for one or more source in days.
     * </p>
     * 
     * @return The retention period specifies a fixed period of time during which the Security Lake object remains
     *         locked. You can specify the retention period for one or more source in days.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements
     * of your workloads.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The range of storage classes that you can choose from based on the data access, resiliency, and cost
     *         requirements of your workloads.
     * @see StorageClass
     */
    public final StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements
     * of your workloads.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The range of storage classes that you can choose from based on the data access, resiliency, and cost
     *         requirements of your workloads.
     * @see StorageClass
     */
    public final String storageClassAsString() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionSetting)) {
            return false;
        }
        RetentionSetting other = (RetentionSetting) obj;
        return Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(storageClassAsString(), other.storageClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionSetting").add("RetentionPeriod", retentionPeriod())
                .add("StorageClass", storageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "storageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionSetting, T> g) {
        return obj -> g.apply((RetentionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionSetting> {
        /**
         * <p>
         * The retention period specifies a fixed period of time during which the Security Lake object remains locked.
         * You can specify the retention period for one or more source in days.
         * </p>
         * 
         * @param retentionPeriod
         *        The retention period specifies a fixed period of time during which the Security Lake object remains
         *        locked. You can specify the retention period for one or more source in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * The range of storage classes that you can choose from based on the data access, resiliency, and cost
         * requirements of your workloads.
         * </p>
         * 
         * @param storageClass
         *        The range of storage classes that you can choose from based on the data access, resiliency, and cost
         *        requirements of your workloads.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * The range of storage classes that you can choose from based on the data access, resiliency, and cost
         * requirements of your workloads.
         * </p>
         * 
         * @param storageClass
         *        The range of storage classes that you can choose from based on the data access, resiliency, and cost
         *        requirements of your workloads.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);
    }

    static final class BuilderImpl implements Builder {
        private Integer retentionPeriod;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionSetting model) {
            retentionPeriod(model.retentionPeriod);
            storageClass(model.storageClass);
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        @Override
        public RetentionSetting build() {
            return new RetentionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
