/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The supported source types from which logs and events are collected in Amazon Security Lake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceType implements SdkPojo, Serializable, ToCopyableBuilder<SourceType.Builder, SourceType> {
    private static final SdkField<String> AWS_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsSourceType").getter(getter(SourceType::awsSourceTypeAsString)).setter(setter(Builder::awsSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSourceType").build()).build();

    private static final SdkField<String> CUSTOM_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customSourceType").getter(getter(SourceType::customSourceType))
            .setter(setter(Builder::customSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customSourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SOURCE_TYPE_FIELD,
            CUSTOM_SOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsSourceType;

    private final String customSourceType;

    private final Type type;

    private SourceType(BuilderImpl builder) {
        this.awsSourceType = builder.awsSourceType;
        this.customSourceType = builder.customSourceType;
        this.type = builder.type;
    }

    /**
     * <p>
     * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services. For
     * more information, see the Amazon Security Lake User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsSourceType}
     * will return {@link AwsLogSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsSourceTypeAsString}.
     * </p>
     * 
     * @return Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
     *         services. For more information, see the Amazon Security Lake User Guide.
     * @see AwsLogSourceType
     */
    public final AwsLogSourceType awsSourceType() {
        return AwsLogSourceType.fromValue(awsSourceType);
    }

    /**
     * <p>
     * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services. For
     * more information, see the Amazon Security Lake User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsSourceType}
     * will return {@link AwsLogSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsSourceTypeAsString}.
     * </p>
     * 
     * @return Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
     *         services. For more information, see the Amazon Security Lake User Guide.
     * @see AwsLogSourceType
     */
    public final String awsSourceTypeAsString() {
        return awsSourceType;
    }

    /**
     * <p>
     * Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake User
     * Guide.
     * </p>
     * 
     * @return Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake
     *         User Guide.
     */
    public final String customSourceType() {
        return customSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customSourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceType)) {
            return false;
        }
        SourceType other = (SourceType) obj;
        return Objects.equals(awsSourceTypeAsString(), other.awsSourceTypeAsString())
                && Objects.equals(customSourceType(), other.customSourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceType").add("AwsSourceType", awsSourceTypeAsString())
                .add("CustomSourceType", customSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsSourceType":
            return Optional.ofNullable(clazz.cast(awsSourceTypeAsString()));
        case "customSourceType":
            return Optional.ofNullable(clazz.cast(customSourceType()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsSourceTypeAsString()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services. For
     * more information, see the Amazon Security Lake User Guide.
     * </p>
     * 
     * @param awsSourceType
     *        Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
     *        services. For more information, see the Amazon Security Lake User Guide.
     * @see AwsLogSourceType
     */
    public static SourceType fromAwsSourceType(String awsSourceType) {
        return builder().awsSourceType(awsSourceType).build();
    }

    /**
     * Create an instance of this class with {@link #awsSourceTypeAsString()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services. For
     * more information, see the Amazon Security Lake User Guide.
     * </p>
     * 
     * @param awsSourceType
     *        Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
     *        services. For more information, see the Amazon Security Lake User Guide.
     * @see AwsLogSourceType
     */
    public static SourceType fromAwsSourceType(AwsLogSourceType awsSourceType) {
        return builder().awsSourceType(awsSourceType).build();
    }

    /**
     * Create an instance of this class with {@link #customSourceType()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake User
     * Guide.
     * </p>
     * 
     * @param customSourceType
     *        Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake
     *        User Guide.
     */
    public static SourceType fromCustomSourceType(String customSourceType) {
        return builder().customSourceType(customSourceType).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceType, T> g) {
        return obj -> g.apply((SourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceType> {
        /**
         * <p>
         * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services.
         * For more information, see the Amazon Security Lake User Guide.
         * </p>
         * 
         * @param awsSourceType
         *        Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
         *        services. For more information, see the Amazon Security Lake User Guide.
         * @see AwsLogSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceType
         */
        Builder awsSourceType(String awsSourceType);

        /**
         * <p>
         * Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services services.
         * For more information, see the Amazon Security Lake User Guide.
         * </p>
         * 
         * @param awsSourceType
         *        Amazon Security Lake supports logs and events collection for natively-supported Amazon Web Services
         *        services. For more information, see the Amazon Security Lake User Guide.
         * @see AwsLogSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceType
         */
        Builder awsSourceType(AwsLogSourceType awsSourceType);

        /**
         * <p>
         * Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake User
         * Guide.
         * </p>
         * 
         * @param customSourceType
         *        Amazon Security Lake supports custom source types. For the detailed list, see the Amazon Security Lake
         *        User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSourceType(String customSourceType);
    }

    static final class BuilderImpl implements Builder {
        private String awsSourceType;

        private String customSourceType;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceType model) {
            awsSourceType(model.awsSourceType);
            customSourceType(model.customSourceType);
        }

        public final String getAwsSourceType() {
            return awsSourceType;
        }

        public final void setAwsSourceType(String awsSourceType) {
            Object oldValue = this.awsSourceType;
            this.awsSourceType = awsSourceType;
            handleUnionValueChange(Type.AWS_SOURCE_TYPE, oldValue, this.awsSourceType);
        }

        @Override
        public final Builder awsSourceType(String awsSourceType) {
            Object oldValue = this.awsSourceType;
            this.awsSourceType = awsSourceType;
            handleUnionValueChange(Type.AWS_SOURCE_TYPE, oldValue, this.awsSourceType);
            return this;
        }

        @Override
        public final Builder awsSourceType(AwsLogSourceType awsSourceType) {
            this.awsSourceType(awsSourceType == null ? null : awsSourceType.toString());
            return this;
        }

        public final String getCustomSourceType() {
            return customSourceType;
        }

        public final void setCustomSourceType(String customSourceType) {
            Object oldValue = this.customSourceType;
            this.customSourceType = customSourceType;
            handleUnionValueChange(Type.CUSTOM_SOURCE_TYPE, oldValue, this.customSourceType);
        }

        @Override
        public final Builder customSourceType(String customSourceType) {
            Object oldValue = this.customSourceType;
            this.customSourceType = customSourceType;
            handleUnionValueChange(Type.CUSTOM_SOURCE_TYPE, oldValue, this.customSourceType);
            return this;
        }

        @Override
        public SourceType build() {
            return new SourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SourceType#type()
     */
    public enum Type {
        AWS_SOURCE_TYPE,

        CUSTOM_SOURCE_TYPE,

        UNKNOWN_TO_SDK_VERSION
    }
}
