/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Automatically enable new organization accounts as member accounts from a Security Lake administrator account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoEnableNewRegionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoEnableNewRegionConfiguration.Builder, AutoEnableNewRegionConfiguration> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(AutoEnableNewRegionConfiguration::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<String>> SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(AutoEnableNewRegionConfiguration::sourcesAsStrings))
            .setter(setter(Builder::sourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final List<String> sources;

    private AutoEnableNewRegionConfiguration(BuilderImpl builder) {
        this.region = builder.region;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The Regions where Security Lake is auto enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link Region#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The Regions where Security Lake is auto enabled
     * @see Region
     */
    public final Region region() {
        return Region.fromValue(region);
    }

    /**
     * <p>
     * The Regions where Security Lake is auto enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link Region#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The Regions where Security Lake is auto enabled
     * @see Region
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * The Amazon Web Services sources which are auto enabled in Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The Amazon Web Services sources which are auto enabled in Security Lake.
     */
    public final List<AwsLogSourceType> sources() {
        return AwsSourceTypeListCopier.copyStringToEnum(sources);
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services sources which are auto enabled in Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The Amazon Web Services sources which are auto enabled in Security Lake.
     */
    public final List<String> sourcesAsStrings() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sourcesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEnableNewRegionConfiguration)) {
            return false;
        }
        AutoEnableNewRegionConfiguration other = (AutoEnableNewRegionConfiguration) obj;
        return Objects.equals(regionAsString(), other.regionAsString()) && hasSources() == other.hasSources()
                && Objects.equals(sourcesAsStrings(), other.sourcesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoEnableNewRegionConfiguration").add("Region", regionAsString())
                .add("Sources", hasSources() ? sourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sourcesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoEnableNewRegionConfiguration, T> g) {
        return obj -> g.apply((AutoEnableNewRegionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoEnableNewRegionConfiguration> {
        /**
         * <p>
         * The Regions where Security Lake is auto enabled
         * </p>
         * 
         * @param region
         *        The Regions where Security Lake is auto enabled
         * @see Region
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Region
         */
        Builder region(String region);

        /**
         * <p>
         * The Regions where Security Lake is auto enabled
         * </p>
         * 
         * @param region
         *        The Regions where Security Lake is auto enabled
         * @see Region
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Region
         */
        Builder region(Region region);

        /**
         * <p>
         * The Amazon Web Services sources which are auto enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources which are auto enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcesWithStrings(Collection<String> sources);

        /**
         * <p>
         * The Amazon Web Services sources which are auto enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources which are auto enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcesWithStrings(String... sources);

        /**
         * <p>
         * The Amazon Web Services sources which are auto enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources which are auto enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<AwsLogSourceType> sources);

        /**
         * <p>
         * The Amazon Web Services sources which are auto enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources which are auto enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(AwsLogSourceType... sources);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private List<String> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoEnableNewRegionConfiguration model) {
            region(model.region);
            sourcesWithStrings(model.sources);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(Region region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final Collection<String> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = AwsSourceTypeListCopier.copy(sources);
        }

        @Override
        public final Builder sourcesWithStrings(Collection<String> sources) {
            this.sources = AwsSourceTypeListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcesWithStrings(String... sources) {
            sourcesWithStrings(Arrays.asList(sources));
            return this;
        }

        @Override
        public final Builder sources(Collection<AwsLogSourceType> sources) {
            this.sources = AwsSourceTypeListCopier.copyEnumToString(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AwsLogSourceType... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        public AutoEnableNewRegionConfiguration build() {
            return new AutoEnableNewRegionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
