/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomLogSourceRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateCustomLogSourceRequest.Builder, CreateCustomLogSourceRequest> {
    private static final SdkField<String> CUSTOM_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customSourceName").getter(getter(CreateCustomLogSourceRequest::customSourceName))
            .setter(setter(Builder::customSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customSourceName").build()).build();

    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventClass").getter(getter(CreateCustomLogSourceRequest::eventClassAsString))
            .setter(setter(Builder::eventClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClass").build()).build();

    private static final SdkField<String> GLUE_INVOCATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueInvocationRoleArn").getter(getter(CreateCustomLogSourceRequest::glueInvocationRoleArn))
            .setter(setter(Builder::glueInvocationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueInvocationRoleArn").build())
            .build();

    private static final SdkField<String> LOG_PROVIDER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logProviderAccountId").getter(getter(CreateCustomLogSourceRequest::logProviderAccountId))
            .setter(setter(Builder::logProviderAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logProviderAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_SOURCE_NAME_FIELD,
            EVENT_CLASS_FIELD, GLUE_INVOCATION_ROLE_ARN_FIELD, LOG_PROVIDER_ACCOUNT_ID_FIELD));

    private final String customSourceName;

    private final String eventClass;

    private final String glueInvocationRoleArn;

    private final String logProviderAccountId;

    private CreateCustomLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.customSourceName = builder.customSourceName;
        this.eventClass = builder.eventClass;
        this.glueInvocationRoleArn = builder.glueInvocationRoleArn;
        this.logProviderAccountId = builder.logProviderAccountId;
    }

    /**
     * <p>
     * The custom source name for a third-party custom source.
     * </p>
     * 
     * @return The custom source name for a third-party custom source.
     */
    public final String customSourceName() {
        return customSourceName;
    }

    /**
     * <p>
     * The Open Cybersecurity Schema Framework (OCSF) event class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link OcsfEventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The Open Cybersecurity Schema Framework (OCSF) event class.
     * @see OcsfEventClass
     */
    public final OcsfEventClass eventClass() {
        return OcsfEventClass.fromValue(eventClass);
    }

    /**
     * <p>
     * The Open Cybersecurity Schema Framework (OCSF) event class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link OcsfEventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The Open Cybersecurity Schema Framework (OCSF) event class.
     * @see OcsfEventClass
     */
    public final String eventClassAsString() {
        return eventClass;
    }

    /**
     * <p>
     * The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed policy <code>AWSGlueServiceRole</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom policy granting access to your S3 Data Lake
     * </p>
     * </li>
     * </ul>
     * 
     * @return The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed policy <code>AWSGlueServiceRole</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom policy granting access to your S3 Data Lake
     *         </p>
     *         </li>
     */
    public final String glueInvocationRoleArn() {
        return glueInvocationRoleArn;
    }

    /**
     * <p>
     * The Account ID that will assume the above Role to put logs into the Data Lake.
     * </p>
     * 
     * @return The Account ID that will assume the above Role to put logs into the Data Lake.
     */
    public final String logProviderAccountId() {
        return logProviderAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(glueInvocationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logProviderAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceRequest)) {
            return false;
        }
        CreateCustomLogSourceRequest other = (CreateCustomLogSourceRequest) obj;
        return Objects.equals(customSourceName(), other.customSourceName())
                && Objects.equals(eventClassAsString(), other.eventClassAsString())
                && Objects.equals(glueInvocationRoleArn(), other.glueInvocationRoleArn())
                && Objects.equals(logProviderAccountId(), other.logProviderAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomLogSourceRequest").add("CustomSourceName", customSourceName())
                .add("EventClass", eventClassAsString()).add("GlueInvocationRoleArn", glueInvocationRoleArn())
                .add("LogProviderAccountId", logProviderAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customSourceName":
            return Optional.ofNullable(clazz.cast(customSourceName()));
        case "eventClass":
            return Optional.ofNullable(clazz.cast(eventClassAsString()));
        case "glueInvocationRoleArn":
            return Optional.ofNullable(clazz.cast(glueInvocationRoleArn()));
        case "logProviderAccountId":
            return Optional.ofNullable(clazz.cast(logProviderAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceRequest, T> g) {
        return obj -> g.apply((CreateCustomLogSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomLogSourceRequest> {
        /**
         * <p>
         * The custom source name for a third-party custom source.
         * </p>
         * 
         * @param customSourceName
         *        The custom source name for a third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSourceName(String customSourceName);

        /**
         * <p>
         * The Open Cybersecurity Schema Framework (OCSF) event class.
         * </p>
         * 
         * @param eventClass
         *        The Open Cybersecurity Schema Framework (OCSF) event class.
         * @see OcsfEventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OcsfEventClass
         */
        Builder eventClass(String eventClass);

        /**
         * <p>
         * The Open Cybersecurity Schema Framework (OCSF) event class.
         * </p>
         * 
         * @param eventClass
         *        The Open Cybersecurity Schema Framework (OCSF) event class.
         * @see OcsfEventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OcsfEventClass
         */
        Builder eventClass(OcsfEventClass eventClass);

        /**
         * <p>
         * The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed policy <code>AWSGlueServiceRole</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom policy granting access to your S3 Data Lake
         * </p>
         * </li>
         * </ul>
         * 
         * @param glueInvocationRoleArn
         *        The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed policy <code>AWSGlueServiceRole</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom policy granting access to your S3 Data Lake
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueInvocationRoleArn(String glueInvocationRoleArn);

        /**
         * <p>
         * The Account ID that will assume the above Role to put logs into the Data Lake.
         * </p>
         * 
         * @param logProviderAccountId
         *        The Account ID that will assume the above Role to put logs into the Data Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logProviderAccountId(String logProviderAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private String customSourceName;

        private String eventClass;

        private String glueInvocationRoleArn;

        private String logProviderAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceRequest model) {
            super(model);
            customSourceName(model.customSourceName);
            eventClass(model.eventClass);
            glueInvocationRoleArn(model.glueInvocationRoleArn);
            logProviderAccountId(model.logProviderAccountId);
        }

        public final String getCustomSourceName() {
            return customSourceName;
        }

        public final void setCustomSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
        }

        @Override
        public final Builder customSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
            return this;
        }

        public final String getEventClass() {
            return eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(OcsfEventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final String getGlueInvocationRoleArn() {
            return glueInvocationRoleArn;
        }

        public final void setGlueInvocationRoleArn(String glueInvocationRoleArn) {
            this.glueInvocationRoleArn = glueInvocationRoleArn;
        }

        @Override
        public final Builder glueInvocationRoleArn(String glueInvocationRoleArn) {
            this.glueInvocationRoleArn = glueInvocationRoleArn;
            return this;
        }

        public final String getLogProviderAccountId() {
            return logProviderAccountId;
        }

        public final void setLogProviderAccountId(String logProviderAccountId) {
            this.logProviderAccountId = logProviderAccountId;
        }

        @Override
        public final Builder logProviderAccountId(String logProviderAccountId) {
            this.logProviderAccountId = logProviderAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLogSourceRequest build() {
            return new CreateCustomLogSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
