/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatalakeRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateDatalakeRequest.Builder, CreateDatalakeRequest> {
    private static final SdkField<Map<String, LakeConfigurationRequest>> CONFIGURATIONS_FIELD = SdkField
            .<Map<String, LakeConfigurationRequest>> builder(MarshallingType.MAP)
            .memberName("configurations")
            .getter(getter(CreateDatalakeRequest::configurationsAsStrings))
            .setter(setter(Builder::configurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LakeConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LakeConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAll").getter(getter(CreateDatalakeRequest::enableAll)).setter(setter(Builder::enableAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAll").build()).build();

    private static final SdkField<String> META_STORE_MANAGER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaStoreManagerRoleArn").getter(getter(CreateDatalakeRequest::metaStoreManagerRoleArn))
            .setter(setter(Builder::metaStoreManagerRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaStoreManagerRoleArn").build())
            .build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(CreateDatalakeRequest::regionsAsStrings))
            .setter(setter(Builder::regionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD,
            ENABLE_ALL_FIELD, META_STORE_MANAGER_ROLE_ARN_FIELD, REGIONS_FIELD));

    private final Map<String, LakeConfigurationRequest> configurations;

    private final Boolean enableAll;

    private final String metaStoreManagerRoleArn;

    private final List<String> regions;

    private CreateDatalakeRequest(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.enableAll = builder.enableAll;
        this.metaStoreManagerRoleArn = builder.metaStoreManagerRoleArn;
        this.regions = builder.regions;
    }

    /**
     * <p>
     * Enable Security Lake with the specified configurations settings to begin ingesting security data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Enable Security Lake with the specified configurations settings to begin ingesting security data.
     */
    public final Map<Region, LakeConfigurationRequest> configurations() {
        return LakeConfigurationRequestMapCopier.copyStringToEnum(configurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Enable Security Lake with the specified configurations settings to begin ingesting security data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Enable Security Lake with the specified configurations settings to begin ingesting security data.
     */
    public final Map<String, LakeConfigurationRequest> configurationsAsStrings() {
        return configurations;
    }

    /**
     * <p>
     * Enable Security Lake in all Regions to begin ingesting security data.
     * </p>
     * 
     * @return Enable Security Lake in all Regions to begin ingesting security data.
     */
    public final Boolean enableAll() {
        return enableAll;
    }

    /**
     * <p>
     * The Role ARN used to create and update the Glue table with partitions generated by ingestion and normalization of
     * Amazon Web Services log sources and custom sources.
     * </p>
     * 
     * @return The Role ARN used to create and update the Glue table with partitions generated by ingestion and
     *         normalization of Amazon Web Services log sources and custom sources.
     */
    public final String metaStoreManagerRoleArn() {
        return metaStoreManagerRoleArn;
    }

    /**
     * <p>
     * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
     * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a list
     * of Region codes, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region
     * codes</a> in the Amazon Web Services General Reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake
     *         in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes.
     *         For a list of Region codes, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
     *         the Amazon Web Services General Reference.
     */
    public final List<Region> regions() {
        return RegionSetCopier.copyStringToEnum(regions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
     * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a list
     * of Region codes, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region
     * codes</a> in the Amazon Web Services General Reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake
     *         in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes.
     *         For a list of Region codes, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
     *         the Amazon Web Services General Reference.
     */
    public final List<String> regionsAsStrings() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableAll());
        hashCode = 31 * hashCode + Objects.hashCode(metaStoreManagerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatalakeRequest)) {
            return false;
        }
        CreateDatalakeRequest other = (CreateDatalakeRequest) obj;
        return hasConfigurations() == other.hasConfigurations()
                && Objects.equals(configurationsAsStrings(), other.configurationsAsStrings())
                && Objects.equals(enableAll(), other.enableAll())
                && Objects.equals(metaStoreManagerRoleArn(), other.metaStoreManagerRoleArn())
                && hasRegions() == other.hasRegions() && Objects.equals(regionsAsStrings(), other.regionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatalakeRequest")
                .add("Configurations", hasConfigurations() ? configurationsAsStrings() : null).add("EnableAll", enableAll())
                .add("MetaStoreManagerRoleArn", metaStoreManagerRoleArn())
                .add("Regions", hasRegions() ? regionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurationsAsStrings()));
        case "enableAll":
            return Optional.ofNullable(clazz.cast(enableAll()));
        case "metaStoreManagerRoleArn":
            return Optional.ofNullable(clazz.cast(metaStoreManagerRoleArn()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatalakeRequest, T> g) {
        return obj -> g.apply((CreateDatalakeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatalakeRequest> {
        /**
         * <p>
         * Enable Security Lake with the specified configurations settings to begin ingesting security data.
         * </p>
         * 
         * @param configurations
         *        Enable Security Lake with the specified configurations settings to begin ingesting security data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationsWithStrings(Map<String, LakeConfigurationRequest> configurations);

        /**
         * <p>
         * Enable Security Lake with the specified configurations settings to begin ingesting security data.
         * </p>
         * 
         * @param configurations
         *        Enable Security Lake with the specified configurations settings to begin ingesting security data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Map<Region, LakeConfigurationRequest> configurations);

        /**
         * <p>
         * Enable Security Lake in all Regions to begin ingesting security data.
         * </p>
         * 
         * @param enableAll
         *        Enable Security Lake in all Regions to begin ingesting security data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAll(Boolean enableAll);

        /**
         * <p>
         * The Role ARN used to create and update the Glue table with partitions generated by ingestion and
         * normalization of Amazon Web Services log sources and custom sources.
         * </p>
         * 
         * @param metaStoreManagerRoleArn
         *        The Role ARN used to create and update the Glue table with partitions generated by ingestion and
         *        normalization of Amazon Web Services log sources and custom sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn);

        /**
         * <p>
         * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
         * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a
         * list of Region codes, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in the
         * Amazon Web Services General Reference.
         * </p>
         * 
         * @param regions
         *        Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security
         *        Lake in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region
         *        codes. For a list of Region codes, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
         *        the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsWithStrings(Collection<String> regions);

        /**
         * <p>
         * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
         * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a
         * list of Region codes, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in the
         * Amazon Web Services General Reference.
         * </p>
         * 
         * @param regions
         *        Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security
         *        Lake in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region
         *        codes. For a list of Region codes, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
         *        the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsWithStrings(String... regions);

        /**
         * <p>
         * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
         * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a
         * list of Region codes, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in the
         * Amazon Web Services General Reference.
         * </p>
         * 
         * @param regions
         *        Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security
         *        Lake in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region
         *        codes. For a list of Region codes, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
         *        the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<Region> regions);

        /**
         * <p>
         * Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security Lake in
         * specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region codes. For a
         * list of Region codes, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in the
         * Amazon Web Services General Reference.
         * </p>
         * 
         * @param regions
         *        Enable Security Lake in the specified Regions to begin ingesting security data. To enable Security
         *        Lake in specific Amazon Web Services Regions, such as us-east-1 or ap-northeast-3, provide the Region
         *        codes. For a list of Region codes, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Region codes</a> in
         *        the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Region... regions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private Map<String, LakeConfigurationRequest> configurations = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableAll;

        private String metaStoreManagerRoleArn;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatalakeRequest model) {
            super(model);
            configurationsWithStrings(model.configurations);
            enableAll(model.enableAll);
            metaStoreManagerRoleArn(model.metaStoreManagerRoleArn);
            regionsWithStrings(model.regions);
        }

        public final Map<String, LakeConfigurationRequest.Builder> getConfigurations() {
            Map<String, LakeConfigurationRequest.Builder> result = LakeConfigurationRequestMapCopier
                    .copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Map<String, LakeConfigurationRequest.BuilderImpl> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurationsWithStrings(Map<String, LakeConfigurationRequest> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copy(configurations);
            return this;
        }

        @Override
        public final Builder configurations(Map<Region, LakeConfigurationRequest> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copyEnumToString(configurations);
            return this;
        }

        public final Boolean getEnableAll() {
            return enableAll;
        }

        public final void setEnableAll(Boolean enableAll) {
            this.enableAll = enableAll;
        }

        @Override
        public final Builder enableAll(Boolean enableAll) {
            this.enableAll = enableAll;
            return this;
        }

        public final String getMetaStoreManagerRoleArn() {
            return metaStoreManagerRoleArn;
        }

        public final void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
        }

        @Override
        public final Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionSetCopier.copy(regions);
        }

        @Override
        public final Builder regionsWithStrings(Collection<String> regions) {
            this.regions = RegionSetCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsWithStrings(String... regions) {
            regionsWithStrings(Arrays.asList(regions));
            return this;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionSetCopier.copyEnumToString(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatalakeRequest build() {
            return new CreateDatalakeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
