/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAwsLogSourceRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<DeleteAwsLogSourceRequest.Builder, DeleteAwsLogSourceRequest> {
    private static final SdkField<Map<String, Map<String, List<String>>>> DISABLE_ALL_DIMENSIONS_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("disableAllDimensions")
            .getter(getter(DeleteAwsLogSourceRequest::disableAllDimensions))
            .setter(setter(Builder::disableAllDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableAllDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<List<String>> DISABLE_SINGLE_DIMENSION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("disableSingleDimension")
            .getter(getter(DeleteAwsLogSourceRequest::disableSingleDimension))
            .setter(setter(Builder::disableSingleDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSingleDimension").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> DISABLE_TWO_DIMENSIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("disableTwoDimensions")
            .getter(getter(DeleteAwsLogSourceRequest::disableTwoDimensions))
            .setter(setter(Builder::disableTwoDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableTwoDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> INPUT_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputOrder")
            .getter(getter(DeleteAwsLogSourceRequest::inputOrderAsStrings))
            .setter(setter(Builder::inputOrderWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_ALL_DIMENSIONS_FIELD,
            DISABLE_SINGLE_DIMENSION_FIELD, DISABLE_TWO_DIMENSIONS_FIELD, INPUT_ORDER_FIELD));

    private final Map<String, Map<String, List<String>>> disableAllDimensions;

    private final List<String> disableSingleDimension;

    private final Map<String, List<String>> disableTwoDimensions;

    private final List<String> inputOrder;

    private DeleteAwsLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.disableAllDimensions = builder.disableAllDimensions;
        this.disableSingleDimension = builder.disableSingleDimension;
        this.disableTwoDimensions = builder.disableTwoDimensions;
        this.inputOrder = builder.inputOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisableAllDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisableAllDimensions() {
        return disableAllDimensions != null && !(disableAllDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Removes the specific Amazon Web Services sources from all Regions and source types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisableAllDimensions} method.
     * </p>
     * 
     * @return Removes the specific Amazon Web Services sources from all Regions and source types.
     */
    public final Map<String, Map<String, List<String>>> disableAllDimensions() {
        return disableAllDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisableSingleDimension property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDisableSingleDimension() {
        return disableSingleDimension != null && !(disableSingleDimension instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Removes all Amazon Web Services sources from specific accounts or Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisableSingleDimension} method.
     * </p>
     * 
     * @return Removes all Amazon Web Services sources from specific accounts or Regions.
     */
    public final List<String> disableSingleDimension() {
        return disableSingleDimension;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisableTwoDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisableTwoDimensions() {
        return disableTwoDimensions != null && !(disableTwoDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Remove a specific Amazon Web Services source from specific accounts or Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisableTwoDimensions} method.
     * </p>
     * 
     * @return Remove a specific Amazon Web Services source from specific accounts or Regions.
     */
    public final Map<String, List<String>> disableTwoDimensions() {
        return disableTwoDimensions;
    }

    /**
     * <p>
     * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
     * source type, and member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
     *         Region, source type, and member.
     */
    public final List<Dimension> inputOrder() {
        return DimensionSetCopier.copyStringToEnum(inputOrder);
    }

    /**
     * For responses, this returns true if the service returned a value for the InputOrder property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputOrder() {
        return inputOrder != null && !(inputOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
     * source type, and member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputOrder} method.
     * </p>
     * 
     * @return This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
     *         Region, source type, and member.
     */
    public final List<String> inputOrderAsStrings() {
        return inputOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDisableAllDimensions() ? disableAllDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisableSingleDimension() ? disableSingleDimension() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisableTwoDimensions() ? disableTwoDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputOrder() ? inputOrderAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAwsLogSourceRequest)) {
            return false;
        }
        DeleteAwsLogSourceRequest other = (DeleteAwsLogSourceRequest) obj;
        return hasDisableAllDimensions() == other.hasDisableAllDimensions()
                && Objects.equals(disableAllDimensions(), other.disableAllDimensions())
                && hasDisableSingleDimension() == other.hasDisableSingleDimension()
                && Objects.equals(disableSingleDimension(), other.disableSingleDimension())
                && hasDisableTwoDimensions() == other.hasDisableTwoDimensions()
                && Objects.equals(disableTwoDimensions(), other.disableTwoDimensions())
                && hasInputOrder() == other.hasInputOrder() && Objects.equals(inputOrderAsStrings(), other.inputOrderAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAwsLogSourceRequest")
                .add("DisableAllDimensions", hasDisableAllDimensions() ? disableAllDimensions() : null)
                .add("DisableSingleDimension", hasDisableSingleDimension() ? disableSingleDimension() : null)
                .add("DisableTwoDimensions", hasDisableTwoDimensions() ? disableTwoDimensions() : null)
                .add("InputOrder", hasInputOrder() ? inputOrderAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disableAllDimensions":
            return Optional.ofNullable(clazz.cast(disableAllDimensions()));
        case "disableSingleDimension":
            return Optional.ofNullable(clazz.cast(disableSingleDimension()));
        case "disableTwoDimensions":
            return Optional.ofNullable(clazz.cast(disableTwoDimensions()));
        case "inputOrder":
            return Optional.ofNullable(clazz.cast(inputOrderAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAwsLogSourceRequest, T> g) {
        return obj -> g.apply((DeleteAwsLogSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAwsLogSourceRequest> {
        /**
         * <p>
         * Removes the specific Amazon Web Services sources from all Regions and source types.
         * </p>
         * 
         * @param disableAllDimensions
         *        Removes the specific Amazon Web Services sources from all Regions and source types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> disableAllDimensions);

        /**
         * <p>
         * Removes all Amazon Web Services sources from specific accounts or Regions.
         * </p>
         * 
         * @param disableSingleDimension
         *        Removes all Amazon Web Services sources from specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSingleDimension(Collection<String> disableSingleDimension);

        /**
         * <p>
         * Removes all Amazon Web Services sources from specific accounts or Regions.
         * </p>
         * 
         * @param disableSingleDimension
         *        Removes all Amazon Web Services sources from specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSingleDimension(String... disableSingleDimension);

        /**
         * <p>
         * Remove a specific Amazon Web Services source from specific accounts or Regions.
         * </p>
         * 
         * @param disableTwoDimensions
         *        Remove a specific Amazon Web Services source from specific accounts or Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableTwoDimensions(Map<String, ? extends Collection<String>> disableTwoDimensions);

        /**
         * <p>
         * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
         * source type, and member.
         * </p>
         * 
         * @param inputOrder
         *        This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
         *        Region, source type, and member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(Collection<String> inputOrder);

        /**
         * <p>
         * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
         * source type, and member.
         * </p>
         * 
         * @param inputOrder
         *        This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
         *        Region, source type, and member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrderWithStrings(String... inputOrder);

        /**
         * <p>
         * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
         * source type, and member.
         * </p>
         * 
         * @param inputOrder
         *        This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
         *        Region, source type, and member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Collection<Dimension> inputOrder);

        /**
         * <p>
         * This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely Region,
         * source type, and member.
         * </p>
         * 
         * @param inputOrder
         *        This is a mandatory input. Specifies the input order to disable dimensions in Security Lake, namely
         *        Region, source type, and member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputOrder(Dimension... inputOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private Map<String, Map<String, List<String>>> disableAllDimensions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> disableSingleDimension = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> disableTwoDimensions = DefaultSdkAutoConstructMap.getInstance();

        private List<String> inputOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAwsLogSourceRequest model) {
            super(model);
            disableAllDimensions(model.disableAllDimensions);
            disableSingleDimension(model.disableSingleDimension);
            disableTwoDimensions(model.disableTwoDimensions);
            inputOrderWithStrings(model.inputOrder);
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getDisableAllDimensions() {
            if (disableAllDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return disableAllDimensions;
        }

        public final void setDisableAllDimensions(
                Map<String, ? extends Map<String, ? extends Collection<String>>> disableAllDimensions) {
            this.disableAllDimensions = AllDimensionsMapCopier.copy(disableAllDimensions);
        }

        @Override
        public final Builder disableAllDimensions(
                Map<String, ? extends Map<String, ? extends Collection<String>>> disableAllDimensions) {
            this.disableAllDimensions = AllDimensionsMapCopier.copy(disableAllDimensions);
            return this;
        }

        public final Collection<String> getDisableSingleDimension() {
            if (disableSingleDimension instanceof SdkAutoConstructList) {
                return null;
            }
            return disableSingleDimension;
        }

        public final void setDisableSingleDimension(Collection<String> disableSingleDimension) {
            this.disableSingleDimension = InputSetCopier.copy(disableSingleDimension);
        }

        @Override
        public final Builder disableSingleDimension(Collection<String> disableSingleDimension) {
            this.disableSingleDimension = InputSetCopier.copy(disableSingleDimension);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disableSingleDimension(String... disableSingleDimension) {
            disableSingleDimension(Arrays.asList(disableSingleDimension));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getDisableTwoDimensions() {
            if (disableTwoDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return disableTwoDimensions;
        }

        public final void setDisableTwoDimensions(Map<String, ? extends Collection<String>> disableTwoDimensions) {
            this.disableTwoDimensions = TwoDimensionsMapCopier.copy(disableTwoDimensions);
        }

        @Override
        public final Builder disableTwoDimensions(Map<String, ? extends Collection<String>> disableTwoDimensions) {
            this.disableTwoDimensions = TwoDimensionsMapCopier.copy(disableTwoDimensions);
            return this;
        }

        public final Collection<String> getInputOrder() {
            if (inputOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return inputOrder;
        }

        public final void setInputOrder(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
        }

        @Override
        public final Builder inputOrderWithStrings(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrderWithStrings(String... inputOrder) {
            inputOrderWithStrings(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public final Builder inputOrder(Collection<Dimension> inputOrder) {
            this.inputOrder = DimensionSetCopier.copyEnumToString(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrder(Dimension... inputOrder) {
            inputOrder(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAwsLogSourceRequest build() {
            return new DeleteAwsLogSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
