/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatalakeStatusResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<GetDatalakeStatusResponse.Builder, GetDatalakeStatusResponse> {
    private static final SdkField<List<AccountSources>> ACCOUNT_SOURCES_LIST_FIELD = SdkField
            .<List<AccountSources>> builder(MarshallingType.LIST)
            .memberName("accountSourcesList")
            .getter(getter(GetDatalakeStatusResponse::accountSourcesList))
            .setter(setter(Builder::accountSourcesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSourcesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountSources> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountSources::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetDatalakeStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCES_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccountSources> accountSourcesList;

    private final String nextToken;

    private GetDatalakeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountSourcesList = builder.accountSourcesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountSourcesList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountSourcesList() {
        return accountSourcesList != null && !(accountSourcesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of enabled accounts and enabled sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountSourcesList} method.
     * </p>
     * 
     * @return The list of enabled accounts and enabled sources.
     */
    public final List<AccountSources> accountSourcesList() {
        return accountSourcesList;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments
     * unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP
     * 400 InvalidToken error.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     *         token will return an HTTP 400 InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountSourcesList() ? accountSourcesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeStatusResponse)) {
            return false;
        }
        GetDatalakeStatusResponse other = (GetDatalakeStatusResponse) obj;
        return hasAccountSourcesList() == other.hasAccountSourcesList()
                && Objects.equals(accountSourcesList(), other.accountSourcesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatalakeStatusResponse")
                .add("AccountSourcesList", hasAccountSourcesList() ? accountSourcesList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountSourcesList":
            return Optional.ofNullable(clazz.cast(accountSourcesList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeStatusResponse, T> g) {
        return obj -> g.apply((GetDatalakeStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDatalakeStatusResponse> {
        /**
         * <p>
         * The list of enabled accounts and enabled sources.
         * </p>
         * 
         * @param accountSourcesList
         *        The list of enabled accounts and enabled sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSourcesList(Collection<AccountSources> accountSourcesList);

        /**
         * <p>
         * The list of enabled accounts and enabled sources.
         * </p>
         * 
         * @param accountSourcesList
         *        The list of enabled accounts and enabled sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSourcesList(AccountSources... accountSourcesList);

        /**
         * <p>
         * The list of enabled accounts and enabled sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.AccountSources.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securitylake.model.AccountSources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.AccountSources.Builder#build()} is called
         * immediately and its result is passed to {@link #accountSourcesList(List<AccountSources>)}.
         * 
         * @param accountSourcesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.AccountSources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSourcesList(java.util.Collection<AccountSources>)
         */
        Builder accountSourcesList(Consumer<AccountSources.Builder>... accountSourcesList);

        /**
         * <p>
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will
         * return an HTTP 400 InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. The value of nextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an
         *        expired pagination token will return an HTTP 400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private List<AccountSources> accountSourcesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeStatusResponse model) {
            super(model);
            accountSourcesList(model.accountSourcesList);
            nextToken(model.nextToken);
        }

        public final List<AccountSources.Builder> getAccountSourcesList() {
            List<AccountSources.Builder> result = AccountSourcesListCopier.copyToBuilder(this.accountSourcesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountSourcesList(Collection<AccountSources.BuilderImpl> accountSourcesList) {
            this.accountSourcesList = AccountSourcesListCopier.copyFromBuilder(accountSourcesList);
        }

        @Override
        public final Builder accountSourcesList(Collection<AccountSources> accountSourcesList) {
            this.accountSourcesList = AccountSourcesListCopier.copy(accountSourcesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSourcesList(AccountSources... accountSourcesList) {
            accountSourcesList(Arrays.asList(accountSourcesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSourcesList(Consumer<AccountSources.Builder>... accountSourcesList) {
            accountSourcesList(Stream.of(accountSourcesList).map(c -> AccountSources.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDatalakeStatusResponse build() {
            return new GetDatalakeStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
