/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusPublisher;
import software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsPublisher;
import software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesPublisher;
import software.amazon.awssdk.services.securitylake.paginators.ListSubscribersPublisher;

/**
 * Service client for accessing Amazon Security Lake asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <note>
 * <p>
 * Amazon Security Lake is in preview release. Your use of the Security Lake preview is subject to Section 2 of the <a
 * href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>("Betas and Previews").
 * </p>
 * </note>
 * <p>
 * Amazon Security Lake is a fully managed security data lake service. You can use Security Lake to automatically
 * centralize security data from cloud, on-premises, and custom sources into a data lake that's stored in your Amazon
 * Web Servicesaccount. Amazon Web Services Organizations is an account management service that lets you consolidate
 * multiple Amazon Web Services accounts into an organization that you create and centrally manage. With Organizations,
 * you can create member accounts and invite existing accounts to join your organization. Security Lake helps you
 * analyze security data for a more complete understanding of your security posture across the entire organization. It
 * can also help you improve the protection of your workloads, applications, and data.
 * </p>
 * <p>
 * The data lake is backed by Amazon Simple Storage Service (Amazon S3) buckets, and you retain ownership over your
 * data.
 * </p>
 * <p>
 * Amazon Security Lake integrates with CloudTrail, a service that provides a record of actions taken by a user, role,
 * or an Amazon Web Services service in Security Lake CloudTrail captures API calls for Security Lake as events. The
 * calls captured include calls from the Security Lake console and code calls to the Security Lake API operations. If
 * you create a trail, you can enable continuous delivery of CloudTrail events to an Amazon S3 bucket, including events
 * for Security Lake. If you don't configure a trail, you can still view the most recent events in the CloudTrail
 * console in Event history. Using the information collected by CloudTrail you can determine the request that was made
 * to Security Lake, the IP address from which the request was made, who made the request, when it was made, and
 * additional details. To learn more about Security Lake information in CloudTrail, see the <a
 * href="https://docs.aws.amazon.com/security-lake/latest/userguide/securitylake-cloudtrail.html">Amazon Security Lake
 * User Guide</a>.
 * </p>
 * <p>
 * Security Lake automates the collection of security-related log and event data from integrated Amazon Web Services and
 * third-party services. It also helps you manage the lifecycle of data with customizable retention and replication
 * settings. Security Lake converts ingested data into Apache Parquet format and a standard open-source schema called
 * the Open Cybersecurity Schema Framework (OCSF).
 * </p>
 * <p>
 * Other Amazon Web Services and third-party services can subscribe to the data that's stored in Security Lake for
 * incident response and security data analytics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityLakeAsyncClient extends SdkClient {
    String SERVICE_NAME = "securitylake";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "securitylake";

    /**
     * Create a {@link SecurityLakeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityLakeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityLakeAsyncClient}.
     */
    static SecurityLakeAsyncClientBuilder builder() {
        return new DefaultSecurityLakeAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member
     * accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source
     * type in any Region for either accounts that are part of a trusted organization or standalone accounts. At least
     * one of the three dimensions is a mandatory input to this API. However, you can supply any combination of the
     * three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. When you don't provide a dimension, Security Lake assumes that
     * the missing dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API enables all Security Lake member accounts for all sources.
     * Similarly, when you do not specify Regions, Security Lake is enabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * You can use this API only to enable natively supported Amazon Web Services as a source. Use
     * <code>CreateCustomLogSource</code> to enable data collection from a custom source.
     * </p>
     *
     * @param createAwsLogSourceRequest
     * @return A Java Future containing the result of the CreateAwsLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>S3Exception Provides an extension of the AmazonServiceException for errors reported by Amazon S3
     *         while processing a request. In particular, this class provides access to the Amazon S3 extended request
     *         ID. If Amazon S3 is incorrectly handling a request and you need to contact Amazon, this extended request
     *         ID may provide useful debugging information.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAwsLogSourceResponse> createAwsLogSource(CreateAwsLogSourceRequest createAwsLogSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member
     * accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source
     * type in any Region for either accounts that are part of a trusted organization or standalone accounts. At least
     * one of the three dimensions is a mandatory input to this API. However, you can supply any combination of the
     * three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. When you don't provide a dimension, Security Lake assumes that
     * the missing dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API enables all Security Lake member accounts for all sources.
     * Similarly, when you do not specify Regions, Security Lake is enabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * You can use this API only to enable natively supported Amazon Web Services as a source. Use
     * <code>CreateCustomLogSource</code> to enable data collection from a custom source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAwsLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAwsLogSourceRequest#builder()}
     * </p>
     *
     * @param createAwsLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateAwsLogSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAwsLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>S3Exception Provides an extension of the AmazonServiceException for errors reported by Amazon S3
     *         while processing a request. In particular, this class provides access to the Amazon S3 extended request
     *         ID. If Amazon S3 is incorrectly handling a request and you need to contact Amazon, this extended request
     *         ID may provide useful debugging information.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAwsLogSourceResponse> createAwsLogSource(
            Consumer<CreateAwsLogSourceRequest.Builder> createAwsLogSourceRequest) {
        return createAwsLogSource(CreateAwsLogSourceRequest.builder().applyMutation(createAwsLogSourceRequest).build());
    }

    /**
     * <p>
     * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to
     * create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating
     * the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This
     * operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from
     * the custom source in addition to an associated Glue table and an Glue crawler.
     * </p>
     *
     * @param createCustomLogSourceRequest
     * @return A Java Future containing the result of the CreateCustomLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ConflictSourceNamesException There was a conflict when you attempted to modify a Security Lake source
     *         name.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomLogSourceResponse> createCustomLogSource(
            CreateCustomLogSourceRequest createCustomLogSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to
     * create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating
     * the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This
     * operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from
     * the custom source in addition to an associated Glue table and an Glue crawler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomLogSourceRequest#builder()}
     * </p>
     *
     * @param createCustomLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomLogSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ConflictSourceNamesException There was a conflict when you attempted to modify a Security Lake source
     *         name.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomLogSourceResponse> createCustomLogSource(
            Consumer<CreateCustomLogSourceRequest.Builder> createCustomLogSourceRequest) {
        return createCustomLogSource(CreateCustomLogSourceRequest.builder().applyMutation(createCustomLogSourceRequest).build());
    }

    /**
     * <p>
     * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable
     * Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions.
     * You can either use the <code>enableAll</code> parameter to specify all Regions or specify the Regions where you
     * want to enable Security Lake. To specify particular Regions, use the <code>Regions</code> parameter and then
     * configure these Regions using the <code>configurations</code> parameter. If you have already enabled Security
     * Lake in a Region when you call this command, the command will update the Region if you provide new configuration
     * parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up
     * the data lake in the Region with the specified configurations.
     * </p>
     * <p>
     * When you enable Security Lake, it starts ingesting security data after the <code>CreateAwsLogSource</code> call.
     * This includes ingesting security data from sources, storing data, and making data accessible to subscribers.
     * Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon
     * Web Services account in the current Region, including security log and event data. For more information, see the
     * <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html">Amazon Security
     * Lake User Guide</a>.
     * </p>
     *
     * @param createDatalakeRequest
     * @return A Java Future containing the result of the CreateDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeResponse> createDatalake(CreateDatalakeRequest createDatalakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable
     * Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions.
     * You can either use the <code>enableAll</code> parameter to specify all Regions or specify the Regions where you
     * want to enable Security Lake. To specify particular Regions, use the <code>Regions</code> parameter and then
     * configure these Regions using the <code>configurations</code> parameter. If you have already enabled Security
     * Lake in a Region when you call this command, the command will update the Region if you provide new configuration
     * parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up
     * the data lake in the Region with the specified configurations.
     * </p>
     * <p>
     * When you enable Security Lake, it starts ingesting security data after the <code>CreateAwsLogSource</code> call.
     * This includes ingesting security data from sources, storing data, and making data accessible to subscribers.
     * Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon
     * Web Services account in the current Region, including security log and event data. For more information, see the
     * <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html">Amazon Security
     * Lake User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatalakeRequest#builder()}
     * </p>
     *
     * @param createDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeResponse> createDatalake(Consumer<CreateDatalakeRequest.Builder> createDatalakeRequest) {
        return createDatalake(CreateDatalakeRequest.builder().applyMutation(createDatalakeRequest).build());
    }

    /**
     * <p>
     * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not
     * automatically enabled for any existing member accounts in your organization.
     * </p>
     *
     * @param createDatalakeAutoEnableRequest
     * @return A Java Future containing the result of the CreateDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeAutoEnableResponse> createDatalakeAutoEnable(
            CreateDatalakeAutoEnableRequest createDatalakeAutoEnableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not
     * automatically enabled for any existing member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeAutoEnableRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param createDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeAutoEnableResponse> createDatalakeAutoEnable(
            Consumer<CreateDatalakeAutoEnableRequest.Builder> createDatalakeAutoEnableRequest) {
        return createDatalakeAutoEnable(CreateDatalakeAutoEnableRequest.builder().applyMutation(createDatalakeAutoEnableRequest)
                .build());
    }

    /**
     * <p>
     * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     *
     * @param createDatalakeDelegatedAdminRequest
     * @return A Java Future containing the result of the CreateDatalakeDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeDelegatedAdminResponse> createDatalakeDelegatedAdmin(
            CreateDatalakeDelegatedAdminRequest createDatalakeDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDatalakeDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param createDatalakeDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeDelegatedAdminRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateDatalakeDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeDelegatedAdminResponse> createDatalakeDelegatedAdmin(
            Consumer<CreateDatalakeDelegatedAdminRequest.Builder> createDatalakeDelegatedAdminRequest) {
        return createDatalakeDelegatedAdmin(CreateDatalakeDelegatedAdminRequest.builder()
                .applyMutation(createDatalakeDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param createDatalakeExceptionsSubscriptionRequest
     * @return A Java Future containing the result of the CreateDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeExceptionsSubscriptionResponse> createDatalakeExceptionsSubscription(
            CreateDatalakeExceptionsSubscriptionRequest createDatalakeExceptionsSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param createDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDatalakeExceptionsSubscriptionResponse> createDatalakeExceptionsSubscription(
            Consumer<CreateDatalakeExceptionsSubscriptionRequest.Builder> createDatalakeExceptionsSubscriptionRequest) {
        return createDatalakeExceptionsSubscription(CreateDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(createDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a
     * subscriber with access to data in the current Amazon Web Services Region.
     * </p>
     *
     * @param createSubscriberRequest
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictSubscriptionException A conflicting subscription exception operation is in progress.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a
     * subscriber with access to data in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubscriberRequest#builder()}
     * </p>
     *
     * @param createSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictSubscriptionException A conflicting subscription exception operation is in progress.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(
            Consumer<CreateSubscriberRequest.Builder> createSubscriberRequest) {
        return createSubscriber(CreateSubscriberRequest.builder().applyMutation(createSubscriberRequest).build());
    }

    /**
     * <p>
     * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in
     * Security Lake.
     * </p>
     *
     * @param createSubscriptionNotificationConfigurationRequest
     * @return A Java Future containing the result of the CreateSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionNotificationConfigurationResponse> createSubscriptionNotificationConfiguration(
            CreateSubscriptionNotificationConfigurationRequest createSubscriptionNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in
     * Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.CreateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionNotificationConfigurationResponse> createSubscriptionNotificationConfiguration(
            Consumer<CreateSubscriptionNotificationConfigurationRequest.Builder> createSubscriptionNotificationConfigurationRequest) {
        return createSubscriptionNotificationConfiguration(CreateSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(createSubscriptionNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. When you remove the source,
     * Security Lake stops collecting data from that source, and subscribers can no longer consume new data from the
     * source. Subscribers can still consume data that Security Lake collected from the source before disablement.
     * </p>
     * <p>
     * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted
     * organization or standalone accounts. At least one of the three dimensions is a mandatory input to this API.
     * However, you can supply any combination of the three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API disables all Security Lake member accounts for sources.
     * Similarly, when you do not specify Regions, Security Lake is disabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * When you don't provide a dimension, Security Lake assumes that the missing dimension refers to the entire set.
     * For example, if you don't provide specific accounts, the API applies to the entire set of accounts in your
     * organization.
     * </p>
     *
     * @param deleteAwsLogSourceRequest
     * @return A Java Future containing the result of the DeleteAwsLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAwsLogSourceResponse> deleteAwsLogSource(DeleteAwsLogSourceRequest deleteAwsLogSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. When you remove the source,
     * Security Lake stops collecting data from that source, and subscribers can no longer consume new data from the
     * source. Subscribers can still consume data that Security Lake collected from the source before disablement.
     * </p>
     * <p>
     * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted
     * organization or standalone accounts. At least one of the three dimensions is a mandatory input to this API.
     * However, you can supply any combination of the three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API disables all Security Lake member accounts for sources.
     * Similarly, when you do not specify Regions, Security Lake is disabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * When you don't provide a dimension, Security Lake assumes that the missing dimension refers to the entire set.
     * For example, if you don't provide specific accounts, the API applies to the entire set of accounts in your
     * organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAwsLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAwsLogSourceRequest#builder()}
     * </p>
     *
     * @param deleteAwsLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAwsLogSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAwsLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAwsLogSourceResponse> deleteAwsLogSource(
            Consumer<DeleteAwsLogSourceRequest.Builder> deleteAwsLogSourceRequest) {
        return deleteAwsLogSource(DeleteAwsLogSourceRequest.builder().applyMutation(deleteAwsLogSourceRequest).build());
    }

    /**
     * <p>
     * Removes a custom log source from Amazon Security Lake.
     * </p>
     *
     * @param deleteCustomLogSourceRequest
     * @return A Java Future containing the result of the DeleteCustomLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ConflictSourceNamesException There was a conflict when you attempted to modify a Security Lake source
     *         name.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomLogSourceResponse> deleteCustomLogSource(
            DeleteCustomLogSourceRequest deleteCustomLogSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a custom log source from Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomLogSourceRequest#builder()}
     * </p>
     *
     * @param deleteCustomLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomLogSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomLogSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ConflictSourceNamesException There was a conflict when you attempted to modify a Security Lake source
     *         name.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomLogSourceResponse> deleteCustomLogSource(
            Consumer<DeleteCustomLogSourceRequest.Builder> deleteCustomLogSourceRequest) {
        return deleteCustomLogSource(DeleteCustomLogSourceRequest.builder().applyMutation(deleteCustomLogSourceRequest).build());
    }

    /**
     * <p>
     * When you delete Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services
     * Regions. Also, this API automatically takes steps to remove the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     *
     * @param deleteDatalakeRequest
     * @return A Java Future containing the result of the DeleteDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeResponse> deleteDatalake(DeleteDatalakeRequest deleteDatalakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you delete Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services
     * Regions. Also, this API automatically takes steps to remove the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatalakeRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeResponse> deleteDatalake(Consumer<DeleteDatalakeRequest.Builder> deleteDatalakeRequest) {
        return deleteDatalake(DeleteDatalakeRequest.builder().applyMutation(deleteDatalakeRequest).build());
    }

    /**
     * <p>
     * Automatically deletes Amazon Security Lake to stop collecting security data. When you delete Amazon Security Lake
     * from your account, Security Lake is disabled in all Regions. Also, this API automatically takes steps to remove
     * the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     *
     * @param deleteDatalakeAutoEnableRequest
     * @return A Java Future containing the result of the DeleteDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeAutoEnableResponse> deleteDatalakeAutoEnable(
            DeleteDatalakeAutoEnableRequest deleteDatalakeAutoEnableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Automatically deletes Amazon Security Lake to stop collecting security data. When you delete Amazon Security Lake
     * from your account, Security Lake is disabled in all Regions. Also, this API automatically takes steps to remove
     * the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeAutoEnableRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeAutoEnableResponse> deleteDatalakeAutoEnable(
            Consumer<DeleteDatalakeAutoEnableRequest.Builder> deleteDatalakeAutoEnableRequest) {
        return deleteDatalakeAutoEnable(DeleteDatalakeAutoEnableRequest.builder().applyMutation(deleteDatalakeAutoEnableRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     *
     * @param deleteDatalakeDelegatedAdminRequest
     * @return A Java Future containing the result of the DeleteDatalakeDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeDelegatedAdminResponse> deleteDatalakeDelegatedAdmin(
            DeleteDatalakeDelegatedAdminRequest deleteDatalakeDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDatalakeDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeDelegatedAdminRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDatalakeDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeDelegatedAdminResponse> deleteDatalakeDelegatedAdmin(
            Consumer<DeleteDatalakeDelegatedAdminRequest.Builder> deleteDatalakeDelegatedAdminRequest) {
        return deleteDatalakeDelegatedAdmin(DeleteDatalakeDelegatedAdminRequest.builder()
                .applyMutation(deleteDatalakeDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param deleteDatalakeExceptionsSubscriptionRequest
     * @return A Java Future containing the result of the DeleteDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeExceptionsSubscriptionResponse> deleteDatalakeExceptionsSubscription(
            DeleteDatalakeExceptionsSubscriptionRequest deleteDatalakeExceptionsSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDatalakeExceptionsSubscriptionResponse> deleteDatalakeExceptionsSubscription(
            Consumer<DeleteDatalakeExceptionsSubscriptionRequest.Builder> deleteDatalakeExceptionsSubscriptionRequest) {
        return deleteDatalakeExceptionsSubscription(DeleteDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(deleteDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the subscription permission for accounts that are already enabled in Amazon Security Lake. You can delete
     * a subscriber and remove access to data in the current Amazon Web Services Region.
     * </p>
     *
     * @param deleteSubscriberRequest
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the subscription permission for accounts that are already enabled in Amazon Security Lake. You can delete
     * a subscriber and remove access to data in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubscriberRequest#builder()}
     * </p>
     *
     * @param deleteSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubscriberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>BucketNotFoundException Amazon Security Lake generally returns 404 errors if the requested object is
     *         missing from the bucket.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(
            Consumer<DeleteSubscriberRequest.Builder> deleteSubscriberRequest) {
        return deleteSubscriber(DeleteSubscriberRequest.builder().applyMutation(deleteSubscriberRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param deleteSubscriptionNotificationConfigurationRequest
     * @return A Java Future containing the result of the DeleteSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionNotificationConfigurationResponse> deleteSubscriptionNotificationConfiguration(
            DeleteSubscriptionNotificationConfigurationRequest deleteSubscriptionNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.DeleteSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionNotificationConfigurationResponse> deleteSubscriptionNotificationConfiguration(
            Consumer<DeleteSubscriptionNotificationConfigurationRequest.Builder> deleteSubscriptionNotificationConfigurationRequest) {
        return deleteSubscriptionNotificationConfiguration(DeleteSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(deleteSubscriptionNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services account ID. You can
     * use the <code>GetDatalake</code> API to know whether Security Lake is enabled for the current Region. This API
     * does not take input parameters.
     * </p>
     *
     * @param getDatalakeRequest
     * @return A Java Future containing the result of the GetDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatalakeResponse> getDatalake(GetDatalakeRequest getDatalakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services account ID. You can
     * use the <code>GetDatalake</code> API to know whether Security Lake is enabled for the current Region. This API
     * does not take input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatalakeRequest#builder()}
     * </p>
     *
     * @param getDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatalakeResponse> getDatalake(Consumer<GetDatalakeRequest.Builder> getDatalakeRequest) {
        return getDatalake(GetDatalakeRequest.builder().applyMutation(getDatalakeRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration that will be automatically set up for accounts added to the organization after the
     * organization has onboarded to Amazon Security Lake. This API does not take input parameters.
     * </p>
     *
     * @param getDatalakeAutoEnableRequest
     * @return A Java Future containing the result of the GetDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeAutoEnableResponse> getDatalakeAutoEnable(
            GetDatalakeAutoEnableRequest getDatalakeAutoEnableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration that will be automatically set up for accounts added to the organization after the
     * organization has onboarded to Amazon Security Lake. This API does not take input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeAutoEnableRequest.Builder} avoiding the
     * need to create one manually via {@link GetDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param getDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDatalakeAutoEnable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeAutoEnableResponse> getDatalakeAutoEnable(
            Consumer<GetDatalakeAutoEnableRequest.Builder> getDatalakeAutoEnableRequest) {
        return getDatalakeAutoEnable(GetDatalakeAutoEnableRequest.builder().applyMutation(getDatalakeAutoEnableRequest).build());
    }

    /**
     * <p>
     * Retrieves the expiration period and time-to-live (TTL) for which the exception message will remain. Exceptions
     * are stored by default, for 2 weeks from when a record was created in Amazon Security Lake. This API does not take
     * input parameters.
     * </p>
     *
     * @param getDatalakeExceptionsExpiryRequest
     * @return A Java Future containing the result of the GetDatalakeExceptionsExpiry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeExceptionsExpiryResponse> getDatalakeExceptionsExpiry(
            GetDatalakeExceptionsExpiryRequest getDatalakeExceptionsExpiryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the expiration period and time-to-live (TTL) for which the exception message will remain. Exceptions
     * are stored by default, for 2 weeks from when a record was created in Amazon Security Lake. This API does not take
     * input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeExceptionsExpiryRequest.Builder}
     * avoiding the need to create one manually via {@link GetDatalakeExceptionsExpiryRequest#builder()}
     * </p>
     *
     * @param getDatalakeExceptionsExpiryRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeExceptionsExpiryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDatalakeExceptionsExpiry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeExceptionsExpiryResponse> getDatalakeExceptionsExpiry(
            Consumer<GetDatalakeExceptionsExpiryRequest.Builder> getDatalakeExceptionsExpiryRequest) {
        return getDatalakeExceptionsExpiry(GetDatalakeExceptionsExpiryRequest.builder()
                .applyMutation(getDatalakeExceptionsExpiryRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of exception notifications for the account in Amazon Security Lake.
     * </p>
     *
     * @param getDatalakeExceptionsSubscriptionRequest
     * @return A Java Future containing the result of the GetDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeExceptionsSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeExceptionsSubscriptionResponse> getDatalakeExceptionsSubscription(
            GetDatalakeExceptionsSubscriptionRequest getDatalakeExceptionsSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of exception notifications for the account in Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeExceptionsSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link GetDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param getDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeExceptionsSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeExceptionsSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeExceptionsSubscriptionResponse> getDatalakeExceptionsSubscription(
            Consumer<GetDatalakeExceptionsSubscriptionRequest.Builder> getDatalakeExceptionsSubscriptionRequest) {
        return getDatalakeExceptionsSubscription(GetDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(getDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     *
     * @param getDatalakeStatusRequest
     * @return A Java Future containing the result of the GetDatalakeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeStatusResponse> getDatalakeStatus(GetDatalakeStatusRequest getDatalakeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetDatalakeStatusRequest#builder()}
     * </p>
     *
     * @param getDatalakeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDatalakeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDatalakeStatusResponse> getDatalakeStatus(
            Consumer<GetDatalakeStatusRequest.Builder> getDatalakeStatusRequest) {
        return getDatalakeStatus(GetDatalakeStatusRequest.builder().applyMutation(getDatalakeStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusPublisher publisher = client.getDatalakeStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusPublisher publisher = client.getDatalakeStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxAccountResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDatalakeStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusPublisher getDatalakeStatusPaginator(GetDatalakeStatusRequest getDatalakeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusPublisher publisher = client.getDatalakeStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusPublisher publisher = client.getDatalakeStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxAccountResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetDatalakeStatusRequest#builder()}
     * </p>
     *
     * @param getDatalakeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeStatusRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusPublisher getDatalakeStatusPaginator(
            Consumer<GetDatalakeStatusRequest.Builder> getDatalakeStatusRequest) {
        return getDatalakeStatusPaginator(GetDatalakeStatusRequest.builder().applyMutation(getDatalakeStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves the subscription information for the specified subscription ID. You can get information about a
     * specific subscriber.
     * </p>
     *
     * @param getSubscriberRequest
     * @return A Java Future containing the result of the GetSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriberResponse> getSubscriber(GetSubscriberRequest getSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the subscription information for the specified subscription ID. You can get information about a
     * specific subscriber.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriberRequest.Builder} avoiding the need to
     * create one manually via {@link GetSubscriberRequest#builder()}
     * </p>
     *
     * @param getSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.GetSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriberResponse> getSubscriber(Consumer<GetSubscriberRequest.Builder> getSubscriberRequest) {
        return getSubscriber(GetSubscriberRequest.builder().applyMutation(getSubscriberRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     * @return A Java Future containing the result of the ListDatalakeExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDatalakeExceptionsResponse> listDatalakeExceptions(
            ListDatalakeExceptionsRequest listDatalakeExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatalakeExceptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatalakeExceptionsRequest#builder()}
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatalakeExceptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDatalakeExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDatalakeExceptionsResponse> listDatalakeExceptions(
            Consumer<ListDatalakeExceptionsRequest.Builder> listDatalakeExceptionsRequest) {
        return listDatalakeExceptions(ListDatalakeExceptionsRequest.builder().applyMutation(listDatalakeExceptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsPublisher publisher = client.listDatalakeExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsPublisher publisher = client.listDatalakeExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxFailures won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsPublisher listDatalakeExceptionsPaginator(
            ListDatalakeExceptionsRequest listDatalakeExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsPublisher publisher = client.listDatalakeExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsPublisher publisher = client.listDatalakeExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxFailures won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatalakeExceptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatalakeExceptionsRequest#builder()}
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatalakeExceptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsPublisher listDatalakeExceptionsPaginator(
            Consumer<ListDatalakeExceptionsRequest.Builder> listDatalakeExceptionsRequest) {
        return listDatalakeExceptionsPaginator(ListDatalakeExceptionsRequest.builder()
                .applyMutation(listDatalakeExceptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     *
     * @param listLogSourcesRequest
     * @return A Java Future containing the result of the ListLogSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogSourcesResponse> listLogSources(ListLogSourcesRequest listLogSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLogSourcesRequest#builder()}
     * </p>
     *
     * @param listLogSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListLogSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLogSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogSourcesResponse> listLogSources(Consumer<ListLogSourcesRequest.Builder> listLogSourcesRequest) {
        return listLogSources(ListLogSourcesRequest.builder().applyMutation(listLogSourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesPublisher publisher = client.listLogSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesPublisher publisher = client.listLogSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listLogSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesPublisher listLogSourcesPaginator(ListLogSourcesRequest listLogSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesPublisher publisher = client.listLogSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesPublisher publisher = client.listLogSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLogSourcesRequest#builder()}
     * </p>
     *
     * @param listLogSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListLogSourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesPublisher listLogSourcesPaginator(Consumer<ListLogSourcesRequest.Builder> listLogSourcesRequest) {
        return listLogSourcesPaginator(ListLogSourcesRequest.builder().applyMutation(listLogSourcesRequest).build());
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     *
     * @param listSubscribersRequest
     * @return A Java Future containing the result of the ListSubscribers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscribersResponse> listSubscribers(ListSubscribersRequest listSubscribersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribersRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscribersRequest#builder()}
     * </p>
     *
     * @param listSubscribersRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSubscribers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscribersResponse> listSubscribers(
            Consumer<ListSubscribersRequest.Builder> listSubscribersRequest) {
        return listSubscribers(ListSubscribersRequest.builder().applyMutation(listSubscribersRequest).build());
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersPublisher publisher = client.listSubscribersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersPublisher publisher = client.listSubscribersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscribersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersPublisher listSubscribersPaginator(ListSubscribersRequest listSubscribersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersPublisher publisher = client.listSubscribersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersPublisher publisher = client.listSubscribersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribersRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscribersRequest#builder()}
     * </p>
     *
     * @param listSubscribersRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersPublisher listSubscribersPaginator(Consumer<ListSubscribersRequest.Builder> listSubscribersRequest) {
        return listSubscribersPaginator(ListSubscribersRequest.builder().applyMutation(listSubscribersRequest).build());
    }

    /**
     * <p>
     * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data
     * from multiple Amazon Web Services Regions.
     * </p>
     *
     * @param updateDatalakeRequest
     * @return A Java Future containing the result of the UpdateDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventBridgeException Represents an error interacting with the Amazon EventBridge service.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeResponse> updateDatalake(UpdateDatalakeRequest updateDatalakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data
     * from multiple Amazon Web Services Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatalakeRequest#builder()}
     * </p>
     *
     * @param updateDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDatalake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventBridgeException Represents an error interacting with the Amazon EventBridge service.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeResponse> updateDatalake(Consumer<UpdateDatalakeRequest.Builder> updateDatalakeRequest) {
        return updateDatalake(UpdateDatalakeRequest.builder().applyMutation(updateDatalakeRequest).build());
    }

    /**
     * <p>
     * Update the expiration period for the exception message to your preferred time, and control the time-to-live (TTL)
     * for the exception message to remain. Exceptions are stored by default for 2 weeks from when a record was created
     * in Amazon Security Lake.
     * </p>
     *
     * @param updateDatalakeExceptionsExpiryRequest
     * @return A Java Future containing the result of the UpdateDatalakeExceptionsExpiry operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeExceptionsExpiryResponse> updateDatalakeExceptionsExpiry(
            UpdateDatalakeExceptionsExpiryRequest updateDatalakeExceptionsExpiryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the expiration period for the exception message to your preferred time, and control the time-to-live (TTL)
     * for the exception message to remain. Exceptions are stored by default for 2 weeks from when a record was created
     * in Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatalakeExceptionsExpiryRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDatalakeExceptionsExpiryRequest#builder()}
     * </p>
     *
     * @param updateDatalakeExceptionsExpiryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeExceptionsExpiryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDatalakeExceptionsExpiry operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeExceptionsExpiryResponse> updateDatalakeExceptionsExpiry(
            Consumer<UpdateDatalakeExceptionsExpiryRequest.Builder> updateDatalakeExceptionsExpiryRequest) {
        return updateDatalakeExceptionsExpiry(UpdateDatalakeExceptionsExpiryRequest.builder()
                .applyMutation(updateDatalakeExceptionsExpiryRequest).build());
    }

    /**
     * <p>
     * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param updateDatalakeExceptionsSubscriptionRequest
     * @return A Java Future containing the result of the UpdateDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeExceptionsSubscriptionResponse> updateDatalakeExceptionsSubscription(
            UpdateDatalakeExceptionsSubscriptionRequest updateDatalakeExceptionsSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateDatalakeExceptionsSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDatalakeExceptionsSubscriptionResponse> updateDatalakeExceptionsSubscription(
            Consumer<UpdateDatalakeExceptionsSubscriptionRequest.Builder> updateDatalakeExceptionsSubscriptionRequest) {
        return updateDatalakeExceptionsSubscription(UpdateDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(updateDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by
     * changing the sources that the subscriber consumes data from.
     * </p>
     *
     * @param updateSubscriberRequest
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictSubscriptionException A conflicting subscription exception operation is in progress.</li>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by
     * changing the sources that the subscriber consumes data from.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubscriberRequest#builder()}
     * </p>
     *
     * @param updateSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictSubscriptionException A conflicting subscription exception operation is in progress.</li>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(
            Consumer<UpdateSubscriberRequest.Builder> updateSubscriberRequest) {
        return updateSubscriber(UpdateSubscriberRequest.builder().applyMutation(updateSubscriberRequest).build());
    }

    /**
     * <p>
     * Creates a new subscription notification or adds the existing subscription notification setting for the specified
     * subscription ID.
     * </p>
     *
     * @param updateSubscriptionNotificationConfigurationRequest
     * @return A Java Future containing the result of the UpdateSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionNotificationConfigurationResponse> updateSubscriptionNotificationConfiguration(
            UpdateSubscriptionNotificationConfigurationRequest updateSubscriptionNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new subscription notification or adds the existing subscription notification setting for the specified
     * subscription ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSubscriptionNotificationConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException More than one process tried to modify a resource at the same time.</li>
     *         <li>InternalServerException Internal service exceptions are sometimes caused by transient issues. Before
     *         you start troubleshooting, perform the operation again.</li>
     *         <li>ValidationException Your signing certificate could not be validated.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Access denied errors
     *         appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit
     *         denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An
     *         implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.
     *         </li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccountNotFoundException Amazon Security Lake cannot find an Amazon Web Services account with the
     *         accountID that you specified, or the account whose credentials you used to make this request isn't a
     *         member of an organization.</li>
     *         <li>InvalidInputException The request was rejected because a value that's not valid or is out of range
     *         was supplied for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityLakeAsyncClient.UpdateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionNotificationConfigurationResponse> updateSubscriptionNotificationConfiguration(
            Consumer<UpdateSubscriptionNotificationConfigurationRequest.Builder> updateSubscriptionNotificationConfigurationRequest) {
        return updateSubscriptionNotificationConfiguration(UpdateSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(updateSubscriptionNotificationConfigurationRequest).build());
    }
}
