/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionNotificationConfigurationRequest extends SecurityLakeRequest
        implements
        ToCopyableBuilder<CreateSubscriptionNotificationConfigurationRequest.Builder, CreateSubscriptionNotificationConfigurationRequest> {
    private static final SdkField<Boolean> CREATE_SQS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createSqs").getter(getter(CreateSubscriptionNotificationConfigurationRequest::createSqs))
            .setter(setter(Builder::createSqs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createSqs").build()).build();

    private static final SdkField<String> HTTPS_API_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpsApiKeyName").getter(getter(CreateSubscriptionNotificationConfigurationRequest::httpsApiKeyName))
            .setter(setter(Builder::httpsApiKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsApiKeyName").build()).build();

    private static final SdkField<String> HTTPS_API_KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpsApiKeyValue").getter(getter(CreateSubscriptionNotificationConfigurationRequest::httpsApiKeyValue))
            .setter(setter(Builder::httpsApiKeyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsApiKeyValue").build()).build();

    private static final SdkField<String> HTTPS_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpsMethod").getter(getter(CreateSubscriptionNotificationConfigurationRequest::httpsMethodAsString))
            .setter(setter(Builder::httpsMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsMethod").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateSubscriptionNotificationConfigurationRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SUBSCRIPTION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionEndpoint")
            .getter(getter(CreateSubscriptionNotificationConfigurationRequest::subscriptionEndpoint))
            .setter(setter(Builder::subscriptionEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionEndpoint").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionId").getter(getter(CreateSubscriptionNotificationConfigurationRequest::subscriptionId))
            .setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("subscriptionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_SQS_FIELD,
            HTTPS_API_KEY_NAME_FIELD, HTTPS_API_KEY_VALUE_FIELD, HTTPS_METHOD_FIELD, ROLE_ARN_FIELD, SUBSCRIPTION_ENDPOINT_FIELD,
            SUBSCRIPTION_ID_FIELD));

    private final Boolean createSqs;

    private final String httpsApiKeyName;

    private final String httpsApiKeyValue;

    private final String httpsMethod;

    private final String roleArn;

    private final String subscriptionEndpoint;

    private final String subscriptionId;

    private CreateSubscriptionNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.createSqs = builder.createSqs;
        this.httpsApiKeyName = builder.httpsApiKeyName;
        this.httpsApiKeyValue = builder.httpsApiKeyValue;
        this.httpsMethod = builder.httpsMethod;
        this.roleArn = builder.roleArn;
        this.subscriptionEndpoint = builder.subscriptionEndpoint;
        this.subscriptionId = builder.subscriptionId;
    }

    /**
     * <p>
     * Create an Amazon Simple Queue Service queue.
     * </p>
     * 
     * @return Create an Amazon Simple Queue Service queue.
     */
    public final Boolean createSqs() {
        return createSqs;
    }

    /**
     * <p>
     * The key name for the notification subscription.
     * </p>
     * 
     * @return The key name for the notification subscription.
     */
    public final String httpsApiKeyName() {
        return httpsApiKeyName;
    }

    /**
     * <p>
     * The key value for the notification subscription.
     * </p>
     * 
     * @return The key value for the notification subscription.
     */
    public final String httpsApiKeyValue() {
        return httpsApiKeyValue;
    }

    /**
     * <p>
     * The HTTPS method used for the notification subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsMethod} will
     * return {@link HttpsMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsMethodAsString}.
     * </p>
     * 
     * @return The HTTPS method used for the notification subscription.
     * @see HttpsMethod
     */
    public final HttpsMethod httpsMethod() {
        return HttpsMethod.fromValue(httpsMethod);
    }

    /**
     * <p>
     * The HTTPS method used for the notification subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsMethod} will
     * return {@link HttpsMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsMethodAsString}.
     * </p>
     * 
     * @return The HTTPS method used for the notification subscription.
     * @see HttpsMethod
     */
    public final String httpsMethodAsString() {
        return httpsMethod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this
     * field.
     * </p>
     * 
     * @return The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate
     *         this field.
     */
    public final String subscriptionEndpoint() {
        return subscriptionEndpoint;
    }

    /**
     * <p>
     * The subscription ID for the notification subscription/
     * </p>
     * 
     * @return The subscription ID for the notification subscription/
     */
    public final String subscriptionId() {
        return subscriptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createSqs());
        hashCode = 31 * hashCode + Objects.hashCode(httpsApiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(httpsApiKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(httpsMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionNotificationConfigurationRequest)) {
            return false;
        }
        CreateSubscriptionNotificationConfigurationRequest other = (CreateSubscriptionNotificationConfigurationRequest) obj;
        return Objects.equals(createSqs(), other.createSqs()) && Objects.equals(httpsApiKeyName(), other.httpsApiKeyName())
                && Objects.equals(httpsApiKeyValue(), other.httpsApiKeyValue())
                && Objects.equals(httpsMethodAsString(), other.httpsMethodAsString())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(subscriptionEndpoint(), other.subscriptionEndpoint())
                && Objects.equals(subscriptionId(), other.subscriptionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionNotificationConfigurationRequest").add("CreateSqs", createSqs())
                .add("HttpsApiKeyName", httpsApiKeyName()).add("HttpsApiKeyValue", httpsApiKeyValue())
                .add("HttpsMethod", httpsMethodAsString()).add("RoleArn", roleArn())
                .add("SubscriptionEndpoint", subscriptionEndpoint()).add("SubscriptionId", subscriptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createSqs":
            return Optional.ofNullable(clazz.cast(createSqs()));
        case "httpsApiKeyName":
            return Optional.ofNullable(clazz.cast(httpsApiKeyName()));
        case "httpsApiKeyValue":
            return Optional.ofNullable(clazz.cast(httpsApiKeyValue()));
        case "httpsMethod":
            return Optional.ofNullable(clazz.cast(httpsMethodAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "subscriptionEndpoint":
            return Optional.ofNullable(clazz.cast(subscriptionEndpoint()));
        case "subscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionNotificationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSubscriptionNotificationConfigurationRequest> {
        /**
         * <p>
         * Create an Amazon Simple Queue Service queue.
         * </p>
         * 
         * @param createSqs
         *        Create an Amazon Simple Queue Service queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSqs(Boolean createSqs);

        /**
         * <p>
         * The key name for the notification subscription.
         * </p>
         * 
         * @param httpsApiKeyName
         *        The key name for the notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsApiKeyName(String httpsApiKeyName);

        /**
         * <p>
         * The key value for the notification subscription.
         * </p>
         * 
         * @param httpsApiKeyValue
         *        The key value for the notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsApiKeyValue(String httpsApiKeyValue);

        /**
         * <p>
         * The HTTPS method used for the notification subscription.
         * </p>
         * 
         * @param httpsMethod
         *        The HTTPS method used for the notification subscription.
         * @see HttpsMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpsMethod
         */
        Builder httpsMethod(String httpsMethod);

        /**
         * <p>
         * The HTTPS method used for the notification subscription.
         * </p>
         * 
         * @param httpsMethod
         *        The HTTPS method used for the notification subscription.
         * @see HttpsMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpsMethod
         */
        Builder httpsMethod(HttpsMethod httpsMethod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this
         * field.
         * </p>
         * 
         * @param subscriptionEndpoint
         *        The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint,
         *        populate this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionEndpoint(String subscriptionEndpoint);

        /**
         * <p>
         * The subscription ID for the notification subscription/
         * </p>
         * 
         * @param subscriptionId
         *        The subscription ID for the notification subscription/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionId(String subscriptionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private Boolean createSqs;

        private String httpsApiKeyName;

        private String httpsApiKeyValue;

        private String httpsMethod;

        private String roleArn;

        private String subscriptionEndpoint;

        private String subscriptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionNotificationConfigurationRequest model) {
            super(model);
            createSqs(model.createSqs);
            httpsApiKeyName(model.httpsApiKeyName);
            httpsApiKeyValue(model.httpsApiKeyValue);
            httpsMethod(model.httpsMethod);
            roleArn(model.roleArn);
            subscriptionEndpoint(model.subscriptionEndpoint);
            subscriptionId(model.subscriptionId);
        }

        public final Boolean getCreateSqs() {
            return createSqs;
        }

        public final void setCreateSqs(Boolean createSqs) {
            this.createSqs = createSqs;
        }

        @Override
        public final Builder createSqs(Boolean createSqs) {
            this.createSqs = createSqs;
            return this;
        }

        public final String getHttpsApiKeyName() {
            return httpsApiKeyName;
        }

        public final void setHttpsApiKeyName(String httpsApiKeyName) {
            this.httpsApiKeyName = httpsApiKeyName;
        }

        @Override
        public final Builder httpsApiKeyName(String httpsApiKeyName) {
            this.httpsApiKeyName = httpsApiKeyName;
            return this;
        }

        public final String getHttpsApiKeyValue() {
            return httpsApiKeyValue;
        }

        public final void setHttpsApiKeyValue(String httpsApiKeyValue) {
            this.httpsApiKeyValue = httpsApiKeyValue;
        }

        @Override
        public final Builder httpsApiKeyValue(String httpsApiKeyValue) {
            this.httpsApiKeyValue = httpsApiKeyValue;
            return this;
        }

        public final String getHttpsMethod() {
            return httpsMethod;
        }

        public final void setHttpsMethod(String httpsMethod) {
            this.httpsMethod = httpsMethod;
        }

        @Override
        public final Builder httpsMethod(String httpsMethod) {
            this.httpsMethod = httpsMethod;
            return this;
        }

        @Override
        public final Builder httpsMethod(HttpsMethod httpsMethod) {
            this.httpsMethod(httpsMethod == null ? null : httpsMethod.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSubscriptionEndpoint() {
            return subscriptionEndpoint;
        }

        public final void setSubscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
        }

        @Override
        public final Builder subscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
            return this;
        }

        public final String getSubscriptionId() {
            return subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionNotificationConfigurationRequest build() {
            return new CreateSubscriptionNotificationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
