/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OcsfEventClass {
    ACCESS_ACTIVITY("ACCESS_ACTIVITY"),

    FILE_ACTIVITY("FILE_ACTIVITY"),

    KERNEL_ACTIVITY("KERNEL_ACTIVITY"),

    KERNEL_EXTENSION("KERNEL_EXTENSION"),

    MEMORY_ACTIVITY("MEMORY_ACTIVITY"),

    MODULE_ACTIVITY("MODULE_ACTIVITY"),

    PROCESS_ACTIVITY("PROCESS_ACTIVITY"),

    REGISTRY_KEY_ACTIVITY("REGISTRY_KEY_ACTIVITY"),

    REGISTRY_VALUE_ACTIVITY("REGISTRY_VALUE_ACTIVITY"),

    RESOURCE_ACTIVITY("RESOURCE_ACTIVITY"),

    SCHEDULED_JOB_ACTIVITY("SCHEDULED_JOB_ACTIVITY"),

    SECURITY_FINDING("SECURITY_FINDING"),

    ACCOUNT_CHANGE("ACCOUNT_CHANGE"),

    AUTHENTICATION("AUTHENTICATION"),

    AUTHORIZATION("AUTHORIZATION"),

    ENTITY_MANAGEMENT_AUDIT("ENTITY_MANAGEMENT_AUDIT"),

    DHCP_ACTIVITY("DHCP_ACTIVITY"),

    NETWORK_ACTIVITY("NETWORK_ACTIVITY"),

    DNS_ACTIVITY("DNS_ACTIVITY"),

    FTP_ACTIVITY("FTP_ACTIVITY"),

    HTTP_ACTIVITY("HTTP_ACTIVITY"),

    RDP_ACTIVITY("RDP_ACTIVITY"),

    SMB_ACTIVITY("SMB_ACTIVITY"),

    SSH_ACTIVITY("SSH_ACTIVITY"),

    CLOUD_API("CLOUD_API"),

    CONTAINER_LIFECYCLE("CONTAINER_LIFECYCLE"),

    DATABASE_LIFECYCLE("DATABASE_LIFECYCLE"),

    CONFIG_STATE("CONFIG_STATE"),

    CLOUD_STORAGE("CLOUD_STORAGE"),

    INVENTORY_INFO("INVENTORY_INFO"),

    RFB_ACTIVITY("RFB_ACTIVITY"),

    SMTP_ACTIVITY("SMTP_ACTIVITY"),

    VIRTUAL_MACHINE_ACTIVITY("VIRTUAL_MACHINE_ACTIVITY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfEventClass> VALUE_MAP = EnumUtils.uniqueIndex(OcsfEventClass.class,
            OcsfEventClass::toString);

    private final String value;

    private OcsfEventClass(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OcsfEventClass corresponding to the value
     */
    public static OcsfEventClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OcsfEventClass}s
     */
    public static Set<OcsfEventClass> knownValues() {
        Set<OcsfEventClass> knownValues = EnumSet.allOf(OcsfEventClass.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
