/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Protocol used in Amazon Security Lake that dictates how notifications are posted at the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolAndNotificationEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtocolAndNotificationEndpoint.Builder, ProtocolAndNotificationEndpoint> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(ProtocolAndNotificationEndpoint::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(ProtocolAndNotificationEndpoint::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENDPOINT_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final String protocol;

    private ProtocolAndNotificationEndpoint(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The account that is subscribed to receive exception notifications.
     * </p>
     * 
     * @return The account that is subscribed to receive exception notifications.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The protocol to which notification messages are posted.
     * </p>
     * 
     * @return The protocol to which notification messages are posted.
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolAndNotificationEndpoint)) {
            return false;
        }
        ProtocolAndNotificationEndpoint other = (ProtocolAndNotificationEndpoint) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtocolAndNotificationEndpoint").add("Endpoint", endpoint()).add("Protocol", protocol())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolAndNotificationEndpoint, T> g) {
        return obj -> g.apply((ProtocolAndNotificationEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolAndNotificationEndpoint> {
        /**
         * <p>
         * The account that is subscribed to receive exception notifications.
         * </p>
         * 
         * @param endpoint
         *        The account that is subscribed to receive exception notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The protocol to which notification messages are posted.
         * </p>
         * 
         * @param protocol
         *        The protocol to which notification messages are posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolAndNotificationEndpoint model) {
            endpoint(model.endpoint);
            protocol(model.protocol);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public ProtocolAndNotificationEndpoint build() {
            return new ProtocolAndNotificationEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
