/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of Amazon Security Lake configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeConfigurationRequest.Builder, LakeConfigurationRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(LakeConfigurationRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<List<String>> REPLICATION_DESTINATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationDestinationRegions")
            .getter(getter(LakeConfigurationRequest::replicationDestinationRegionsAsStrings))
            .setter(setter(Builder::replicationDestinationRegionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationDestinationRegions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationRoleArn").getter(getter(LakeConfigurationRequest::replicationRoleArn))
            .setter(setter(Builder::replicationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRoleArn").build())
            .build();

    private static final SdkField<List<RetentionSetting>> RETENTION_SETTINGS_FIELD = SdkField
            .<List<RetentionSetting>> builder(MarshallingType.LIST)
            .memberName("retentionSettings")
            .getter(getter(LakeConfigurationRequest::retentionSettings))
            .setter(setter(Builder::retentionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetentionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetentionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tagsMap")
            .getter(getter(LakeConfigurationRequest::tagsMap))
            .setter(setter(Builder::tagsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD,
            REPLICATION_DESTINATION_REGIONS_FIELD, REPLICATION_ROLE_ARN_FIELD, RETENTION_SETTINGS_FIELD, TAGS_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encryptionKey;

    private final List<String> replicationDestinationRegions;

    private final String replicationRoleArn;

    private final List<RetentionSetting> retentionSettings;

    private final Map<String, String> tagsMap;

    private LakeConfigurationRequest(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
        this.replicationDestinationRegions = builder.replicationDestinationRegions;
        this.replicationRoleArn = builder.replicationRoleArn;
        this.retentionSettings = builder.retentionSettings;
        this.tagsMap = builder.tagsMap;
    }

    /**
     * <p>
     * The type of encryption key used by Amazon Security Lake to encrypt the Security Lake configuration object.
     * </p>
     * 
     * @return The type of encryption key used by Amazon Security Lake to encrypt the Security Lake configuration
     *         object.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets that
     * are configured for object replication can be owned by the same Amazon Web Services account or by different
     * accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The
     * destination buckets can be in different Amazon Web Services Regions or within the same Region as the source
     * bucket.
     * </p>
     * <p>
     * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central rollup
     * Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationDestinationRegions} method.
     * </p>
     * 
     * @return Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
     *         buckets that are configured for object replication can be owned by the same Amazon Web Services account
     *         or by different accounts. You can replicate objects to a single destination bucket or to multiple
     *         destination buckets. The destination buckets can be in different Amazon Web Services Regions or within
     *         the same Region as the source bucket.</p>
     *         <p>
     *         Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
     *         central rollup Region.
     */
    public final List<Region> replicationDestinationRegions() {
        return RegionSetCopier.copyStringToEnum(replicationDestinationRegions);
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationDestinationRegions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationDestinationRegions() {
        return replicationDestinationRegions != null && !(replicationDestinationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets that
     * are configured for object replication can be owned by the same Amazon Web Services account or by different
     * accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The
     * destination buckets can be in different Amazon Web Services Regions or within the same Region as the source
     * bucket.
     * </p>
     * <p>
     * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central rollup
     * Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationDestinationRegions} method.
     * </p>
     * 
     * @return Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
     *         buckets that are configured for object replication can be owned by the same Amazon Web Services account
     *         or by different accounts. You can replicate objects to a single destination bucket or to multiple
     *         destination buckets. The destination buckets can be in different Amazon Web Services Regions or within
     *         the same Region as the source bucket.</p>
     *         <p>
     *         Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
     *         central rollup Region.
     */
    public final List<String> replicationDestinationRegionsAsStrings() {
        return replicationDestinationRegions;
    }

    /**
     * <p>
     * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM) role
     * you created that is managed by Security Lake, to ensure the replication setting is correct.
     * </p>
     * 
     * @return Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management
     *         (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
     */
    public final String replicationRoleArn() {
        return replicationRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetentionSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetentionSettings() {
        return retentionSettings != null && !(retentionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retention settings for the destination Amazon S3 buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetentionSettings} method.
     * </p>
     * 
     * @return Retention settings for the destination Amazon S3 buckets.
     */
    public final List<RetentionSetting> retentionSettings() {
        return retentionSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagsMap() {
        return tagsMap != null && !(tagsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsMap} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value, both of which you define.
     */
    public final Map<String, String> tagsMap() {
        return tagsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationDestinationRegions() ? replicationDestinationRegionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRetentionSettings() ? retentionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsMap() ? tagsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeConfigurationRequest)) {
            return false;
        }
        LakeConfigurationRequest other = (LakeConfigurationRequest) obj;
        return Objects.equals(encryptionKey(), other.encryptionKey())
                && hasReplicationDestinationRegions() == other.hasReplicationDestinationRegions()
                && Objects.equals(replicationDestinationRegionsAsStrings(), other.replicationDestinationRegionsAsStrings())
                && Objects.equals(replicationRoleArn(), other.replicationRoleArn())
                && hasRetentionSettings() == other.hasRetentionSettings()
                && Objects.equals(retentionSettings(), other.retentionSettings()) && hasTagsMap() == other.hasTagsMap()
                && Objects.equals(tagsMap(), other.tagsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LakeConfigurationRequest")
                .add("EncryptionKey", encryptionKey())
                .add("ReplicationDestinationRegions",
                        hasReplicationDestinationRegions() ? replicationDestinationRegionsAsStrings() : null)
                .add("ReplicationRoleArn", replicationRoleArn())
                .add("RetentionSettings", hasRetentionSettings() ? retentionSettings() : null)
                .add("TagsMap", hasTagsMap() ? tagsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "replicationDestinationRegions":
            return Optional.ofNullable(clazz.cast(replicationDestinationRegionsAsStrings()));
        case "replicationRoleArn":
            return Optional.ofNullable(clazz.cast(replicationRoleArn()));
        case "retentionSettings":
            return Optional.ofNullable(clazz.cast(retentionSettings()));
        case "tagsMap":
            return Optional.ofNullable(clazz.cast(tagsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeConfigurationRequest, T> g) {
        return obj -> g.apply((LakeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeConfigurationRequest> {
        /**
         * <p>
         * The type of encryption key used by Amazon Security Lake to encrypt the Security Lake configuration object.
         * </p>
         * 
         * @param encryptionKey
         *        The type of encryption key used by Amazon Security Lake to encrypt the Security Lake configuration
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets
         * that are configured for object replication can be owned by the same Amazon Web Services account or by
         * different accounts. You can replicate objects to a single destination bucket or to multiple destination
         * buckets. The destination buckets can be in different Amazon Web Services Regions or within the same Region as
         * the source bucket.
         * </p>
         * <p>
         * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central
         * rollup Region.
         * </p>
         * 
         * @param replicationDestinationRegions
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
         *        buckets that are configured for object replication can be owned by the same Amazon Web Services
         *        account or by different accounts. You can replicate objects to a single destination bucket or to
         *        multiple destination buckets. The destination buckets can be in different Amazon Web Services Regions
         *        or within the same Region as the source bucket.</p>
         *        <p>
         *        Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
         *        central rollup Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationDestinationRegionsWithStrings(Collection<String> replicationDestinationRegions);

        /**
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets
         * that are configured for object replication can be owned by the same Amazon Web Services account or by
         * different accounts. You can replicate objects to a single destination bucket or to multiple destination
         * buckets. The destination buckets can be in different Amazon Web Services Regions or within the same Region as
         * the source bucket.
         * </p>
         * <p>
         * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central
         * rollup Region.
         * </p>
         * 
         * @param replicationDestinationRegions
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
         *        buckets that are configured for object replication can be owned by the same Amazon Web Services
         *        account or by different accounts. You can replicate objects to a single destination bucket or to
         *        multiple destination buckets. The destination buckets can be in different Amazon Web Services Regions
         *        or within the same Region as the source bucket.</p>
         *        <p>
         *        Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
         *        central rollup Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationDestinationRegionsWithStrings(String... replicationDestinationRegions);

        /**
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets
         * that are configured for object replication can be owned by the same Amazon Web Services account or by
         * different accounts. You can replicate objects to a single destination bucket or to multiple destination
         * buckets. The destination buckets can be in different Amazon Web Services Regions or within the same Region as
         * the source bucket.
         * </p>
         * <p>
         * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central
         * rollup Region.
         * </p>
         * 
         * @param replicationDestinationRegions
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
         *        buckets that are configured for object replication can be owned by the same Amazon Web Services
         *        account or by different accounts. You can replicate objects to a single destination bucket or to
         *        multiple destination buckets. The destination buckets can be in different Amazon Web Services Regions
         *        or within the same Region as the source bucket.</p>
         *        <p>
         *        Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
         *        central rollup Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationDestinationRegions(Collection<Region> replicationDestinationRegions);

        /**
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets
         * that are configured for object replication can be owned by the same Amazon Web Services account or by
         * different accounts. You can replicate objects to a single destination bucket or to multiple destination
         * buckets. The destination buckets can be in different Amazon Web Services Regions or within the same Region as
         * the source bucket.
         * </p>
         * <p>
         * Set up one or more rollup Regions by providing the Region or Regions that should contribute to the central
         * rollup Region.
         * </p>
         * 
         * @param replicationDestinationRegions
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3
         *        buckets that are configured for object replication can be owned by the same Amazon Web Services
         *        account or by different accounts. You can replicate objects to a single destination bucket or to
         *        multiple destination buckets. The destination buckets can be in different Amazon Web Services Regions
         *        or within the same Region as the source bucket.</p>
         *        <p>
         *        Set up one or more rollup Regions by providing the Region or Regions that should contribute to the
         *        central rollup Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationDestinationRegions(Region... replicationDestinationRegions);

        /**
         * <p>
         * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM)
         * role you created that is managed by Security Lake, to ensure the replication setting is correct.
         * </p>
         * 
         * @param replicationRoleArn
         *        Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management
         *        (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRoleArn(String replicationRoleArn);

        /**
         * <p>
         * Retention settings for the destination Amazon S3 buckets.
         * </p>
         * 
         * @param retentionSettings
         *        Retention settings for the destination Amazon S3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionSettings(Collection<RetentionSetting> retentionSettings);

        /**
         * <p>
         * Retention settings for the destination Amazon S3 buckets.
         * </p>
         * 
         * @param retentionSettings
         *        Retention settings for the destination Amazon S3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionSettings(RetentionSetting... retentionSettings);

        /**
         * <p>
         * Retention settings for the destination Amazon S3 buckets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.RetentionSetting.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securitylake.model.RetentionSetting#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.RetentionSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #retentionSettings(List<RetentionSetting>)}.
         * 
         * @param retentionSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.RetentionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionSettings(java.util.Collection<RetentionSetting>)
         */
        Builder retentionSettings(Consumer<RetentionSetting.Builder>... retentionSettings);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value, both of which you define.
         * </p>
         * 
         * @param tagsMap
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsMap(Map<String, String> tagsMap);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionKey;

        private List<String> replicationDestinationRegions = DefaultSdkAutoConstructList.getInstance();

        private String replicationRoleArn;

        private List<RetentionSetting> retentionSettings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tagsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LakeConfigurationRequest model) {
            encryptionKey(model.encryptionKey);
            replicationDestinationRegionsWithStrings(model.replicationDestinationRegions);
            replicationRoleArn(model.replicationRoleArn);
            retentionSettings(model.retentionSettings);
            tagsMap(model.tagsMap);
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Collection<String> getReplicationDestinationRegions() {
            if (replicationDestinationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationDestinationRegions;
        }

        public final void setReplicationDestinationRegions(Collection<String> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copy(replicationDestinationRegions);
        }

        @Override
        public final Builder replicationDestinationRegionsWithStrings(Collection<String> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copy(replicationDestinationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationDestinationRegionsWithStrings(String... replicationDestinationRegions) {
            replicationDestinationRegionsWithStrings(Arrays.asList(replicationDestinationRegions));
            return this;
        }

        @Override
        public final Builder replicationDestinationRegions(Collection<Region> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copyEnumToString(replicationDestinationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationDestinationRegions(Region... replicationDestinationRegions) {
            replicationDestinationRegions(Arrays.asList(replicationDestinationRegions));
            return this;
        }

        public final String getReplicationRoleArn() {
            return replicationRoleArn;
        }

        public final void setReplicationRoleArn(String replicationRoleArn) {
            this.replicationRoleArn = replicationRoleArn;
        }

        @Override
        public final Builder replicationRoleArn(String replicationRoleArn) {
            this.replicationRoleArn = replicationRoleArn;
            return this;
        }

        public final List<RetentionSetting.Builder> getRetentionSettings() {
            List<RetentionSetting.Builder> result = RetentionSettingListCopier.copyToBuilder(this.retentionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetentionSettings(Collection<RetentionSetting.BuilderImpl> retentionSettings) {
            this.retentionSettings = RetentionSettingListCopier.copyFromBuilder(retentionSettings);
        }

        @Override
        public final Builder retentionSettings(Collection<RetentionSetting> retentionSettings) {
            this.retentionSettings = RetentionSettingListCopier.copy(retentionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionSettings(RetentionSetting... retentionSettings) {
            retentionSettings(Arrays.asList(retentionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionSettings(Consumer<RetentionSetting.Builder>... retentionSettings) {
            retentionSettings(Stream.of(retentionSettings).map(c -> RetentionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTagsMap() {
            if (tagsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return tagsMap;
        }

        public final void setTagsMap(Map<String, String> tagsMap) {
            this.tagsMap = TagsMapCopier.copy(tagsMap);
        }

        @Override
        public final Builder tagsMap(Map<String, String> tagsMap) {
            this.tagsMap = TagsMapCopier.copy(tagsMap);
            return this;
        }

        @Override
        public LakeConfigurationRequest build() {
            return new LakeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
