/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class LakeConfigurationResponseMapCopier {
    static Map<String, LakeConfigurationResponse> copy(
            Map<String, ? extends LakeConfigurationResponse> lakeConfigurationResponseMapParam) {
        Map<String, LakeConfigurationResponse> map;
        if (lakeConfigurationResponseMapParam == null || lakeConfigurationResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LakeConfigurationResponse> modifiableMap = new LinkedHashMap<>();
            lakeConfigurationResponseMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LakeConfigurationResponse> copyFromBuilder(
            Map<String, ? extends LakeConfigurationResponse.Builder> lakeConfigurationResponseMapParam) {
        Map<String, LakeConfigurationResponse> map;
        if (lakeConfigurationResponseMapParam == null || lakeConfigurationResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LakeConfigurationResponse> modifiableMap = new LinkedHashMap<>();
            lakeConfigurationResponseMapParam.forEach((key, value) -> {
                LakeConfigurationResponse member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LakeConfigurationResponse.Builder> copyToBuilder(
            Map<String, ? extends LakeConfigurationResponse> lakeConfigurationResponseMapParam) {
        Map<String, LakeConfigurationResponse.Builder> map;
        if (lakeConfigurationResponseMapParam == null || lakeConfigurationResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LakeConfigurationResponse.Builder> modifiableMap = new LinkedHashMap<>();
            lakeConfigurationResponseMapParam.forEach((key, value) -> {
                LakeConfigurationResponse.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LakeConfigurationResponse> copyEnumToString(
            Map<Region, ? extends LakeConfigurationResponse> lakeConfigurationResponseMapParam) {
        Map<String, LakeConfigurationResponse> map;
        if (lakeConfigurationResponseMapParam == null || lakeConfigurationResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LakeConfigurationResponse> modifiableMap = new LinkedHashMap<>();
            lakeConfigurationResponseMapParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<Region, LakeConfigurationResponse> copyStringToEnum(
            Map<String, ? extends LakeConfigurationResponse> lakeConfigurationResponseMapParam) {
        Map<Region, LakeConfigurationResponse> map;
        if (lakeConfigurationResponseMapParam == null || lakeConfigurationResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<Region, LakeConfigurationResponse> modifiableMap = new LinkedHashMap<>();
            lakeConfigurationResponseMapParam.forEach((key, value) -> {
                Region result = Region.fromValue(key);
                if (result != Region.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
