/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccessType;
import software.amazon.awssdk.services.securitylake.model.AccessTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.SourceType;
import software.amazon.awssdk.services.securitylake.model.SourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriberRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateSubscriberRequest> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessTypes").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::accessTypesAsStrings)).setter(CreateSubscriberRequest.setter(Builder::accessTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::accountId)).setter(CreateSubscriberRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::externalId)).setter(CreateSubscriberRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<List<SourceType>> SOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceTypes").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::sourceTypes)).setter(CreateSubscriberRequest.setter(Builder::sourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberDescription").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::subscriberDescription)).setter(CreateSubscriberRequest.setter(Builder::subscriberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build()}).build();
    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberName").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::subscriberName)).setter(CreateSubscriberRequest.setter(Builder::subscriberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD, ACCOUNT_ID_FIELD, EXTERNAL_ID_FIELD, SOURCE_TYPES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_NAME_FIELD));
    private final List<String> accessTypes;
    private final String accountId;
    private final String externalId;
    private final List<SourceType> sourceTypes;
    private final String subscriberDescription;
    private final String subscriberName;

    private CreateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accessTypes = builder.accessTypes;
        this.accountId = builder.accountId;
        this.externalId = builder.externalId;
        this.sourceTypes = builder.sourceTypes;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberName = builder.subscriberName;
    }

    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(this.accessTypes);
    }

    public final boolean hasAccessTypes() {
        return this.accessTypes != null && !(this.accessTypes instanceof SdkAutoConstructList);
    }

    public final List<String> accessTypesAsStrings() {
        return this.accessTypes;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final boolean hasSourceTypes() {
        return this.sourceTypes != null && !(this.sourceTypes instanceof SdkAutoConstructList);
    }

    public final List<SourceType> sourceTypes() {
        return this.sourceTypes;
    }

    public final String subscriberDescription() {
        return this.subscriberDescription;
    }

    public final String subscriberName() {
        return this.subscriberName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessTypes() ? this.accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceTypes() ? this.sourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest)((Object)obj);
        return this.hasAccessTypes() == other.hasAccessTypes() && Objects.equals(this.accessTypesAsStrings(), other.accessTypesAsStrings()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.externalId(), other.externalId()) && this.hasSourceTypes() == other.hasSourceTypes() && Objects.equals(this.sourceTypes(), other.sourceTypes()) && Objects.equals(this.subscriberDescription(), other.subscriberDescription()) && Objects.equals(this.subscriberName(), other.subscriberName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriberRequest").add("AccessTypes", this.hasAccessTypes() ? this.accessTypesAsStrings() : null).add("AccountId", (Object)this.accountId()).add("ExternalId", (Object)this.externalId()).add("SourceTypes", this.hasSourceTypes() ? this.sourceTypes() : null).add("SubscriberDescription", (Object)this.subscriberDescription()).add("SubscriberName", (Object)this.subscriberName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessTypes": {
                return Optional.ofNullable(clazz.cast(this.accessTypesAsStrings()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "sourceTypes": {
                return Optional.ofNullable(clazz.cast(this.sourceTypes()));
            }
            case "subscriberDescription": {
                return Optional.ofNullable(clazz.cast(this.subscriberDescription()));
            }
            case "subscriberName": {
                return Optional.ofNullable(clazz.cast(this.subscriberName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberRequest, T> g) {
        return obj -> g.apply((CreateSubscriberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();
        private String accountId;
        private String externalId;
        private List<SourceType> sourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String subscriberDescription;
        private String subscriberName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberRequest model) {
            super(model);
            this.accessTypesWithStrings(model.accessTypes);
            this.accountId(model.accountId);
            this.externalId(model.externalId);
            this.sourceTypes(model.sourceTypes);
            this.subscriberDescription(model.subscriberDescription);
            this.subscriberName(model.subscriberName);
        }

        public final Collection<String> getAccessTypes() {
            if (this.accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String ... accessTypes) {
            this.accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType ... accessTypes) {
            this.accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final List<SourceType.Builder> getSourceTypes() {
            List<SourceType.Builder> result = SourceTypeListCopier.copyToBuilder(this.sourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceTypes(Collection<SourceType.BuilderImpl> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copyFromBuilder(sourceTypes);
        }

        @Override
        public final Builder sourceTypes(Collection<SourceType> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copy(sourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(SourceType ... sourceTypes) {
            this.sourceTypes(Arrays.asList(sourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(Consumer<SourceType.Builder> ... sourceTypes) {
            this.sourceTypes(Stream.of(sourceTypes).map(c -> (SourceType)((SourceType.Builder)SourceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberName() {
            return this.subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriberRequest build() {
            return new CreateSubscriberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriberRequest> {
        public Builder accessTypesWithStrings(Collection<String> var1);

        public Builder accessTypesWithStrings(String ... var1);

        public Builder accessTypes(Collection<AccessType> var1);

        public Builder accessTypes(AccessType ... var1);

        public Builder accountId(String var1);

        public Builder externalId(String var1);

        public Builder sourceTypes(Collection<SourceType> var1);

        public Builder sourceTypes(SourceType ... var1);

        public Builder sourceTypes(Consumer<SourceType.Builder> ... var1);

        public Builder subscriberDescription(String var1);

        public Builder subscriberName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

