/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetentionSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetentionSetting> {
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionPeriod").getter(RetentionSetting.getter(RetentionSetting::retentionPeriod)).setter(RetentionSetting.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageClass").getter(RetentionSetting.getter(RetentionSetting::storageClassAsString)).setter(RetentionSetting.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_FIELD, STORAGE_CLASS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer retentionPeriod;
    private final String storageClass;

    private RetentionSetting(BuilderImpl builder) {
        this.retentionPeriod = builder.retentionPeriod;
        this.storageClass = builder.storageClass;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionSetting)) {
            return false;
        }
        RetentionSetting other = (RetentionSetting)obj;
        return Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetentionSetting").add("RetentionPeriod", (Object)this.retentionPeriod()).add("StorageClass", (Object)this.storageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "storageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionSetting, T> g) {
        return obj -> g.apply((RetentionSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer retentionPeriod;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionSetting model) {
            this.retentionPeriod(model.retentionPeriod);
            this.storageClass(model.storageClass);
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public RetentionSetting build() {
            return new RetentionSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetentionSetting> {
        public Builder retentionPeriod(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);
    }
}

