/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAwsLogSourceResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<DeleteAwsLogSourceResponse.Builder, DeleteAwsLogSourceResponse> {
    private static final SdkField<List<String>> FAILED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failed")
            .getter(getter(DeleteAwsLogSourceResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROCESSING_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("processing")
            .getter(getter(DeleteAwsLogSourceResponse::processing))
            .setter(setter(Builder::processing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processing").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_FIELD, PROCESSING_FIELD));

    private final List<String> failed;

    private final List<String> processing;

    private DeleteAwsLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.processing = builder.processing;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
     */
    public final List<String> failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Processing property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProcessing() {
        return processing != null && !(processing instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deletion of the Amazon Web Services sources is in progress.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessing} method.
     * </p>
     * 
     * @return Deletion of the Amazon Web Services sources is in progress.
     */
    public final List<String> processing() {
        return processing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessing() ? processing() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAwsLogSourceResponse)) {
            return false;
        }
        DeleteAwsLogSourceResponse other = (DeleteAwsLogSourceResponse) obj;
        return hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed())
                && hasProcessing() == other.hasProcessing() && Objects.equals(processing(), other.processing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAwsLogSourceResponse").add("Failed", hasFailed() ? failed() : null)
                .add("Processing", hasProcessing() ? processing() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "processing":
            return Optional.ofNullable(clazz.cast(processing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAwsLogSourceResponse, T> g) {
        return obj -> g.apply((DeleteAwsLogSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAwsLogSourceResponse> {
        /**
         * <p>
         * Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
         * </p>
         * 
         * @param failed
         *        Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<String> failed);

        /**
         * <p>
         * Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
         * </p>
         * 
         * @param failed
         *        Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(String... failed);

        /**
         * <p>
         * Deletion of the Amazon Web Services sources is in progress.
         * </p>
         * 
         * @param processing
         *        Deletion of the Amazon Web Services sources is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processing(Collection<String> processing);

        /**
         * <p>
         * Deletion of the Amazon Web Services sources is in progress.
         * </p>
         * 
         * @param processing
         *        Deletion of the Amazon Web Services sources is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processing(String... processing);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private List<String> failed = DefaultSdkAutoConstructList.getInstance();

        private List<String> processing = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAwsLogSourceResponse model) {
            super(model);
            failed(model.failed);
            processing(model.processing);
        }

        public final Collection<String> getFailed() {
            if (failed instanceof SdkAutoConstructList) {
                return null;
            }
            return failed;
        }

        public final void setFailed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
        }

        @Override
        public final Builder failed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(String... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        public final Collection<String> getProcessing() {
            if (processing instanceof SdkAutoConstructList) {
                return null;
            }
            return processing;
        }

        public final void setProcessing(Collection<String> processing) {
            this.processing = AccountListCopier.copy(processing);
        }

        @Override
        public final Builder processing(Collection<String> processing) {
            this.processing = AccountListCopier.copy(processing);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processing(String... processing) {
            processing(Arrays.asList(processing));
            return this;
        }

        @Override
        public DeleteAwsLogSourceResponse build() {
            return new DeleteAwsLogSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
