/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.LastUpdateFailure;
import software.amazon.awssdk.services.securitylake.model.SettingsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateStatus> {
    private static final SdkField<LastUpdateFailure> LAST_UPDATE_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastUpdateFailure").getter(UpdateStatus.getter(UpdateStatus::lastUpdateFailure)).setter(UpdateStatus.setter(Builder::lastUpdateFailure)).constructor(LastUpdateFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateFailure").build()}).build();
    private static final SdkField<String> LAST_UPDATE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateRequestId").getter(UpdateStatus.getter(UpdateStatus::lastUpdateRequestId)).setter(UpdateStatus.setter(Builder::lastUpdateRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateRequestId").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateStatus").getter(UpdateStatus.getter(UpdateStatus::lastUpdateStatusAsString)).setter(UpdateStatus.setter(Builder::lastUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATE_FAILURE_FIELD, LAST_UPDATE_REQUEST_ID_FIELD, LAST_UPDATE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final LastUpdateFailure lastUpdateFailure;
    private final String lastUpdateRequestId;
    private final String lastUpdateStatus;

    private UpdateStatus(BuilderImpl builder) {
        this.lastUpdateFailure = builder.lastUpdateFailure;
        this.lastUpdateRequestId = builder.lastUpdateRequestId;
        this.lastUpdateStatus = builder.lastUpdateStatus;
    }

    public final LastUpdateFailure lastUpdateFailure() {
        return this.lastUpdateFailure;
    }

    public final String lastUpdateRequestId() {
        return this.lastUpdateRequestId;
    }

    public final SettingsStatus lastUpdateStatus() {
        return SettingsStatus.fromValue(this.lastUpdateStatus);
    }

    public final String lastUpdateStatusAsString() {
        return this.lastUpdateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStatus)) {
            return false;
        }
        UpdateStatus other = (UpdateStatus)obj;
        return Objects.equals(this.lastUpdateFailure(), other.lastUpdateFailure()) && Objects.equals(this.lastUpdateRequestId(), other.lastUpdateRequestId()) && Objects.equals(this.lastUpdateStatusAsString(), other.lastUpdateStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStatus").add("LastUpdateFailure", (Object)this.lastUpdateFailure()).add("LastUpdateRequestId", (Object)this.lastUpdateRequestId()).add("LastUpdateStatus", (Object)this.lastUpdateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastUpdateFailure": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateFailure()));
            }
            case "lastUpdateRequestId": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateRequestId()));
            }
            case "lastUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStatus, T> g) {
        return obj -> g.apply((UpdateStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LastUpdateFailure lastUpdateFailure;
        private String lastUpdateRequestId;
        private String lastUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStatus model) {
            this.lastUpdateFailure(model.lastUpdateFailure);
            this.lastUpdateRequestId(model.lastUpdateRequestId);
            this.lastUpdateStatus(model.lastUpdateStatus);
        }

        public final LastUpdateFailure.Builder getLastUpdateFailure() {
            return this.lastUpdateFailure != null ? this.lastUpdateFailure.toBuilder() : null;
        }

        public final void setLastUpdateFailure(LastUpdateFailure.BuilderImpl lastUpdateFailure) {
            this.lastUpdateFailure = lastUpdateFailure != null ? lastUpdateFailure.build() : null;
        }

        @Override
        public final Builder lastUpdateFailure(LastUpdateFailure lastUpdateFailure) {
            this.lastUpdateFailure = lastUpdateFailure;
            return this;
        }

        public final String getLastUpdateRequestId() {
            return this.lastUpdateRequestId;
        }

        public final void setLastUpdateRequestId(String lastUpdateRequestId) {
            this.lastUpdateRequestId = lastUpdateRequestId;
        }

        @Override
        public final Builder lastUpdateRequestId(String lastUpdateRequestId) {
            this.lastUpdateRequestId = lastUpdateRequestId;
            return this;
        }

        public final String getLastUpdateStatus() {
            return this.lastUpdateStatus;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(SettingsStatus lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        public UpdateStatus build() {
            return new UpdateStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateStatus> {
        public Builder lastUpdateFailure(LastUpdateFailure var1);

        default public Builder lastUpdateFailure(Consumer<LastUpdateFailure.Builder> lastUpdateFailure) {
            return this.lastUpdateFailure((LastUpdateFailure)((LastUpdateFailure.Builder)LastUpdateFailure.builder().applyMutation(lastUpdateFailure)).build());
        }

        public Builder lastUpdateRequestId(String var1);

        public Builder lastUpdateStatus(String var1);

        public Builder lastUpdateStatus(SettingsStatus var1);
    }
}

