/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.securitylake.model.AccessDeniedException;
import software.amazon.awssdk.services.securitylake.model.AccountNotFoundException;
import software.amazon.awssdk.services.securitylake.model.BucketNotFoundException;
import software.amazon.awssdk.services.securitylake.model.ConcurrentModificationException;
import software.amazon.awssdk.services.securitylake.model.ConflictException;
import software.amazon.awssdk.services.securitylake.model.ConflictSourceNamesException;
import software.amazon.awssdk.services.securitylake.model.ConflictSubscriptionException;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.EventBridgeException;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.InternalServerException;
import software.amazon.awssdk.services.securitylake.model.InvalidInputException;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securitylake.model.S3Exception;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeException;
import software.amazon.awssdk.services.securitylake.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securitylake.model.ThrottlingException;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.ValidationException;
import software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable;

/**
 * Service client for accessing Amazon Security Lake. This can be created using the static {@link #builder()} method.
 *
 * <note>
 * <p>
 * Amazon Security Lake is in preview release. Your use of the Security Lake preview is subject to Section 2 of the <a
 * href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>("Betas and Previews").
 * </p>
 * </note>
 * <p>
 * Amazon Security Lake is a fully managed security data lake service. You can use Security Lake to automatically
 * centralize security data from cloud, on-premises, and custom sources into a data lake that's stored in your Amazon
 * Web Servicesaccount. Amazon Web Services Organizations is an account management service that lets you consolidate
 * multiple Amazon Web Services accounts into an organization that you create and centrally manage. With Organizations,
 * you can create member accounts and invite existing accounts to join your organization. Security Lake helps you
 * analyze security data for a more complete understanding of your security posture across the entire organization. It
 * can also help you improve the protection of your workloads, applications, and data.
 * </p>
 * <p>
 * The data lake is backed by Amazon Simple Storage Service (Amazon S3) buckets, and you retain ownership over your
 * data.
 * </p>
 * <p>
 * Amazon Security Lake integrates with CloudTrail, a service that provides a record of actions taken by a user, role,
 * or an Amazon Web Services service in Security Lake CloudTrail captures API calls for Security Lake as events. The
 * calls captured include calls from the Security Lake console and code calls to the Security Lake API operations. If
 * you create a trail, you can enable continuous delivery of CloudTrail events to an Amazon S3 bucket, including events
 * for Security Lake. If you don't configure a trail, you can still view the most recent events in the CloudTrail
 * console in Event history. Using the information collected by CloudTrail you can determine the request that was made
 * to Security Lake, the IP address from which the request was made, who made the request, when it was made, and
 * additional details. To learn more about Security Lake information in CloudTrail, see the <a
 * href="https://docs.aws.amazon.com/security-lake/latest/userguide/securitylake-cloudtrail.html">Amazon Security Lake
 * User Guide</a>.
 * </p>
 * <p>
 * Security Lake automates the collection of security-related log and event data from integrated Amazon Web Services and
 * third-party services. It also helps you manage the lifecycle of data with customizable retention and replication
 * settings. Security Lake converts ingested data into Apache Parquet format and a standard open-source schema called
 * the Open Cybersecurity Schema Framework (OCSF).
 * </p>
 * <p>
 * Other Amazon Web Services and third-party services can subscribe to the data that's stored in Security Lake for
 * incident response and security data analytics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityLakeClient extends SdkClient {
    String SERVICE_NAME = "securitylake";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "securitylake";

    /**
     * <p>
     * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member
     * accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source
     * type in any Region for either accounts that are part of a trusted organization or standalone accounts. At least
     * one of the three dimensions is a mandatory input to this API. However, you can supply any combination of the
     * three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. When you don't provide a dimension, Security Lake assumes that
     * the missing dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API enables all Security Lake member accounts for all sources.
     * Similarly, when you do not specify Regions, Security Lake is enabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * You can use this API only to enable natively supported Amazon Web Services as a source. Use
     * <code>CreateCustomLogSource</code> to enable data collection from a custom source.
     * </p>
     *
     * @param createAwsLogSourceRequest
     * @return Result of the CreateAwsLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws S3Exception
     *         Provides an extension of the AmazonServiceException for errors reported by Amazon S3 while processing a
     *         request. In particular, this class provides access to the Amazon S3 extended request ID. If Amazon S3 is
     *         incorrectly handling a request and you need to contact Amazon, this extended request ID may provide
     *         useful debugging information.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAwsLogSourceResponse createAwsLogSource(CreateAwsLogSourceRequest createAwsLogSourceRequest)
            throws InternalServerException, ValidationException, S3Exception, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member
     * accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source
     * type in any Region for either accounts that are part of a trusted organization or standalone accounts. At least
     * one of the three dimensions is a mandatory input to this API. However, you can supply any combination of the
     * three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. When you don't provide a dimension, Security Lake assumes that
     * the missing dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API enables all Security Lake member accounts for all sources.
     * Similarly, when you do not specify Regions, Security Lake is enabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * You can use this API only to enable natively supported Amazon Web Services as a source. Use
     * <code>CreateCustomLogSource</code> to enable data collection from a custom source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAwsLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAwsLogSourceRequest#builder()}
     * </p>
     *
     * @param createAwsLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateAwsLogSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAwsLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws S3Exception
     *         Provides an extension of the AmazonServiceException for errors reported by Amazon S3 while processing a
     *         request. In particular, this class provides access to the Amazon S3 extended request ID. If Amazon S3 is
     *         incorrectly handling a request and you need to contact Amazon, this extended request ID may provide
     *         useful debugging information.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAwsLogSourceResponse createAwsLogSource(Consumer<CreateAwsLogSourceRequest.Builder> createAwsLogSourceRequest)
            throws InternalServerException, ValidationException, S3Exception, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return createAwsLogSource(CreateAwsLogSourceRequest.builder().applyMutation(createAwsLogSourceRequest).build());
    }

    /**
     * <p>
     * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to
     * create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating
     * the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This
     * operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from
     * the custom source in addition to an associated Glue table and an Glue crawler.
     * </p>
     *
     * @param createCustomLogSourceRequest
     * @return Result of the CreateCustomLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ConflictSourceNamesException
     *         There was a conflict when you attempted to modify a Security Lake source name.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomLogSourceResponse createCustomLogSource(CreateCustomLogSourceRequest createCustomLogSourceRequest)
            throws InternalServerException, ValidationException, ConflictSourceNamesException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to
     * create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating
     * the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This
     * operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from
     * the custom source in addition to an associated Glue table and an Glue crawler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomLogSourceRequest#builder()}
     * </p>
     *
     * @param createCustomLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomLogSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCustomLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ConflictSourceNamesException
     *         There was a conflict when you attempted to modify a Security Lake source name.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomLogSourceResponse createCustomLogSource(
            Consumer<CreateCustomLogSourceRequest.Builder> createCustomLogSourceRequest) throws InternalServerException,
            ValidationException, ConflictSourceNamesException, AccessDeniedException, BucketNotFoundException,
            ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return createCustomLogSource(CreateCustomLogSourceRequest.builder().applyMutation(createCustomLogSourceRequest).build());
    }

    /**
     * <p>
     * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable
     * Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions.
     * You can either use the <code>enableAll</code> parameter to specify all Regions or specify the Regions where you
     * want to enable Security Lake. To specify particular Regions, use the <code>Regions</code> parameter and then
     * configure these Regions using the <code>configurations</code> parameter. If you have already enabled Security
     * Lake in a Region when you call this command, the command will update the Region if you provide new configuration
     * parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up
     * the data lake in the Region with the specified configurations.
     * </p>
     * <p>
     * When you enable Security Lake, it starts ingesting security data after the <code>CreateAwsLogSource</code> call.
     * This includes ingesting security data from sources, storing data, and making data accessible to subscribers.
     * Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon
     * Web Services account in the current Region, including security log and event data. For more information, see the
     * <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html">Amazon Security
     * Lake User Guide</a>.
     * </p>
     *
     * @param createDatalakeRequest
     * @return Result of the CreateDatalake operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatalakeResponse createDatalake(CreateDatalakeRequest createDatalakeRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable
     * Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions.
     * You can either use the <code>enableAll</code> parameter to specify all Regions or specify the Regions where you
     * want to enable Security Lake. To specify particular Regions, use the <code>Regions</code> parameter and then
     * configure these Regions using the <code>configurations</code> parameter. If you have already enabled Security
     * Lake in a Region when you call this command, the command will update the Region if you provide new configuration
     * parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up
     * the data lake in the Region with the specified configurations.
     * </p>
     * <p>
     * When you enable Security Lake, it starts ingesting security data after the <code>CreateAwsLogSource</code> call.
     * This includes ingesting security data from sources, storing data, and making data accessible to subscribers.
     * Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon
     * Web Services account in the current Region, including security log and event data. For more information, see the
     * <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html">Amazon Security
     * Lake User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatalakeRequest#builder()}
     * </p>
     *
     * @param createDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeRequest.Builder} to create a request.
     * @return Result of the CreateDatalake operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatalakeResponse createDatalake(Consumer<CreateDatalakeRequest.Builder> createDatalakeRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return createDatalake(CreateDatalakeRequest.builder().applyMutation(createDatalakeRequest).build());
    }

    /**
     * <p>
     * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not
     * automatically enabled for any existing member accounts in your organization.
     * </p>
     *
     * @param createDatalakeAutoEnableRequest
     * @return Result of the CreateDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeAutoEnableResponse createDatalakeAutoEnable(
            CreateDatalakeAutoEnableRequest createDatalakeAutoEnableRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not
     * automatically enabled for any existing member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeAutoEnableRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param createDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeAutoEnableResponse createDatalakeAutoEnable(
            Consumer<CreateDatalakeAutoEnableRequest.Builder> createDatalakeAutoEnableRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return createDatalakeAutoEnable(CreateDatalakeAutoEnableRequest.builder().applyMutation(createDatalakeAutoEnableRequest)
                .build());
    }

    /**
     * <p>
     * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     *
     * @param createDatalakeDelegatedAdminRequest
     * @return Result of the CreateDatalakeDelegatedAdmin operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeDelegatedAdminResponse createDatalakeDelegatedAdmin(
            CreateDatalakeDelegatedAdminRequest createDatalakeDelegatedAdminRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatalakeDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDatalakeDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param createDatalakeDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeDelegatedAdminRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDatalakeDelegatedAdmin operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeDelegatedAdminResponse createDatalakeDelegatedAdmin(
            Consumer<CreateDatalakeDelegatedAdminRequest.Builder> createDatalakeDelegatedAdminRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        return createDatalakeDelegatedAdmin(CreateDatalakeDelegatedAdminRequest.builder()
                .applyMutation(createDatalakeDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param createDatalakeExceptionsSubscriptionRequest
     * @return Result of the CreateDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeExceptionsSubscriptionResponse createDatalakeExceptionsSubscription(
            CreateDatalakeExceptionsSubscriptionRequest createDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param createDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return Result of the CreateDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatalakeExceptionsSubscriptionResponse createDatalakeExceptionsSubscription(
            Consumer<CreateDatalakeExceptionsSubscriptionRequest.Builder> createDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return createDatalakeExceptionsSubscription(CreateDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(createDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a
     * subscriber with access to data in the current Amazon Web Services Region.
     * </p>
     *
     * @param createSubscriberRequest
     * @return Result of the CreateSubscriber operation returned by the service.
     * @throws ConflictSubscriptionException
     *         A conflicting subscription exception operation is in progress.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSubscriberResponse createSubscriber(CreateSubscriberRequest createSubscriberRequest)
            throws ConflictSubscriptionException, InternalServerException, ValidationException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a
     * subscriber with access to data in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubscriberRequest#builder()}
     * </p>
     *
     * @param createSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriberRequest.Builder} to create a request.
     * @return Result of the CreateSubscriber operation returned by the service.
     * @throws ConflictSubscriptionException
     *         A conflicting subscription exception operation is in progress.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSubscriberResponse createSubscriber(Consumer<CreateSubscriberRequest.Builder> createSubscriberRequest)
            throws ConflictSubscriptionException, InternalServerException, ValidationException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return createSubscriber(CreateSubscriberRequest.builder().applyMutation(createSubscriberRequest).build());
    }

    /**
     * <p>
     * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in
     * Security Lake.
     * </p>
     *
     * @param createSubscriptionNotificationConfigurationRequest
     * @return Result of the CreateSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionNotificationConfigurationResponse createSubscriptionNotificationConfiguration(
            CreateSubscriptionNotificationConfigurationRequest createSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in
     * Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return Result of the CreateSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.CreateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionNotificationConfigurationResponse createSubscriptionNotificationConfiguration(
            Consumer<CreateSubscriptionNotificationConfigurationRequest.Builder> createSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return createSubscriptionNotificationConfiguration(CreateSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(createSubscriptionNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. When you remove the source,
     * Security Lake stops collecting data from that source, and subscribers can no longer consume new data from the
     * source. Subscribers can still consume data that Security Lake collected from the source before disablement.
     * </p>
     * <p>
     * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted
     * organization or standalone accounts. At least one of the three dimensions is a mandatory input to this API.
     * However, you can supply any combination of the three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API disables all Security Lake member accounts for sources.
     * Similarly, when you do not specify Regions, Security Lake is disabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * When you don't provide a dimension, Security Lake assumes that the missing dimension refers to the entire set.
     * For example, if you don't provide specific accounts, the API applies to the entire set of accounts in your
     * organization.
     * </p>
     *
     * @param deleteAwsLogSourceRequest
     * @return Result of the DeleteAwsLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAwsLogSourceResponse deleteAwsLogSource(DeleteAwsLogSourceRequest deleteAwsLogSourceRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. When you remove the source,
     * Security Lake stops collecting data from that source, and subscribers can no longer consume new data from the
     * source. Subscribers can still consume data that Security Lake collected from the source before disablement.
     * </p>
     * <p>
     * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted
     * organization or standalone accounts. At least one of the three dimensions is a mandatory input to this API.
     * However, you can supply any combination of the three dimensions to this API.
     * </p>
     * <p>
     * By default, a dimension refers to the entire set. This is overridden when you supply any one of the inputs. For
     * instance, when you do not specify members, the API disables all Security Lake member accounts for sources.
     * Similarly, when you do not specify Regions, Security Lake is disabled for all the Regions where Security Lake is
     * available as a service.
     * </p>
     * <p>
     * When you don't provide a dimension, Security Lake assumes that the missing dimension refers to the entire set.
     * For example, if you don't provide specific accounts, the API applies to the entire set of accounts in your
     * organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAwsLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAwsLogSourceRequest#builder()}
     * </p>
     *
     * @param deleteAwsLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAwsLogSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAwsLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteAwsLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAwsLogSourceResponse deleteAwsLogSource(Consumer<DeleteAwsLogSourceRequest.Builder> deleteAwsLogSourceRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return deleteAwsLogSource(DeleteAwsLogSourceRequest.builder().applyMutation(deleteAwsLogSourceRequest).build());
    }

    /**
     * <p>
     * Removes a custom log source from Amazon Security Lake.
     * </p>
     *
     * @param deleteCustomLogSourceRequest
     * @return Result of the DeleteCustomLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ConflictSourceNamesException
     *         There was a conflict when you attempted to modify a Security Lake source name.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomLogSourceResponse deleteCustomLogSource(DeleteCustomLogSourceRequest deleteCustomLogSourceRequest)
            throws InternalServerException, ValidationException, ConflictSourceNamesException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a custom log source from Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomLogSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomLogSourceRequest#builder()}
     * </p>
     *
     * @param deleteCustomLogSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomLogSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCustomLogSource operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ConflictSourceNamesException
     *         There was a conflict when you attempted to modify a Security Lake source name.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteCustomLogSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomLogSourceResponse deleteCustomLogSource(
            Consumer<DeleteCustomLogSourceRequest.Builder> deleteCustomLogSourceRequest) throws InternalServerException,
            ValidationException, ConflictSourceNamesException, AccessDeniedException, BucketNotFoundException,
            ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return deleteCustomLogSource(DeleteCustomLogSourceRequest.builder().applyMutation(deleteCustomLogSourceRequest).build());
    }

    /**
     * <p>
     * When you delete Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services
     * Regions. Also, this API automatically takes steps to remove the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     *
     * @param deleteDatalakeRequest
     * @return Result of the DeleteDatalake operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatalakeResponse deleteDatalake(DeleteDatalakeRequest deleteDatalakeRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you delete Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services
     * Regions. Also, this API automatically takes steps to remove the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatalakeRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeRequest.Builder} to create a request.
     * @return Result of the DeleteDatalake operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatalakeResponse deleteDatalake(Consumer<DeleteDatalakeRequest.Builder> deleteDatalakeRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return deleteDatalake(DeleteDatalakeRequest.builder().applyMutation(deleteDatalakeRequest).build());
    }

    /**
     * <p>
     * Automatically deletes Amazon Security Lake to stop collecting security data. When you delete Amazon Security Lake
     * from your account, Security Lake is disabled in all Regions. Also, this API automatically takes steps to remove
     * the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     *
     * @param deleteDatalakeAutoEnableRequest
     * @return Result of the DeleteDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeAutoEnableResponse deleteDatalakeAutoEnable(
            DeleteDatalakeAutoEnableRequest deleteDatalakeAutoEnableRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Automatically deletes Amazon Security Lake to stop collecting security data. When you delete Amazon Security Lake
     * from your account, Security Lake is disabled in all Regions. Also, this API automatically takes steps to remove
     * the account from Security Lake .
     * </p>
     * <p>
     * This operation disables security data collection from sources, deletes data stored, and stops making data
     * accessible to subscribers. Security Lake also deletes all the existing settings and resources that it stores or
     * maintains for your Amazon Web Services account in the current Region, including security log and event data. The
     * <code>DeleteDatalake</code> operation does not delete the Amazon S3 bucket, which is owned by your Amazon Web
     * Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeAutoEnableRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeAutoEnableResponse deleteDatalakeAutoEnable(
            Consumer<DeleteDatalakeAutoEnableRequest.Builder> deleteDatalakeAutoEnableRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return deleteDatalakeAutoEnable(DeleteDatalakeAutoEnableRequest.builder().applyMutation(deleteDatalakeAutoEnableRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     *
     * @param deleteDatalakeDelegatedAdminRequest
     * @return Result of the DeleteDatalakeDelegatedAdmin operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeDelegatedAdminResponse deleteDatalakeDelegatedAdmin(
            DeleteDatalakeDelegatedAdminRequest deleteDatalakeDelegatedAdminRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be
     * called by the organization management account. The organization management account cannot be the delegated
     * administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatalakeDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDatalakeDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeDelegatedAdminRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDatalakeDelegatedAdmin operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeDelegatedAdminResponse deleteDatalakeDelegatedAdmin(
            Consumer<DeleteDatalakeDelegatedAdminRequest.Builder> deleteDatalakeDelegatedAdminRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        return deleteDatalakeDelegatedAdmin(DeleteDatalakeDelegatedAdminRequest.builder()
                .applyMutation(deleteDatalakeDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param deleteDatalakeExceptionsSubscriptionRequest
     * @return Result of the DeleteDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeExceptionsSubscriptionResponse deleteDatalakeExceptionsSubscription(
            DeleteDatalakeExceptionsSubscriptionRequest deleteDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatalakeExceptionsSubscriptionResponse deleteDatalakeExceptionsSubscription(
            Consumer<DeleteDatalakeExceptionsSubscriptionRequest.Builder> deleteDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return deleteDatalakeExceptionsSubscription(DeleteDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(deleteDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the subscription permission for accounts that are already enabled in Amazon Security Lake. You can delete
     * a subscriber and remove access to data in the current Amazon Web Services Region.
     * </p>
     *
     * @param deleteSubscriberRequest
     * @return Result of the DeleteSubscriber operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the subscription permission for accounts that are already enabled in Amazon Security Lake. You can delete
     * a subscriber and remove access to data in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubscriberRequest#builder()}
     * </p>
     *
     * @param deleteSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubscriberRequest.Builder} to create a request.
     * @return Result of the DeleteSubscriber operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws BucketNotFoundException
     *         Amazon Security Lake generally returns 404 errors if the requested object is missing from the bucket.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSubscriberResponse deleteSubscriber(Consumer<DeleteSubscriberRequest.Builder> deleteSubscriberRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return deleteSubscriber(DeleteSubscriberRequest.builder().applyMutation(deleteSubscriberRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param deleteSubscriptionNotificationConfigurationRequest
     * @return Result of the DeleteSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionNotificationConfigurationResponse deleteSubscriptionNotificationConfiguration(
            DeleteSubscriptionNotificationConfigurationRequest deleteSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return Result of the DeleteSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.DeleteSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionNotificationConfigurationResponse deleteSubscriptionNotificationConfiguration(
            Consumer<DeleteSubscriptionNotificationConfigurationRequest.Builder> deleteSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return deleteSubscriptionNotificationConfiguration(DeleteSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(deleteSubscriptionNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services account ID. You can
     * use the <code>GetDatalake</code> API to know whether Security Lake is enabled for the current Region. This API
     * does not take input parameters.
     * </p>
     *
     * @param getDatalakeRequest
     * @return Result of the GetDatalake operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatalakeResponse getDatalake(GetDatalakeRequest getDatalakeRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services account ID. You can
     * use the <code>GetDatalake</code> API to know whether Security Lake is enabled for the current Region. This API
     * does not take input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatalakeRequest#builder()}
     * </p>
     *
     * @param getDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeRequest.Builder} to create a request.
     * @return Result of the GetDatalake operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatalakeResponse getDatalake(Consumer<GetDatalakeRequest.Builder> getDatalakeRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return getDatalake(GetDatalakeRequest.builder().applyMutation(getDatalakeRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration that will be automatically set up for accounts added to the organization after the
     * organization has onboarded to Amazon Security Lake. This API does not take input parameters.
     * </p>
     *
     * @param getDatalakeAutoEnableRequest
     * @return Result of the GetDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeAutoEnableResponse getDatalakeAutoEnable(GetDatalakeAutoEnableRequest getDatalakeAutoEnableRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration that will be automatically set up for accounts added to the organization after the
     * organization has onboarded to Amazon Security Lake. This API does not take input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeAutoEnableRequest.Builder} avoiding the
     * need to create one manually via {@link GetDatalakeAutoEnableRequest#builder()}
     * </p>
     *
     * @param getDatalakeAutoEnableRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeAutoEnableRequest.Builder} to create a
     *        request.
     * @return Result of the GetDatalakeAutoEnable operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeAutoEnable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeAutoEnableResponse getDatalakeAutoEnable(
            Consumer<GetDatalakeAutoEnableRequest.Builder> getDatalakeAutoEnableRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return getDatalakeAutoEnable(GetDatalakeAutoEnableRequest.builder().applyMutation(getDatalakeAutoEnableRequest).build());
    }

    /**
     * <p>
     * Retrieves the expiration period and time-to-live (TTL) for which the exception message will remain. Exceptions
     * are stored by default, for 2 weeks from when a record was created in Amazon Security Lake. This API does not take
     * input parameters.
     * </p>
     *
     * @param getDatalakeExceptionsExpiryRequest
     * @return Result of the GetDatalakeExceptionsExpiry operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeExceptionsExpiryResponse getDatalakeExceptionsExpiry(
            GetDatalakeExceptionsExpiryRequest getDatalakeExceptionsExpiryRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the expiration period and time-to-live (TTL) for which the exception message will remain. Exceptions
     * are stored by default, for 2 weeks from when a record was created in Amazon Security Lake. This API does not take
     * input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeExceptionsExpiryRequest.Builder}
     * avoiding the need to create one manually via {@link GetDatalakeExceptionsExpiryRequest#builder()}
     * </p>
     *
     * @param getDatalakeExceptionsExpiryRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeExceptionsExpiryRequest.Builder} to create
     *        a request.
     * @return Result of the GetDatalakeExceptionsExpiry operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeExceptionsExpiryResponse getDatalakeExceptionsExpiry(
            Consumer<GetDatalakeExceptionsExpiryRequest.Builder> getDatalakeExceptionsExpiryRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return getDatalakeExceptionsExpiry(GetDatalakeExceptionsExpiryRequest.builder()
                .applyMutation(getDatalakeExceptionsExpiryRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of exception notifications for the account in Amazon Security Lake.
     * </p>
     *
     * @param getDatalakeExceptionsSubscriptionRequest
     * @return Result of the GetDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeExceptionsSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeExceptionsSubscriptionResponse getDatalakeExceptionsSubscription(
            GetDatalakeExceptionsSubscriptionRequest getDatalakeExceptionsSubscriptionRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of exception notifications for the account in Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeExceptionsSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link GetDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param getDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeExceptionsSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the GetDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeExceptionsSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeExceptionsSubscriptionResponse getDatalakeExceptionsSubscription(
            Consumer<GetDatalakeExceptionsSubscriptionRequest.Builder> getDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return getDatalakeExceptionsSubscription(GetDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(getDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     *
     * @param getDatalakeStatusRequest
     * @return Result of the GetDatalakeStatus operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusResponse getDatalakeStatus(GetDatalakeStatusRequest getDatalakeStatusRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetDatalakeStatusRequest#builder()}
     * </p>
     *
     * @param getDatalakeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeStatusRequest.Builder} to create a request.
     * @return Result of the GetDatalakeStatus operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusResponse getDatalakeStatus(Consumer<GetDatalakeStatusRequest.Builder> getDatalakeStatusRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return getDatalakeStatus(GetDatalakeStatusRequest.builder().applyMutation(getDatalakeStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client.getDatalakeStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client
     *             .getDatalakeStatusPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client.getDatalakeStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxAccountResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDatalakeStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusIterable getDatalakeStatusPaginator(GetDatalakeStatusRequest getDatalakeStatusRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts
     * and which sources Security Lake is collecting data from.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client.getDatalakeStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client
     *             .getDatalakeStatusPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable responses = client.getDatalakeStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxAccountResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatalakeStatus(software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatalakeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetDatalakeStatusRequest#builder()}
     * </p>
     *
     * @param getDatalakeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDatalakeStatusRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetDatalakeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDatalakeStatusIterable getDatalakeStatusPaginator(
            Consumer<GetDatalakeStatusRequest.Builder> getDatalakeStatusRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return getDatalakeStatusPaginator(GetDatalakeStatusRequest.builder().applyMutation(getDatalakeStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves the subscription information for the specified subscription ID. You can get information about a
     * specific subscriber.
     * </p>
     *
     * @param getSubscriberRequest
     * @return Result of the GetSubscriber operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriberResponse getSubscriber(GetSubscriberRequest getSubscriberRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the subscription information for the specified subscription ID. You can get information about a
     * specific subscriber.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriberRequest.Builder} avoiding the need to
     * create one manually via {@link GetSubscriberRequest#builder()}
     * </p>
     *
     * @param getSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriberRequest.Builder} to create a request.
     * @return Result of the GetSubscriber operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.GetSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriberResponse getSubscriber(Consumer<GetSubscriberRequest.Builder> getSubscriberRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException,
            InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        return getSubscriber(GetSubscriberRequest.builder().applyMutation(getSubscriberRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     * @return Result of the ListDatalakeExceptions operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsResponse listDatalakeExceptions(ListDatalakeExceptionsRequest listDatalakeExceptionsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatalakeExceptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatalakeExceptionsRequest#builder()}
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatalakeExceptionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatalakeExceptions operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsResponse listDatalakeExceptions(
            Consumer<ListDatalakeExceptionsRequest.Builder> listDatalakeExceptionsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return listDatalakeExceptions(ListDatalakeExceptionsRequest.builder().applyMutation(listDatalakeExceptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client.listDatalakeExceptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client
     *             .listDatalakeExceptionsPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client.listDatalakeExceptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxFailures won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsIterable listDatalakeExceptionsPaginator(
            ListDatalakeExceptionsRequest listDatalakeExceptionsRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client.listDatalakeExceptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client
     *             .listDatalakeExceptionsPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable responses = client.listDatalakeExceptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxFailures won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatalakeExceptions(software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatalakeExceptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatalakeExceptionsRequest#builder()}
     * </p>
     *
     * @param listDatalakeExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatalakeExceptionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListDatalakeExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatalakeExceptionsIterable listDatalakeExceptionsPaginator(
            Consumer<ListDatalakeExceptionsRequest.Builder> listDatalakeExceptionsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return listDatalakeExceptionsPaginator(ListDatalakeExceptionsRequest.builder()
                .applyMutation(listDatalakeExceptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     *
     * @param listLogSourcesRequest
     * @return Result of the ListLogSources operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesResponse listLogSources(ListLogSourcesRequest listLogSourcesRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLogSourcesRequest#builder()}
     * </p>
     *
     * @param listLogSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListLogSourcesRequest.Builder} to create a request.
     * @return Result of the ListLogSources operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesResponse listLogSources(Consumer<ListLogSourcesRequest.Builder> listLogSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return listLogSources(ListLogSourcesRequest.builder().applyMutation(listLogSourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client.listLogSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client
     *             .listLogSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client.listLogSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listLogSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesIterable listLogSourcesPaginator(ListLogSourcesRequest listLogSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the log sources in the current Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client.listLogSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client
     *             .listLogSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable responses = client.listLogSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSources(software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLogSourcesRequest#builder()}
     * </p>
     *
     * @param listLogSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListLogSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListLogSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogSourcesIterable listLogSourcesPaginator(Consumer<ListLogSourcesRequest.Builder> listLogSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return listLogSourcesPaginator(ListLogSourcesRequest.builder().applyMutation(listLogSourcesRequest).build());
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     *
     * @param listSubscribersRequest
     * @return Result of the ListSubscribers operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersResponse listSubscribers(ListSubscribersRequest listSubscribersRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribersRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscribersRequest#builder()}
     * </p>
     *
     * @param listSubscribersRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribersRequest.Builder} to create a request.
     * @return Result of the ListSubscribers operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersResponse listSubscribers(Consumer<ListSubscribersRequest.Builder> listSubscribersRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        return listSubscribers(ListSubscribersRequest.builder().applyMutation(listSubscribersRequest).build());
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client.listSubscribersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client
     *             .listSubscribersPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client.listSubscribersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscribersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersIterable listSubscribersPaginator(ListSubscribersRequest listSubscribersRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions
     * associated with a specific organization or Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client.listSubscribersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client
     *             .listSubscribersPaginator(request);
     *     for (software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable responses = client.listSubscribersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribers(software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribersRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscribersRequest#builder()}
     * </p>
     *
     * @param listSubscribersRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.ListSubscribers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscribersIterable listSubscribersPaginator(Consumer<ListSubscribersRequest.Builder> listSubscribersRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        return listSubscribersPaginator(ListSubscribersRequest.builder().applyMutation(listSubscribersRequest).build());
    }

    /**
     * <p>
     * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data
     * from multiple Amazon Web Services Regions.
     * </p>
     *
     * @param updateDatalakeRequest
     * @return Result of the UpdateDatalake operation returned by the service.
     * @throws EventBridgeException
     *         Represents an error interacting with the Amazon EventBridge service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDatalakeResponse updateDatalake(UpdateDatalakeRequest updateDatalakeRequest) throws EventBridgeException,
            InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data
     * from multiple Amazon Web Services Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatalakeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatalakeRequest#builder()}
     * </p>
     *
     * @param updateDatalakeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeRequest.Builder} to create a request.
     * @return Result of the UpdateDatalake operation returned by the service.
     * @throws EventBridgeException
     *         Represents an error interacting with the Amazon EventBridge service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDatalakeResponse updateDatalake(Consumer<UpdateDatalakeRequest.Builder> updateDatalakeRequest)
            throws EventBridgeException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return updateDatalake(UpdateDatalakeRequest.builder().applyMutation(updateDatalakeRequest).build());
    }

    /**
     * <p>
     * Update the expiration period for the exception message to your preferred time, and control the time-to-live (TTL)
     * for the exception message to remain. Exceptions are stored by default for 2 weeks from when a record was created
     * in Amazon Security Lake.
     * </p>
     *
     * @param updateDatalakeExceptionsExpiryRequest
     * @return Result of the UpdateDatalakeExceptionsExpiry operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatalakeExceptionsExpiryResponse updateDatalakeExceptionsExpiry(
            UpdateDatalakeExceptionsExpiryRequest updateDatalakeExceptionsExpiryRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the expiration period for the exception message to your preferred time, and control the time-to-live (TTL)
     * for the exception message to remain. Exceptions are stored by default for 2 weeks from when a record was created
     * in Amazon Security Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatalakeExceptionsExpiryRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDatalakeExceptionsExpiryRequest#builder()}
     * </p>
     *
     * @param updateDatalakeExceptionsExpiryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeExceptionsExpiryRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDatalakeExceptionsExpiry operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalakeExceptionsExpiry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatalakeExceptionsExpiryResponse updateDatalakeExceptionsExpiry(
            Consumer<UpdateDatalakeExceptionsExpiryRequest.Builder> updateDatalakeExceptionsExpiryRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return updateDatalakeExceptionsExpiry(UpdateDatalakeExceptionsExpiryRequest.builder()
                .applyMutation(updateDatalakeExceptionsExpiryRequest).build());
    }

    /**
     * <p>
     * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     *
     * @param updateDatalakeExceptionsSubscriptionRequest
     * @return Result of the UpdateDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatalakeExceptionsSubscriptionResponse updateDatalakeExceptionsSubscription(
            UpdateDatalakeExceptionsSubscriptionRequest updateDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateDatalakeExceptionsSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateDatalakeExceptionsSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateDatalakeExceptionsSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatalakeExceptionsSubscriptionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateDatalakeExceptionsSubscription operation returned by the service.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateDatalakeExceptionsSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatalakeExceptionsSubscriptionResponse updateDatalakeExceptionsSubscription(
            Consumer<UpdateDatalakeExceptionsSubscriptionRequest.Builder> updateDatalakeExceptionsSubscriptionRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException,
            AwsServiceException, SdkClientException, SecurityLakeException {
        return updateDatalakeExceptionsSubscription(UpdateDatalakeExceptionsSubscriptionRequest.builder()
                .applyMutation(updateDatalakeExceptionsSubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by
     * changing the sources that the subscriber consumes data from.
     * </p>
     *
     * @param updateSubscriberRequest
     * @return Result of the UpdateSubscriber operation returned by the service.
     * @throws ConflictSubscriptionException
     *         A conflicting subscription exception operation is in progress.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest)
            throws ConflictSubscriptionException, ConcurrentModificationException, InternalServerException, ValidationException,
            AccessDeniedException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by
     * changing the sources that the subscriber consumes data from.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubscriberRequest#builder()}
     * </p>
     *
     * @param updateSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriberRequest.Builder} to create a request.
     * @return Result of the UpdateSubscriber operation returned by the service.
     * @throws ConflictSubscriptionException
     *         A conflicting subscription exception operation is in progress.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateSubscriber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSubscriberResponse updateSubscriber(Consumer<UpdateSubscriberRequest.Builder> updateSubscriberRequest)
            throws ConflictSubscriptionException, ConcurrentModificationException, InternalServerException, ValidationException,
            AccessDeniedException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return updateSubscriber(UpdateSubscriberRequest.builder().applyMutation(updateSubscriberRequest).build());
    }

    /**
     * <p>
     * Creates a new subscription notification or adds the existing subscription notification setting for the specified
     * subscription ID.
     * </p>
     *
     * @param updateSubscriptionNotificationConfigurationRequest
     * @return Result of the UpdateSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionNotificationConfigurationResponse updateSubscriptionNotificationConfiguration(
            UpdateSubscriptionNotificationConfigurationRequest updateSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new subscription notification or adds the existing subscription notification setting for the specified
     * subscription ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateSubscriptionNotificationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateSubscriptionNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateSubscriptionNotificationConfigurationRequest.Builder} to create a request.
     * @return Result of the UpdateSubscriptionNotificationConfiguration operation returned by the service.
     * @throws ConcurrentModificationException
     *         More than one process tried to modify a resource at the same time.
     * @throws InternalServerException
     *         Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting,
     *         perform the operation again.
     * @throws ValidationException
     *         Your signing certificate could not be validated.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. Access denied errors appear when Amazon
     *         Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a
     *         policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs
     *         when there is no applicable Deny statement and also no applicable Allow statement.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccountNotFoundException
     *         Amazon Security Lake cannot find an Amazon Web Services account with the accountID that you specified, or
     *         the account whose credentials you used to make this request isn't a member of an organization.
     * @throws InvalidInputException
     *         The request was rejected because a value that's not valid or is out of range was supplied for an input
     *         parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityLakeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityLakeClient.UpdateSubscriptionNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionNotificationConfigurationResponse updateSubscriptionNotificationConfiguration(
            Consumer<UpdateSubscriptionNotificationConfigurationRequest.Builder> updateSubscriptionNotificationConfigurationRequest)
            throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityLakeException {
        return updateSubscriptionNotificationConfiguration(UpdateSubscriptionNotificationConfigurationRequest.builder()
                .applyMutation(updateSubscriptionNotificationConfigurationRequest).build());
    }

    /**
     * Create a {@link SecurityLakeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityLakeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityLakeClient}.
     */
    static SecurityLakeClientBuilder builder() {
        return new DefaultSecurityLakeClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
