/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatalakeExceptionsSubscriptionRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<UpdateDatalakeExceptionsSubscriptionRequest.Builder, UpdateDatalakeExceptionsSubscriptionRequest> {
    private static final SdkField<String> NOTIFICATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationEndpoint").getter(getter(UpdateDatalakeExceptionsSubscriptionRequest::notificationEndpoint))
            .setter(setter(Builder::notificationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEndpoint").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionProtocol")
            .getter(getter(UpdateDatalakeExceptionsSubscriptionRequest::subscriptionProtocolAsString))
            .setter(setter(Builder::subscriptionProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionProtocol").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ENDPOINT_FIELD,
            SUBSCRIPTION_PROTOCOL_FIELD));

    private final String notificationEndpoint;

    private final String subscriptionProtocol;

    private UpdateDatalakeExceptionsSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.notificationEndpoint = builder.notificationEndpoint;
        this.subscriptionProtocol = builder.subscriptionProtocol;
    }

    /**
     * <p>
     * The account that is subscribed to receive exception notifications.
     * </p>
     * 
     * @return The account that is subscribed to receive exception notifications.
     */
    public final String notificationEndpoint() {
        return notificationEndpoint;
    }

    /**
     * <p>
     * The subscription protocol to which exception messages are posted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProtocol} will return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #subscriptionProtocolAsString}.
     * </p>
     * 
     * @return The subscription protocol to which exception messages are posted.
     * @see SubscriptionProtocolType
     */
    public final SubscriptionProtocolType subscriptionProtocol() {
        return SubscriptionProtocolType.fromValue(subscriptionProtocol);
    }

    /**
     * <p>
     * The subscription protocol to which exception messages are posted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProtocol} will return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #subscriptionProtocolAsString}.
     * </p>
     * 
     * @return The subscription protocol to which exception messages are posted.
     * @see SubscriptionProtocolType
     */
    public final String subscriptionProtocolAsString() {
        return subscriptionProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notificationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProtocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatalakeExceptionsSubscriptionRequest)) {
            return false;
        }
        UpdateDatalakeExceptionsSubscriptionRequest other = (UpdateDatalakeExceptionsSubscriptionRequest) obj;
        return Objects.equals(notificationEndpoint(), other.notificationEndpoint())
                && Objects.equals(subscriptionProtocolAsString(), other.subscriptionProtocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatalakeExceptionsSubscriptionRequest")
                .add("NotificationEndpoint", notificationEndpoint()).add("SubscriptionProtocol", subscriptionProtocolAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationEndpoint":
            return Optional.ofNullable(clazz.cast(notificationEndpoint()));
        case "subscriptionProtocol":
            return Optional.ofNullable(clazz.cast(subscriptionProtocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatalakeExceptionsSubscriptionRequest, T> g) {
        return obj -> g.apply((UpdateDatalakeExceptionsSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDatalakeExceptionsSubscriptionRequest> {
        /**
         * <p>
         * The account that is subscribed to receive exception notifications.
         * </p>
         * 
         * @param notificationEndpoint
         *        The account that is subscribed to receive exception notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEndpoint(String notificationEndpoint);

        /**
         * <p>
         * The subscription protocol to which exception messages are posted.
         * </p>
         * 
         * @param subscriptionProtocol
         *        The subscription protocol to which exception messages are posted.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder subscriptionProtocol(String subscriptionProtocol);

        /**
         * <p>
         * The subscription protocol to which exception messages are posted.
         * </p>
         * 
         * @param subscriptionProtocol
         *        The subscription protocol to which exception messages are posted.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder subscriptionProtocol(SubscriptionProtocolType subscriptionProtocol);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private String notificationEndpoint;

        private String subscriptionProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatalakeExceptionsSubscriptionRequest model) {
            super(model);
            notificationEndpoint(model.notificationEndpoint);
            subscriptionProtocol(model.subscriptionProtocol);
        }

        public final String getNotificationEndpoint() {
            return notificationEndpoint;
        }

        public final void setNotificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
        }

        @Override
        public final Builder notificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
            return this;
        }

        public final String getSubscriptionProtocol() {
            return subscriptionProtocol;
        }

        public final void setSubscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
        }

        @Override
        public final Builder subscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
            return this;
        }

        @Override
        public final Builder subscriptionProtocol(SubscriptionProtocolType subscriptionProtocol) {
            this.subscriptionProtocol(subscriptionProtocol == null ? null : subscriptionProtocol.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatalakeExceptionsSubscriptionRequest build() {
            return new UpdateDatalakeExceptionsSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
