/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves the Logs status for the Amazon Security Lake account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsStatus implements SdkPojo, Serializable, ToCopyableBuilder<LogsStatus.Builder, LogsStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthStatus").getter(getter(LogsStatus::healthStatusAsString)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final SdkField<String> PATH_TO_LOGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pathToLogs").getter(getter(LogsStatus::pathToLogs)).setter(setter(Builder::pathToLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathToLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD,
            PATH_TO_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String healthStatus;

    private final String pathToLogs;

    private LogsStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.pathToLogs = builder.pathToLogs;
    }

    /**
     * <p>
     * The health status of services, including error codes and patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link SourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of services, including error codes and patterns.
     * @see SourceStatus
     */
    public final SourceStatus healthStatus() {
        return SourceStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * The health status of services, including error codes and patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link SourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of services, including error codes and patterns.
     * @see SourceStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * Defines path the stored logs are available which has information on your systems, applications, and services.
     * </p>
     * 
     * @return Defines path the stored logs are available which has information on your systems, applications, and
     *         services.
     */
    public final String pathToLogs() {
        return pathToLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pathToLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsStatus)) {
            return false;
        }
        LogsStatus other = (LogsStatus) obj;
        return Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(pathToLogs(), other.pathToLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsStatus").add("HealthStatus", healthStatusAsString()).add("PathToLogs", pathToLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "pathToLogs":
            return Optional.ofNullable(clazz.cast(pathToLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogsStatus, T> g) {
        return obj -> g.apply((LogsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsStatus> {
        /**
         * <p>
         * The health status of services, including error codes and patterns.
         * </p>
         * 
         * @param healthStatus
         *        The health status of services, including error codes and patterns.
         * @see SourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The health status of services, including error codes and patterns.
         * </p>
         * 
         * @param healthStatus
         *        The health status of services, including error codes and patterns.
         * @see SourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceStatus
         */
        Builder healthStatus(SourceStatus healthStatus);

        /**
         * <p>
         * Defines path the stored logs are available which has information on your systems, applications, and services.
         * </p>
         * 
         * @param pathToLogs
         *        Defines path the stored logs are available which has information on your systems, applications, and
         *        services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathToLogs(String pathToLogs);
    }

    static final class BuilderImpl implements Builder {
        private String healthStatus;

        private String pathToLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsStatus model) {
            healthStatus(model.healthStatus);
            pathToLogs(model.pathToLogs);
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(SourceStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getPathToLogs() {
            return pathToLogs;
        }

        public final void setPathToLogs(String pathToLogs) {
            this.pathToLogs = pathToLogs;
        }

        @Override
        public final Builder pathToLogs(String pathToLogs) {
            this.pathToLogs = pathToLogs;
            return this;
        }

        @Override
        public LogsStatus build() {
            return new LogsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
