/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatalakeExceptionsSubscriptionResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<GetDatalakeExceptionsSubscriptionResponse.Builder, GetDatalakeExceptionsSubscriptionResponse> {
    private static final SdkField<ProtocolAndNotificationEndpoint> PROTOCOL_AND_NOTIFICATION_ENDPOINT_FIELD = SdkField
            .<ProtocolAndNotificationEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("protocolAndNotificationEndpoint")
            .getter(getter(GetDatalakeExceptionsSubscriptionResponse::protocolAndNotificationEndpoint))
            .setter(setter(Builder::protocolAndNotificationEndpoint))
            .constructor(ProtocolAndNotificationEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolAndNotificationEndpoint")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROTOCOL_AND_NOTIFICATION_ENDPOINT_FIELD));

    private final ProtocolAndNotificationEndpoint protocolAndNotificationEndpoint;

    private GetDatalakeExceptionsSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.protocolAndNotificationEndpoint = builder.protocolAndNotificationEndpoint;
    }

    /**
     * <p>
     * Retrieves the exception notification subscription information.
     * </p>
     * 
     * @return Retrieves the exception notification subscription information.
     */
    public final ProtocolAndNotificationEndpoint protocolAndNotificationEndpoint() {
        return protocolAndNotificationEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protocolAndNotificationEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeExceptionsSubscriptionResponse)) {
            return false;
        }
        GetDatalakeExceptionsSubscriptionResponse other = (GetDatalakeExceptionsSubscriptionResponse) obj;
        return Objects.equals(protocolAndNotificationEndpoint(), other.protocolAndNotificationEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatalakeExceptionsSubscriptionResponse")
                .add("ProtocolAndNotificationEndpoint", protocolAndNotificationEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocolAndNotificationEndpoint":
            return Optional.ofNullable(clazz.cast(protocolAndNotificationEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeExceptionsSubscriptionResponse, T> g) {
        return obj -> g.apply((GetDatalakeExceptionsSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDatalakeExceptionsSubscriptionResponse> {
        /**
         * <p>
         * Retrieves the exception notification subscription information.
         * </p>
         * 
         * @param protocolAndNotificationEndpoint
         *        Retrieves the exception notification subscription information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolAndNotificationEndpoint(ProtocolAndNotificationEndpoint protocolAndNotificationEndpoint);

        /**
         * <p>
         * Retrieves the exception notification subscription information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtocolAndNotificationEndpoint.Builder}
         * avoiding the need to create one manually via {@link ProtocolAndNotificationEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtocolAndNotificationEndpoint.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #protocolAndNotificationEndpoint(ProtocolAndNotificationEndpoint)}.
         * 
         * @param protocolAndNotificationEndpoint
         *        a consumer that will call methods on {@link ProtocolAndNotificationEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolAndNotificationEndpoint(ProtocolAndNotificationEndpoint)
         */
        default Builder protocolAndNotificationEndpoint(
                Consumer<ProtocolAndNotificationEndpoint.Builder> protocolAndNotificationEndpoint) {
            return protocolAndNotificationEndpoint(ProtocolAndNotificationEndpoint.builder()
                    .applyMutation(protocolAndNotificationEndpoint).build());
        }
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private ProtocolAndNotificationEndpoint protocolAndNotificationEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeExceptionsSubscriptionResponse model) {
            super(model);
            protocolAndNotificationEndpoint(model.protocolAndNotificationEndpoint);
        }

        public final ProtocolAndNotificationEndpoint.Builder getProtocolAndNotificationEndpoint() {
            return protocolAndNotificationEndpoint != null ? protocolAndNotificationEndpoint.toBuilder() : null;
        }

        public final void setProtocolAndNotificationEndpoint(
                ProtocolAndNotificationEndpoint.BuilderImpl protocolAndNotificationEndpoint) {
            this.protocolAndNotificationEndpoint = protocolAndNotificationEndpoint != null ? protocolAndNotificationEndpoint
                    .build() : null;
        }

        @Override
        public final Builder protocolAndNotificationEndpoint(ProtocolAndNotificationEndpoint protocolAndNotificationEndpoint) {
            this.protocolAndNotificationEndpoint = protocolAndNotificationEndpoint;
            return this;
        }

        @Override
        public GetDatalakeExceptionsSubscriptionResponse build() {
            return new GetDatalakeExceptionsSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
