/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomLogSourceResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<DeleteCustomLogSourceResponse.Builder, DeleteCustomLogSourceResponse> {
    private static final SdkField<String> CUSTOM_DATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDataLocation").getter(getter(DeleteCustomLogSourceResponse::customDataLocation))
            .setter(setter(Builder::customDataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_LOCATION_FIELD));

    private final String customDataLocation;

    private DeleteCustomLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.customDataLocation = builder.customDataLocation;
    }

    /**
     * <p>
     * The location of the partition in the Amazon S3 bucket for Security Lake.
     * </p>
     * 
     * @return The location of the partition in the Amazon S3 bucket for Security Lake.
     */
    public final String customDataLocation() {
        return customDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomLogSourceResponse)) {
            return false;
        }
        DeleteCustomLogSourceResponse other = (DeleteCustomLogSourceResponse) obj;
        return Objects.equals(customDataLocation(), other.customDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomLogSourceResponse").add("CustomDataLocation", customDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDataLocation":
            return Optional.ofNullable(clazz.cast(customDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomLogSourceResponse, T> g) {
        return obj -> g.apply((DeleteCustomLogSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCustomLogSourceResponse> {
        /**
         * <p>
         * The location of the partition in the Amazon S3 bucket for Security Lake.
         * </p>
         * 
         * @param customDataLocation
         *        The location of the partition in the Amazon S3 bucket for Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataLocation(String customDataLocation);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private String customDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomLogSourceResponse model) {
            super(model);
            customDataLocation(model.customDataLocation);
        }

        public final String getCustomDataLocation() {
            return customDataLocation;
        }

        public final void setCustomDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
        }

        @Override
        public final Builder customDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
            return this;
        }

        @Override
        public DeleteCustomLogSourceResponse build() {
            return new DeleteCustomLogSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
