/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request. This is set to
 * Completed after the configuration is updated, or removed if deletion of the data lake is successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStatus implements SdkPojo, Serializable, ToCopyableBuilder<UpdateStatus.Builder, UpdateStatus> {
    private static final SdkField<LastUpdateFailure> LAST_UPDATE_FAILURE_FIELD = SdkField
            .<LastUpdateFailure> builder(MarshallingType.SDK_POJO).memberName("lastUpdateFailure")
            .getter(getter(UpdateStatus::lastUpdateFailure)).setter(setter(Builder::lastUpdateFailure))
            .constructor(LastUpdateFailure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateFailure").build()).build();

    private static final SdkField<String> LAST_UPDATE_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdateRequestId").getter(getter(UpdateStatus::lastUpdateRequestId))
            .setter(setter(Builder::lastUpdateRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateRequestId").build())
            .build();

    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdateStatus").getter(getter(UpdateStatus::lastUpdateStatusAsString))
            .setter(setter(Builder::lastUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATE_FAILURE_FIELD,
            LAST_UPDATE_REQUEST_ID_FIELD, LAST_UPDATE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LastUpdateFailure lastUpdateFailure;

    private final String lastUpdateRequestId;

    private final String lastUpdateStatus;

    private UpdateStatus(BuilderImpl builder) {
        this.lastUpdateFailure = builder.lastUpdateFailure;
        this.lastUpdateRequestId = builder.lastUpdateRequestId;
        this.lastUpdateStatus = builder.lastUpdateStatus;
    }

    /**
     * <p>
     * The details of the last <code>UpdateDatalake</code>or <code>DeleteDatalake</code> API request which failed.
     * </p>
     * 
     * @return The details of the last <code>UpdateDatalake</code>or <code>DeleteDatalake</code> API request which
     *         failed.
     */
    public final LastUpdateFailure lastUpdateFailure() {
        return lastUpdateFailure;
    }

    /**
     * <p>
     * The unique ID for the <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request.
     * </p>
     * 
     * @return The unique ID for the <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request.
     */
    public final String lastUpdateRequestId() {
        return lastUpdateRequestId;
    }

    /**
     * <p>
     * The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link SettingsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
     *         requested.
     * @see SettingsStatus
     */
    public final SettingsStatus lastUpdateStatus() {
        return SettingsStatus.fromValue(lastUpdateStatus);
    }

    /**
     * <p>
     * The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link SettingsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
     *         requested.
     * @see SettingsStatus
     */
    public final String lastUpdateStatusAsString() {
        return lastUpdateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateFailure());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStatus)) {
            return false;
        }
        UpdateStatus other = (UpdateStatus) obj;
        return Objects.equals(lastUpdateFailure(), other.lastUpdateFailure())
                && Objects.equals(lastUpdateRequestId(), other.lastUpdateRequestId())
                && Objects.equals(lastUpdateStatusAsString(), other.lastUpdateStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStatus").add("LastUpdateFailure", lastUpdateFailure())
                .add("LastUpdateRequestId", lastUpdateRequestId()).add("LastUpdateStatus", lastUpdateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastUpdateFailure":
            return Optional.ofNullable(clazz.cast(lastUpdateFailure()));
        case "lastUpdateRequestId":
            return Optional.ofNullable(clazz.cast(lastUpdateRequestId()));
        case "lastUpdateStatus":
            return Optional.ofNullable(clazz.cast(lastUpdateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStatus, T> g) {
        return obj -> g.apply((UpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateStatus> {
        /**
         * <p>
         * The details of the last <code>UpdateDatalake</code>or <code>DeleteDatalake</code> API request which failed.
         * </p>
         * 
         * @param lastUpdateFailure
         *        The details of the last <code>UpdateDatalake</code>or <code>DeleteDatalake</code> API request which
         *        failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateFailure(LastUpdateFailure lastUpdateFailure);

        /**
         * <p>
         * The details of the last <code>UpdateDatalake</code>or <code>DeleteDatalake</code> API request which failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUpdateFailure.Builder} avoiding the
         * need to create one manually via {@link LastUpdateFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastUpdateFailure.Builder#build()} is called immediately and its
         * result is passed to {@link #lastUpdateFailure(LastUpdateFailure)}.
         * 
         * @param lastUpdateFailure
         *        a consumer that will call methods on {@link LastUpdateFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdateFailure(LastUpdateFailure)
         */
        default Builder lastUpdateFailure(Consumer<LastUpdateFailure.Builder> lastUpdateFailure) {
            return lastUpdateFailure(LastUpdateFailure.builder().applyMutation(lastUpdateFailure).build());
        }

        /**
         * <p>
         * The unique ID for the <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request.
         * </p>
         * 
         * @param lastUpdateRequestId
         *        The unique ID for the <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateRequestId(String lastUpdateRequestId);

        /**
         * <p>
         * The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
         * requested.
         * </p>
         * 
         * @param lastUpdateStatus
         *        The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
         *        requested.
         * @see SettingsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingsStatus
         */
        Builder lastUpdateStatus(String lastUpdateStatus);

        /**
         * <p>
         * The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
         * requested.
         * </p>
         * 
         * @param lastUpdateStatus
         *        The status of the last <code>UpdateDatalake</code> or <code>DeleteDatalake</code> API request that was
         *        requested.
         * @see SettingsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingsStatus
         */
        Builder lastUpdateStatus(SettingsStatus lastUpdateStatus);
    }

    static final class BuilderImpl implements Builder {
        private LastUpdateFailure lastUpdateFailure;

        private String lastUpdateRequestId;

        private String lastUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStatus model) {
            lastUpdateFailure(model.lastUpdateFailure);
            lastUpdateRequestId(model.lastUpdateRequestId);
            lastUpdateStatus(model.lastUpdateStatus);
        }

        public final LastUpdateFailure.Builder getLastUpdateFailure() {
            return lastUpdateFailure != null ? lastUpdateFailure.toBuilder() : null;
        }

        public final void setLastUpdateFailure(LastUpdateFailure.BuilderImpl lastUpdateFailure) {
            this.lastUpdateFailure = lastUpdateFailure != null ? lastUpdateFailure.build() : null;
        }

        @Override
        public final Builder lastUpdateFailure(LastUpdateFailure lastUpdateFailure) {
            this.lastUpdateFailure = lastUpdateFailure;
            return this;
        }

        public final String getLastUpdateRequestId() {
            return lastUpdateRequestId;
        }

        public final void setLastUpdateRequestId(String lastUpdateRequestId) {
            this.lastUpdateRequestId = lastUpdateRequestId;
        }

        @Override
        public final Builder lastUpdateRequestId(String lastUpdateRequestId) {
            this.lastUpdateRequestId = lastUpdateRequestId;
            return this;
        }

        public final String getLastUpdateStatus() {
            return lastUpdateStatus;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(SettingsStatus lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        @Override
        public UpdateStatus build() {
            return new UpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
