/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriberResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<CreateSubscriberResponse.Builder, CreateSubscriberResponse> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(CreateSubscriberResponse::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareName").getter(getter(CreateSubscriberResponse::resourceShareName))
            .setter(setter(Builder::resourceShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateSubscriberResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketArn").getter(getter(CreateSubscriberResponse::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()).build();

    private static final SdkField<String> SNS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("snsArn")
            .getter(getter(CreateSubscriberResponse::snsArn)).setter(setter(Builder::snsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsArn").build()).build();

    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionId").getter(getter(CreateSubscriberResponse::subscriptionId))
            .setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            RESOURCE_SHARE_NAME_FIELD, ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, SNS_ARN_FIELD, SUBSCRIPTION_ID_FIELD));

    private final String resourceShareArn;

    private final String resourceShareName;

    private final String roleArn;

    private final String s3BucketArn;

    private final String snsArn;

    private final String subscriptionId;

    private CreateSubscriberResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceShareName = builder.resourceShareName;
        this.roleArn = builder.roleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.snsArn = builder.snsArn;
        this.subscriptionId = builder.subscriptionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM
     * resource share invitation, you can view details related to the RAM resource share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the
     *         RAM resource share invitation, you can view details related to the RAM resource share.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public final String resourceShareName() {
        return resourceShareName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and
     * how to use them in policies, see <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about
     *         ARNs and how to use them in policies, see <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon
     *         Security Lake User Guide</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN for the Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN for the Amazon S3 bucket.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * The ARN for the Amazon Simple Notification Service.
     * </p>
     * 
     * @return The ARN for the Amazon Simple Notification Service.
     */
    public final String snsArn() {
        return snsArn;
    }

    /**
     * <p>
     * The <code>subscriptionId</code> created by the <code>CreateSubscriber</code> API call.
     * </p>
     * 
     * @return The <code>subscriptionId</code> created by the <code>CreateSubscriber</code> API call.
     */
    public final String subscriptionId() {
        return subscriptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberResponse)) {
            return false;
        }
        CreateSubscriberResponse other = (CreateSubscriberResponse) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(resourceShareName(), other.resourceShareName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(s3BucketArn(), other.s3BucketArn()) && Objects.equals(snsArn(), other.snsArn())
                && Objects.equals(subscriptionId(), other.subscriptionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriberResponse").add("ResourceShareArn", resourceShareArn())
                .add("ResourceShareName", resourceShareName()).add("RoleArn", roleArn()).add("S3BucketArn", s3BucketArn())
                .add("SnsArn", snsArn()).add("SubscriptionId", subscriptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "resourceShareName":
            return Optional.ofNullable(clazz.cast(resourceShareName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "s3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "snsArn":
            return Optional.ofNullable(clazz.cast(snsArn()));
        case "subscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberResponse, T> g) {
        return obj -> g.apply((CreateSubscriberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriberResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM
         * resource share invitation, you can view details related to the RAM resource share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the
         *        RAM resource share invitation, you can view details related to the RAM resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param resourceShareName
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareName(String resourceShareName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs
         * and how to use them in policies, see <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security
         * Lake User Guide</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about
         *        ARNs and how to use them in policies, see <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon
         *        Security Lake User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN for the Amazon S3 bucket.
         * </p>
         * 
         * @param s3BucketArn
         *        The ARN for the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * The ARN for the Amazon Simple Notification Service.
         * </p>
         * 
         * @param snsArn
         *        The ARN for the Amazon Simple Notification Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsArn(String snsArn);

        /**
         * <p>
         * The <code>subscriptionId</code> created by the <code>CreateSubscriber</code> API call.
         * </p>
         * 
         * @param subscriptionId
         *        The <code>subscriptionId</code> created by the <code>CreateSubscriber</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionId(String subscriptionId);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private String resourceShareArn;

        private String resourceShareName;

        private String roleArn;

        private String s3BucketArn;

        private String snsArn;

        private String subscriptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberResponse model) {
            super(model);
            resourceShareArn(model.resourceShareArn);
            resourceShareName(model.resourceShareName);
            roleArn(model.roleArn);
            s3BucketArn(model.s3BucketArn);
            snsArn(model.snsArn);
            subscriptionId(model.subscriptionId);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getResourceShareName() {
            return resourceShareName;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        @Override
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsArn() {
            return snsArn;
        }

        public final void setSnsArn(String snsArn) {
            this.snsArn = snsArn;
        }

        @Override
        public final Builder snsArn(String snsArn) {
            this.snsArn = snsArn;
            return this;
        }

        public final String getSubscriptionId() {
            return subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Override
        public CreateSubscriberResponse build() {
            return new CreateSubscriberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
