/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a Security Lake exception
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeException implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeException.Builder, DataLakeException> {
    private static final SdkField<String> EXCEPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exception").getter(getter(DataLakeException::exception)).setter(setter(Builder::exception))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exception").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(DataLakeException::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> REMEDIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remediation").getter(getter(DataLakeException::remediation)).setter(setter(Builder::remediation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(DataLakeException::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_FIELD, REGION_FIELD,
            REMEDIATION_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exception;

    private final String region;

    private final String remediation;

    private final Instant timestamp;

    private DataLakeException(BuilderImpl builder) {
        this.exception = builder.exception;
        this.region = builder.region;
        this.remediation = builder.remediation;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The underlying exception of a Security Lake exception.
     * </p>
     * 
     * @return The underlying exception of a Security Lake exception.
     */
    public final String exception() {
        return exception;
    }

    /**
     * <p>
     * The Amazon Web Services Regions where the exception occurred.
     * </p>
     * 
     * @return The Amazon Web Services Regions where the exception occurred.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * List of all remediation steps for a Security Lake exception.
     * </p>
     * 
     * @return List of all remediation steps for a Security Lake exception.
     */
    public final String remediation() {
        return remediation;
    }

    /**
     * <p>
     * This error can occur if you configure the wrong timestamp format, or if the subset of entries used for validation
     * had errors or missing values.
     * </p>
     * 
     * @return This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
     *         validation had errors or missing values.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exception());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeException)) {
            return false;
        }
        DataLakeException other = (DataLakeException) obj;
        return Objects.equals(exception(), other.exception()) && Objects.equals(region(), other.region())
                && Objects.equals(remediation(), other.remediation()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeException").add("Exception", exception()).add("Region", region())
                .add("Remediation", remediation()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exception":
            return Optional.ofNullable(clazz.cast(exception()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeException, T> g) {
        return obj -> g.apply((DataLakeException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeException> {
        /**
         * <p>
         * The underlying exception of a Security Lake exception.
         * </p>
         * 
         * @param exception
         *        The underlying exception of a Security Lake exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exception(String exception);

        /**
         * <p>
         * The Amazon Web Services Regions where the exception occurred.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions where the exception occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * List of all remediation steps for a Security Lake exception.
         * </p>
         * 
         * @param remediation
         *        List of all remediation steps for a Security Lake exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(String remediation);

        /**
         * <p>
         * This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
         * validation had errors or missing values.
         * </p>
         * 
         * @param timestamp
         *        This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
         *        validation had errors or missing values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String exception;

        private String region;

        private String remediation;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeException model) {
            exception(model.exception);
            region(model.region);
            remediation(model.remediation);
            timestamp(model.timestamp);
        }

        public final String getException() {
            return exception;
        }

        public final void setException(String exception) {
            this.exception = exception;
        }

        @Override
        public final Builder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getRemediation() {
            return remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public DataLakeException build() {
            return new DataLakeException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
