/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.model.DataLakeException;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse;

public class ListDataLakeExceptionsPublisher
implements SdkPublisher<ListDataLakeExceptionsResponse> {
    private final SecurityLakeAsyncClient client;
    private final ListDataLakeExceptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataLakeExceptionsPublisher(SecurityLakeAsyncClient client, ListDataLakeExceptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataLakeExceptionsPublisher(SecurityLakeAsyncClient client, ListDataLakeExceptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataLakeExceptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataLakeExceptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataLakeException> exceptions() {
        Function<ListDataLakeExceptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exceptions() != null) {
                return response.exceptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataLakeExceptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataLakeExceptionsResponseFetcher
    implements AsyncPageFetcher<ListDataLakeExceptionsResponse> {
        private ListDataLakeExceptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeExceptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataLakeExceptionsResponse> nextPage(ListDataLakeExceptionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeExceptionsPublisher.this.client.listDataLakeExceptions(ListDataLakeExceptionsPublisher.this.firstRequest);
            }
            return ListDataLakeExceptionsPublisher.this.client.listDataLakeExceptions((ListDataLakeExceptionsRequest)((Object)ListDataLakeExceptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

