/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provide transition lifecycle details of Amazon Security Lake object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeLifecycleTransition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeLifecycleTransition.Builder, DataLakeLifecycleTransition> {
    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("days")
            .getter(getter(DataLakeLifecycleTransition::days)).setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("days").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageClass").getter(getter(DataLakeLifecycleTransition::storageClass))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD,
            STORAGE_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer days;

    private final String storageClass;

    private DataLakeLifecycleTransition(BuilderImpl builder) {
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
     * </p>
     * 
     * @return Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake
     *         object.
     */
    public final Integer days() {
        return days;
    }

    /**
     * <p>
     * The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements
     * of your workloads.
     * </p>
     * 
     * @return The range of storage classes that you can choose from based on the data access, resiliency, and cost
     *         requirements of your workloads.
     */
    public final String storageClass() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleTransition)) {
            return false;
        }
        DataLakeLifecycleTransition other = (DataLakeLifecycleTransition) obj;
        return Objects.equals(days(), other.days()) && Objects.equals(storageClass(), other.storageClass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeLifecycleTransition").add("Days", days()).add("StorageClass", storageClass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "days":
            return Optional.ofNullable(clazz.cast(days()));
        case "storageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeLifecycleTransition, T> g) {
        return obj -> g.apply((DataLakeLifecycleTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeLifecycleTransition> {
        /**
         * <p>
         * Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
         * </p>
         * 
         * @param days
         *        Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * <p>
         * The range of storage classes that you can choose from based on the data access, resiliency, and cost
         * requirements of your workloads.
         * </p>
         * 
         * @param storageClass
         *        The range of storage classes that you can choose from based on the data access, resiliency, and cost
         *        requirements of your workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(String storageClass);
    }

    static final class BuilderImpl implements Builder {
        private Integer days;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeLifecycleTransition model) {
            days(model.days);
            storageClass(model.storageClass);
        }

        public final Integer getDays() {
            return days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public DataLakeLifecycleTransition build() {
            return new DataLakeLifecycleTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
