/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriberRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateSubscriberRequest.Builder, CreateSubscriberRequest> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessTypes")
            .getter(getter(CreateSubscriberRequest::accessTypesAsStrings))
            .setter(setter(Builder::accessTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField
            .<List<LogSourceResource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(CreateSubscriberRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSourceResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSourceResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberDescription").getter(getter(CreateSubscriberRequest::subscriberDescription))
            .setter(setter(Builder::subscriberDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build())
            .build();

    private static final SdkField<AwsIdentity> SUBSCRIBER_IDENTITY_FIELD = SdkField
            .<AwsIdentity> builder(MarshallingType.SDK_POJO).memberName("subscriberIdentity")
            .getter(getter(CreateSubscriberRequest::subscriberIdentity)).setter(setter(Builder::subscriberIdentity))
            .constructor(AwsIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberIdentity").build())
            .build();

    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberName").getter(getter(CreateSubscriberRequest::subscriberName))
            .setter(setter(Builder::subscriberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateSubscriberRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD,
            SOURCES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_IDENTITY_FIELD, SUBSCRIBER_NAME_FIELD, TAGS_FIELD));

    private final List<String> accessTypes;

    private final List<LogSourceResource> sources;

    private final String subscriberDescription;

    private final AwsIdentity subscriberIdentity;

    private final String subscriberName;

    private final List<Tag> tags;

    private CreateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accessTypes = builder.accessTypes;
        this.sources = builder.sources;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberIdentity = builder.subscriberIdentity;
        this.subscriberName = builder.subscriberName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon S3 or Lake Formation access type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessTypes} method.
     * </p>
     * 
     * @return The Amazon S3 or Lake Formation access type.
     */
    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(accessTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessTypes() {
        return accessTypes != null && !(accessTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon S3 or Lake Formation access type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessTypes} method.
     * </p>
     * 
     * @return The Amazon S3 or Lake Formation access type.
     */
    public final List<String> accessTypesAsStrings() {
        return accessTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and event
     * collection for natively supported Amazon Web Services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
     *         and event collection for natively supported Amazon Web Services.
     */
    public final List<LogSourceResource> sources() {
        return sources;
    }

    /**
     * <p>
     * The description for your subscriber account in Security Lake.
     * </p>
     * 
     * @return The description for your subscriber account in Security Lake.
     */
    public final String subscriberDescription() {
        return subscriberDescription;
    }

    /**
     * <p>
     * The Amazon Web Services identity used to access your data.
     * </p>
     * 
     * @return The Amazon Web Services identity used to access your data.
     */
    public final AwsIdentity subscriberIdentity() {
        return subscriberIdentity;
    }

    /**
     * <p>
     * The name of your Security Lake subscriber account.
     * </p>
     * 
     * @return The name of your Security Lake subscriber account.
     */
    public final String subscriberName() {
        return subscriberName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a tag
     * key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify
     *         both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessTypes() ? accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest) obj;
        return hasAccessTypes() == other.hasAccessTypes() && Objects.equals(accessTypesAsStrings(), other.accessTypesAsStrings())
                && hasSources() == other.hasSources() && Objects.equals(sources(), other.sources())
                && Objects.equals(subscriberDescription(), other.subscriberDescription())
                && Objects.equals(subscriberIdentity(), other.subscriberIdentity())
                && Objects.equals(subscriberName(), other.subscriberName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriberRequest").add("AccessTypes", hasAccessTypes() ? accessTypesAsStrings() : null)
                .add("Sources", hasSources() ? sources() : null).add("SubscriberDescription", subscriberDescription())
                .add("SubscriberIdentity", subscriberIdentity()).add("SubscriberName", subscriberName())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessTypes":
            return Optional.ofNullable(clazz.cast(accessTypesAsStrings()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "subscriberDescription":
            return Optional.ofNullable(clazz.cast(subscriberDescription()));
        case "subscriberIdentity":
            return Optional.ofNullable(clazz.cast(subscriberIdentity()));
        case "subscriberName":
            return Optional.ofNullable(clazz.cast(subscriberName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberRequest, T> g) {
        return obj -> g.apply((CreateSubscriberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriberRequest> {
        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypesWithStrings(Collection<String> accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypesWithStrings(String... accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypes(Collection<AccessType> accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypes(AccessType... accessTypes);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * 
         * @param sources
         *        The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
         *        and event collection for natively supported Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<LogSourceResource> sources);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * 
         * @param sources
         *        The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
         *        and event collection for natively supported Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(LogSourceResource... sources);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<LogSourceResource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<LogSourceResource>)
         */
        Builder sources(Consumer<LogSourceResource.Builder>... sources);

        /**
         * <p>
         * The description for your subscriber account in Security Lake.
         * </p>
         * 
         * @param subscriberDescription
         *        The description for your subscriber account in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberDescription(String subscriberDescription);

        /**
         * <p>
         * The Amazon Web Services identity used to access your data.
         * </p>
         * 
         * @param subscriberIdentity
         *        The Amazon Web Services identity used to access your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberIdentity(AwsIdentity subscriberIdentity);

        /**
         * <p>
         * The Amazon Web Services identity used to access your data.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIdentity.Builder} avoiding the need to
         * create one manually via {@link AwsIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIdentity.Builder#build()} is called immediately and its result
         * is passed to {@link #subscriberIdentity(AwsIdentity)}.
         * 
         * @param subscriberIdentity
         *        a consumer that will call methods on {@link AwsIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriberIdentity(AwsIdentity)
         */
        default Builder subscriberIdentity(Consumer<AwsIdentity.Builder> subscriberIdentity) {
            return subscriberIdentity(AwsIdentity.builder().applyMutation(subscriberIdentity).build());
        }

        /**
         * <p>
         * The name of your Security Lake subscriber account.
         * </p>
         * 
         * @param subscriberName
         *        The name of your Security Lake subscriber account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberName(String subscriberName);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a
         * tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * 
         * @param tags
         *        An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify
         *        both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a
         * tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * 
         * @param tags
         *        An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify
         *        both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a
         * tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securitylake.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();

        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private String subscriberDescription;

        private AwsIdentity subscriberIdentity;

        private String subscriberName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberRequest model) {
            super(model);
            accessTypesWithStrings(model.accessTypes);
            sources(model.sources);
            subscriberDescription(model.subscriberDescription);
            subscriberIdentity(model.subscriberIdentity);
            subscriberName(model.subscriberName);
            tags(model.tags);
        }

        public final Collection<String> getAccessTypes() {
            if (accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String... accessTypes) {
            accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType... accessTypes) {
            accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> LogSourceResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final AwsIdentity.Builder getSubscriberIdentity() {
            return subscriberIdentity != null ? subscriberIdentity.toBuilder() : null;
        }

        public final void setSubscriberIdentity(AwsIdentity.BuilderImpl subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity != null ? subscriberIdentity.build() : null;
        }

        @Override
        public final Builder subscriberIdentity(AwsIdentity subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        public final String getSubscriberName() {
            return subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriberRequest build() {
            return new CreateSubscriberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
