/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request. This is set to
 * Completed after the configuration is updated, or removed if deletion of the data lake is successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeUpdateStatus.Builder, DataLakeUpdateStatus> {
    private static final SdkField<DataLakeUpdateException> EXCEPTION_FIELD = SdkField
            .<DataLakeUpdateException> builder(MarshallingType.SDK_POJO).memberName("exception")
            .getter(getter(DataLakeUpdateStatus::exception)).setter(setter(Builder::exception))
            .constructor(DataLakeUpdateException::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exception").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(DataLakeUpdateStatus::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataLakeUpdateStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataLakeUpdateException exception;

    private final String requestIdValue;

    private final String status;

    private DataLakeUpdateStatus(BuilderImpl builder) {
        this.exception = builder.exception;
        this.requestIdValue = builder.requestIdValue;
        this.status = builder.status;
    }

    /**
     * <p>
     * The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which failed.
     * </p>
     * 
     * @return The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which
     *         failed.
     */
    public final DataLakeUpdateException exception() {
        return exception;
    }

    /**
     * <p>
     * The unique ID for the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.
     * </p>
     * 
     * @return The unique ID for the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataLakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
     *         requested.
     * @see DataLakeStatus
     */
    public final DataLakeStatus status() {
        return DataLakeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataLakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
     *         requested.
     * @see DataLakeStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exception());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeUpdateStatus)) {
            return false;
        }
        DataLakeUpdateStatus other = (DataLakeUpdateStatus) obj;
        return Objects.equals(exception(), other.exception()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeUpdateStatus").add("Exception", exception()).add("RequestId", requestId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exception":
            return Optional.ofNullable(clazz.cast(exception()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exception", EXCEPTION_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeUpdateStatus, T> g) {
        return obj -> g.apply((DataLakeUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeUpdateStatus> {
        /**
         * <p>
         * The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which failed.
         * </p>
         * 
         * @param exception
         *        The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which
         *        failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exception(DataLakeUpdateException exception);

        /**
         * <p>
         * The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeUpdateException.Builder} avoiding
         * the need to create one manually via {@link DataLakeUpdateException#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeUpdateException.Builder#build()} is called immediately
         * and its result is passed to {@link #exception(DataLakeUpdateException)}.
         * 
         * @param exception
         *        a consumer that will call methods on {@link DataLakeUpdateException.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exception(DataLakeUpdateException)
         */
        default Builder exception(Consumer<DataLakeUpdateException.Builder> exception) {
            return exception(DataLakeUpdateException.builder().applyMutation(exception).build());
        }

        /**
         * <p>
         * The unique ID for the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.
         * </p>
         * 
         * @param requestIdValue
         *        The unique ID for the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
         * requested.
         * </p>
         * 
         * @param status
         *        The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
         *        requested.
         * @see DataLakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
         * requested.
         * </p>
         * 
         * @param status
         *        The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was
         *        requested.
         * @see DataLakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeStatus
         */
        Builder status(DataLakeStatus status);
    }

    static final class BuilderImpl implements Builder {
        private DataLakeUpdateException exception;

        private String requestIdValue;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeUpdateStatus model) {
            exception(model.exception);
            requestId(model.requestIdValue);
            status(model.status);
        }

        public final DataLakeUpdateException.Builder getException() {
            return exception != null ? exception.toBuilder() : null;
        }

        public final void setException(DataLakeUpdateException.BuilderImpl exception) {
            this.exception = exception != null ? exception.build() : null;
        }

        @Override
        public final Builder exception(DataLakeUpdateException exception) {
            this.exception = exception;
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataLakeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataLakeUpdateStatus build() {
            return new DataLakeUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
