/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataLakeExceptionsResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<ListDataLakeExceptionsResponse.Builder, ListDataLakeExceptionsResponse> {
    private static final SdkField<List<DataLakeException>> EXCEPTIONS_FIELD = SdkField
            .<List<DataLakeException>> builder(MarshallingType.LIST)
            .memberName("exceptions")
            .getter(getter(ListDataLakeExceptionsResponse::exceptions))
            .setter(setter(Builder::exceptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeException> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataLakeExceptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataLakeException> exceptions;

    private final String nextToken;

    private ListDataLakeExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.exceptions = builder.exceptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exceptions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExceptions() {
        return exceptions != null && !(exceptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the failures that cannot be retried.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExceptions} method.
     * </p>
     * 
     * @return Lists the failures that cannot be retried.
     */
    public final List<DataLakeException> exceptions() {
        return exceptions;
    }

    /**
     * <p>
     * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
     * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400
     * InvalidToken error.
     * </p>
     * 
     * @return Lists if there are more results available. The value of nextToken is a unique pagination token for each
     *         page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged.</p>
     *         <p>
     *         Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400
     *         InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExceptions() ? exceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataLakeExceptionsResponse)) {
            return false;
        }
        ListDataLakeExceptionsResponse other = (ListDataLakeExceptionsResponse) obj;
        return hasExceptions() == other.hasExceptions() && Objects.equals(exceptions(), other.exceptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataLakeExceptionsResponse").add("Exceptions", hasExceptions() ? exceptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exceptions":
            return Optional.ofNullable(clazz.cast(exceptions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exceptions", EXCEPTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataLakeExceptionsResponse, T> g) {
        return obj -> g.apply((ListDataLakeExceptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataLakeExceptionsResponse> {
        /**
         * <p>
         * Lists the failures that cannot be retried.
         * </p>
         * 
         * @param exceptions
         *        Lists the failures that cannot be retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(Collection<DataLakeException> exceptions);

        /**
         * <p>
         * Lists the failures that cannot be retried.
         * </p>
         * 
         * @param exceptions
         *        Lists the failures that cannot be retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(DataLakeException... exceptions);

        /**
         * <p>
         * Lists the failures that cannot be retried.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeException.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeException#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeException.Builder#build()} is called
         * immediately and its result is passed to {@link #exceptions(List<DataLakeException>)}.
         * 
         * @param exceptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.DataLakeException.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exceptions(java.util.Collection<DataLakeException>)
         */
        Builder exceptions(Consumer<DataLakeException.Builder>... exceptions);

        /**
         * <p>
         * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
         * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400
         * InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        Lists if there are more results available. The value of nextToken is a unique pagination token for
         *        each page. Repeat the call using the returned token to retrieve the next page. Keep all other
         *        arguments unchanged.</p>
         *        <p>
         *        Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP
         *        400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private List<DataLakeException> exceptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataLakeExceptionsResponse model) {
            super(model);
            exceptions(model.exceptions);
            nextToken(model.nextToken);
        }

        public final List<DataLakeException.Builder> getExceptions() {
            List<DataLakeException.Builder> result = DataLakeExceptionListCopier.copyToBuilder(this.exceptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExceptions(Collection<DataLakeException.BuilderImpl> exceptions) {
            this.exceptions = DataLakeExceptionListCopier.copyFromBuilder(exceptions);
        }

        @Override
        public final Builder exceptions(Collection<DataLakeException> exceptions) {
            this.exceptions = DataLakeExceptionListCopier.copy(exceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(DataLakeException... exceptions) {
            exceptions(Arrays.asList(exceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(Consumer<DataLakeException.Builder>... exceptions) {
            exceptions(Stream.of(exceptions).map(c -> DataLakeException.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataLakeExceptionsResponse build() {
            return new ListDataLakeExceptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
