/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify the configurations you want to use for subscriber notification to notify the subscriber when new data is
 * written to the data lake for sources that the subscriber consumes in Security Lake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<HttpsNotificationConfiguration> HTTPS_NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<HttpsNotificationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("httpsNotificationConfiguration")
            .getter(getter(NotificationConfiguration::httpsNotificationConfiguration))
            .setter(setter(Builder::httpsNotificationConfiguration))
            .constructor(HttpsNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsNotificationConfiguration")
                    .build()).build();

    private static final SdkField<SqsNotificationConfiguration> SQS_NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<SqsNotificationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("sqsNotificationConfiguration")
            .getter(getter(NotificationConfiguration::sqsNotificationConfiguration))
            .setter(setter(Builder::sqsNotificationConfiguration))
            .constructor(SqsNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsNotificationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HTTPS_NOTIFICATION_CONFIGURATION_FIELD, SQS_NOTIFICATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HttpsNotificationConfiguration httpsNotificationConfiguration;

    private final SqsNotificationConfiguration sqsNotificationConfiguration;

    private final Type type;

    private NotificationConfiguration(BuilderImpl builder) {
        this.httpsNotificationConfiguration = builder.httpsNotificationConfiguration;
        this.sqsNotificationConfiguration = builder.sqsNotificationConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configurations used for HTTPS subscriber notification.
     * </p>
     * 
     * @return The configurations used for HTTPS subscriber notification.
     */
    public final HttpsNotificationConfiguration httpsNotificationConfiguration() {
        return httpsNotificationConfiguration;
    }

    /**
     * <p>
     * The configurations for SQS subscriber notification.
     * </p>
     * 
     * @return The configurations for SQS subscriber notification.
     */
    public final SqsNotificationConfiguration sqsNotificationConfiguration() {
        return sqsNotificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpsNotificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sqsNotificationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(httpsNotificationConfiguration(), other.httpsNotificationConfiguration())
                && Objects.equals(sqsNotificationConfiguration(), other.sqsNotificationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration")
                .add("HttpsNotificationConfiguration", httpsNotificationConfiguration())
                .add("SqsNotificationConfiguration", sqsNotificationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpsNotificationConfiguration":
            return Optional.ofNullable(clazz.cast(httpsNotificationConfiguration()));
        case "sqsNotificationConfiguration":
            return Optional.ofNullable(clazz.cast(sqsNotificationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #httpsNotificationConfiguration()} initialized to the given value.
     *
     * <p>
     * The configurations used for HTTPS subscriber notification.
     * </p>
     * 
     * @param httpsNotificationConfiguration
     *        The configurations used for HTTPS subscriber notification.
     */
    public static NotificationConfiguration fromHttpsNotificationConfiguration(
            HttpsNotificationConfiguration httpsNotificationConfiguration) {
        return builder().httpsNotificationConfiguration(httpsNotificationConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #httpsNotificationConfiguration()} initialized to the given value.
     *
     * <p>
     * The configurations used for HTTPS subscriber notification.
     * </p>
     * 
     * @param httpsNotificationConfiguration
     *        The configurations used for HTTPS subscriber notification.
     */
    public static NotificationConfiguration fromHttpsNotificationConfiguration(
            Consumer<HttpsNotificationConfiguration.Builder> httpsNotificationConfiguration) {
        HttpsNotificationConfiguration.Builder builder = HttpsNotificationConfiguration.builder();
        httpsNotificationConfiguration.accept(builder);
        return fromHttpsNotificationConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sqsNotificationConfiguration()} initialized to the given value.
     *
     * <p>
     * The configurations for SQS subscriber notification.
     * </p>
     * 
     * @param sqsNotificationConfiguration
     *        The configurations for SQS subscriber notification.
     */
    public static NotificationConfiguration fromSqsNotificationConfiguration(
            SqsNotificationConfiguration sqsNotificationConfiguration) {
        return builder().sqsNotificationConfiguration(sqsNotificationConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #sqsNotificationConfiguration()} initialized to the given value.
     *
     * <p>
     * The configurations for SQS subscriber notification.
     * </p>
     * 
     * @param sqsNotificationConfiguration
     *        The configurations for SQS subscriber notification.
     */
    public static NotificationConfiguration fromSqsNotificationConfiguration(
            Consumer<SqsNotificationConfiguration.Builder> sqsNotificationConfiguration) {
        SqsNotificationConfiguration.Builder builder = SqsNotificationConfiguration.builder();
        sqsNotificationConfiguration.accept(builder);
        return fromSqsNotificationConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("httpsNotificationConfiguration", HTTPS_NOTIFICATION_CONFIGURATION_FIELD);
        map.put("sqsNotificationConfiguration", SQS_NOTIFICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * The configurations used for HTTPS subscriber notification.
         * </p>
         * 
         * @param httpsNotificationConfiguration
         *        The configurations used for HTTPS subscriber notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsNotificationConfiguration(HttpsNotificationConfiguration httpsNotificationConfiguration);

        /**
         * <p>
         * The configurations used for HTTPS subscriber notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpsNotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link HttpsNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpsNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #httpsNotificationConfiguration(HttpsNotificationConfiguration)}.
         * 
         * @param httpsNotificationConfiguration
         *        a consumer that will call methods on {@link HttpsNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpsNotificationConfiguration(HttpsNotificationConfiguration)
         */
        default Builder httpsNotificationConfiguration(
                Consumer<HttpsNotificationConfiguration.Builder> httpsNotificationConfiguration) {
            return httpsNotificationConfiguration(HttpsNotificationConfiguration.builder()
                    .applyMutation(httpsNotificationConfiguration).build());
        }

        /**
         * <p>
         * The configurations for SQS subscriber notification.
         * </p>
         * 
         * @param sqsNotificationConfiguration
         *        The configurations for SQS subscriber notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsNotificationConfiguration(SqsNotificationConfiguration sqsNotificationConfiguration);

        /**
         * <p>
         * The configurations for SQS subscriber notification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsNotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link SqsNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sqsNotificationConfiguration(SqsNotificationConfiguration)}.
         * 
         * @param sqsNotificationConfiguration
         *        a consumer that will call methods on {@link SqsNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsNotificationConfiguration(SqsNotificationConfiguration)
         */
        default Builder sqsNotificationConfiguration(Consumer<SqsNotificationConfiguration.Builder> sqsNotificationConfiguration) {
            return sqsNotificationConfiguration(SqsNotificationConfiguration.builder()
                    .applyMutation(sqsNotificationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpsNotificationConfiguration httpsNotificationConfiguration;

        private SqsNotificationConfiguration sqsNotificationConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            httpsNotificationConfiguration(model.httpsNotificationConfiguration);
            sqsNotificationConfiguration(model.sqsNotificationConfiguration);
        }

        public final HttpsNotificationConfiguration.Builder getHttpsNotificationConfiguration() {
            return httpsNotificationConfiguration != null ? httpsNotificationConfiguration.toBuilder() : null;
        }

        public final void setHttpsNotificationConfiguration(
                HttpsNotificationConfiguration.BuilderImpl httpsNotificationConfiguration) {
            Object oldValue = this.httpsNotificationConfiguration;
            this.httpsNotificationConfiguration = httpsNotificationConfiguration != null ? httpsNotificationConfiguration.build()
                    : null;
            handleUnionValueChange(Type.HTTPS_NOTIFICATION_CONFIGURATION, oldValue, this.httpsNotificationConfiguration);
        }

        @Override
        public final Builder httpsNotificationConfiguration(HttpsNotificationConfiguration httpsNotificationConfiguration) {
            Object oldValue = this.httpsNotificationConfiguration;
            this.httpsNotificationConfiguration = httpsNotificationConfiguration;
            handleUnionValueChange(Type.HTTPS_NOTIFICATION_CONFIGURATION, oldValue, this.httpsNotificationConfiguration);
            return this;
        }

        public final SqsNotificationConfiguration.Builder getSqsNotificationConfiguration() {
            return sqsNotificationConfiguration != null ? sqsNotificationConfiguration.toBuilder() : null;
        }

        public final void setSqsNotificationConfiguration(SqsNotificationConfiguration.BuilderImpl sqsNotificationConfiguration) {
            Object oldValue = this.sqsNotificationConfiguration;
            this.sqsNotificationConfiguration = sqsNotificationConfiguration != null ? sqsNotificationConfiguration.build()
                    : null;
            handleUnionValueChange(Type.SQS_NOTIFICATION_CONFIGURATION, oldValue, this.sqsNotificationConfiguration);
        }

        @Override
        public final Builder sqsNotificationConfiguration(SqsNotificationConfiguration sqsNotificationConfiguration) {
            Object oldValue = this.sqsNotificationConfiguration;
            this.sqsNotificationConfiguration = sqsNotificationConfiguration;
            handleUnionValueChange(Type.SQS_NOTIFICATION_CONFIGURATION, oldValue, this.sqsNotificationConfiguration);
            return this;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NotificationConfiguration#type()
     */
    public enum Type {
        HTTPS_NOTIFICATION_CONFIGURATION,

        SQS_NOTIFICATION_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
