/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomLogSourceResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<CreateCustomLogSourceResponse.Builder, CreateCustomLogSourceResponse> {
    private static final SdkField<CustomLogSourceResource> SOURCE_FIELD = SdkField
            .<CustomLogSourceResource> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(CreateCustomLogSourceResponse::source)).setter(setter(Builder::source))
            .constructor(CustomLogSourceResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CustomLogSourceResource source;

    private CreateCustomLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
    }

    /**
     * <p>
     * The third-party custom source that was created.
     * </p>
     * 
     * @return The third-party custom source that was created.
     */
    public final CustomLogSourceResource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceResponse)) {
            return false;
        }
        CreateCustomLogSourceResponse other = (CreateCustomLogSourceResponse) obj;
        return Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomLogSourceResponse").add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceResponse, T> g) {
        return obj -> g.apply((CreateCustomLogSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomLogSourceResponse> {
        /**
         * <p>
         * The third-party custom source that was created.
         * </p>
         * 
         * @param source
         *        The third-party custom source that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CustomLogSourceResource source);

        /**
         * <p>
         * The third-party custom source that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLogSourceResource.Builder} avoiding
         * the need to create one manually via {@link CustomLogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceResource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(CustomLogSourceResource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CustomLogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CustomLogSourceResource)
         */
        default Builder source(Consumer<CustomLogSourceResource.Builder> source) {
            return source(CustomLogSourceResource.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private CustomLogSourceResource source;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceResponse model) {
            super(model);
            source(model.source);
        }

        public final CustomLogSourceResource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(CustomLogSourceResource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(CustomLogSourceResource source) {
            this.source = source;
            return this;
        }

        @Override
        public CreateCustomLogSourceResponse build() {
            return new CreateCustomLogSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
