/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration used for the Glue Crawler for a third-party custom source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLogSourceCrawlerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLogSourceCrawlerConfiguration.Builder, CustomLogSourceCrawlerConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CustomLogSourceCrawlerConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private CustomLogSourceCrawlerConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be used by the Glue crawler.
     * The recommended IAM policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed policy <code>AWSGlueServiceRole</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom policy granting access to your Amazon S3 Data Lake
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be used by the Glue
     *         crawler. The recommended IAM policies are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed policy <code>AWSGlueServiceRole</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom policy granting access to your Amazon S3 Data Lake
     *         </p>
     *         </li>
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLogSourceCrawlerConfiguration)) {
            return false;
        }
        CustomLogSourceCrawlerConfiguration other = (CustomLogSourceCrawlerConfiguration) obj;
        return Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLogSourceCrawlerConfiguration").add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLogSourceCrawlerConfiguration, T> g) {
        return obj -> g.apply((CustomLogSourceCrawlerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLogSourceCrawlerConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be used by the Glue
         * crawler. The recommended IAM policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed policy <code>AWSGlueServiceRole</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom policy granting access to your Amazon S3 Data Lake
         * </p>
         * </li>
         * </ul>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be used by the Glue
         *        crawler. The recommended IAM policies are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed policy <code>AWSGlueServiceRole</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom policy granting access to your Amazon S3 Data Lake
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLogSourceCrawlerConfiguration model) {
            roleArn(model.roleArn);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public CustomLogSourceCrawlerConfiguration build() {
            return new CustomLogSourceCrawlerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
