/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriberRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<UpdateSubscriberRequest.Builder, UpdateSubscriberRequest> {
    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField
            .<List<LogSourceResource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(UpdateSubscriberRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSourceResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSourceResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberDescription").getter(getter(UpdateSubscriberRequest::subscriberDescription))
            .setter(setter(Builder::subscriberDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build())
            .build();

    private static final SdkField<String> SUBSCRIBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberId").getter(getter(UpdateSubscriberRequest::subscriberId))
            .setter(setter(Builder::subscriberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("subscriberId").build()).build();

    private static final SdkField<AwsIdentity> SUBSCRIBER_IDENTITY_FIELD = SdkField
            .<AwsIdentity> builder(MarshallingType.SDK_POJO).memberName("subscriberIdentity")
            .getter(getter(UpdateSubscriberRequest::subscriberIdentity)).setter(setter(Builder::subscriberIdentity))
            .constructor(AwsIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberIdentity").build())
            .build();

    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberName").getter(getter(UpdateSubscriberRequest::subscriberName))
            .setter(setter(Builder::subscriberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD,
            SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_ID_FIELD, SUBSCRIBER_IDENTITY_FIELD, SUBSCRIBER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LogSourceResource> sources;

    private final String subscriberDescription;

    private final String subscriberId;

    private final AwsIdentity subscriberIdentity;

    private final String subscriberName;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.sources = builder.sources;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberId = builder.subscriberId;
        this.subscriberIdentity = builder.subscriberIdentity;
        this.subscriberName = builder.subscriberName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported Amazon Web Services services from which logs and events are collected. For the list of supported
     * Amazon Web Services services, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User
     * Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The supported Amazon Web Services services from which logs and events are collected. For the list of
     *         supported Amazon Web Services services, see the <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security
     *         Lake User Guide</a>.
     */
    public final List<LogSourceResource> sources() {
        return sources;
    }

    /**
     * <p>
     * The description of the Security Lake account subscriber.
     * </p>
     * 
     * @return The description of the Security Lake account subscriber.
     */
    public final String subscriberDescription() {
        return subscriberDescription;
    }

    /**
     * <p>
     * A value created by Security Lake that uniquely identifies your subscription.
     * </p>
     * 
     * @return A value created by Security Lake that uniquely identifies your subscription.
     */
    public final String subscriberId() {
        return subscriberId;
    }

    /**
     * <p>
     * The Amazon Web Services identity used to access your data.
     * </p>
     * 
     * @return The Amazon Web Services identity used to access your data.
     */
    public final AwsIdentity subscriberIdentity() {
        return subscriberIdentity;
    }

    /**
     * <p>
     * The name of the Security Lake account subscriber.
     * </p>
     * 
     * @return The name of the Security Lake account subscriber.
     */
    public final String subscriberName() {
        return subscriberName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest) obj;
        return hasSources() == other.hasSources() && Objects.equals(sources(), other.sources())
                && Objects.equals(subscriberDescription(), other.subscriberDescription())
                && Objects.equals(subscriberId(), other.subscriberId())
                && Objects.equals(subscriberIdentity(), other.subscriberIdentity())
                && Objects.equals(subscriberName(), other.subscriberName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriberRequest").add("Sources", hasSources() ? sources() : null)
                .add("SubscriberDescription", subscriberDescription()).add("SubscriberId", subscriberId())
                .add("SubscriberIdentity", subscriberIdentity()).add("SubscriberName", subscriberName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "subscriberDescription":
            return Optional.ofNullable(clazz.cast(subscriberDescription()));
        case "subscriberId":
            return Optional.ofNullable(clazz.cast(subscriberId()));
        case "subscriberIdentity":
            return Optional.ofNullable(clazz.cast(subscriberIdentity()));
        case "subscriberName":
            return Optional.ofNullable(clazz.cast(subscriberName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sources", SOURCES_FIELD);
        map.put("subscriberDescription", SUBSCRIBER_DESCRIPTION_FIELD);
        map.put("subscriberId", SUBSCRIBER_ID_FIELD);
        map.put("subscriberIdentity", SUBSCRIBER_IDENTITY_FIELD);
        map.put("subscriberName", SUBSCRIBER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberRequest, T> g) {
        return obj -> g.apply((UpdateSubscriberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSubscriberRequest> {
        /**
         * <p>
         * The supported Amazon Web Services services from which logs and events are collected. For the list of
         * supported Amazon Web Services services, see the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake
         * User Guide</a>.
         * </p>
         * 
         * @param sources
         *        The supported Amazon Web Services services from which logs and events are collected. For the list of
         *        supported Amazon Web Services services, see the <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon
         *        Security Lake User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<LogSourceResource> sources);

        /**
         * <p>
         * The supported Amazon Web Services services from which logs and events are collected. For the list of
         * supported Amazon Web Services services, see the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake
         * User Guide</a>.
         * </p>
         * 
         * @param sources
         *        The supported Amazon Web Services services from which logs and events are collected. For the list of
         *        supported Amazon Web Services services, see the <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon
         *        Security Lake User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(LogSourceResource... sources);

        /**
         * <p>
         * The supported Amazon Web Services services from which logs and events are collected. For the list of
         * supported Amazon Web Services services, see the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake
         * User Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<LogSourceResource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<LogSourceResource>)
         */
        Builder sources(Consumer<LogSourceResource.Builder>... sources);

        /**
         * <p>
         * The description of the Security Lake account subscriber.
         * </p>
         * 
         * @param subscriberDescription
         *        The description of the Security Lake account subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberDescription(String subscriberDescription);

        /**
         * <p>
         * A value created by Security Lake that uniquely identifies your subscription.
         * </p>
         * 
         * @param subscriberId
         *        A value created by Security Lake that uniquely identifies your subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberId(String subscriberId);

        /**
         * <p>
         * The Amazon Web Services identity used to access your data.
         * </p>
         * 
         * @param subscriberIdentity
         *        The Amazon Web Services identity used to access your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberIdentity(AwsIdentity subscriberIdentity);

        /**
         * <p>
         * The Amazon Web Services identity used to access your data.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIdentity.Builder} avoiding the need to
         * create one manually via {@link AwsIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIdentity.Builder#build()} is called immediately and its result
         * is passed to {@link #subscriberIdentity(AwsIdentity)}.
         * 
         * @param subscriberIdentity
         *        a consumer that will call methods on {@link AwsIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriberIdentity(AwsIdentity)
         */
        default Builder subscriberIdentity(Consumer<AwsIdentity.Builder> subscriberIdentity) {
            return subscriberIdentity(AwsIdentity.builder().applyMutation(subscriberIdentity).build());
        }

        /**
         * <p>
         * The name of the Security Lake account subscriber.
         * </p>
         * 
         * @param subscriberName
         *        The name of the Security Lake account subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberName(String subscriberName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private String subscriberDescription;

        private String subscriberId;

        private AwsIdentity subscriberIdentity;

        private String subscriberName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            super(model);
            sources(model.sources);
            subscriberDescription(model.subscriberDescription);
            subscriberId(model.subscriberId);
            subscriberIdentity(model.subscriberIdentity);
            subscriberName(model.subscriberName);
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> LogSourceResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberId() {
            return subscriberId;
        }

        public final void setSubscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
        }

        @Override
        public final Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public final AwsIdentity.Builder getSubscriberIdentity() {
            return subscriberIdentity != null ? subscriberIdentity.toBuilder() : null;
        }

        public final void setSubscriberIdentity(AwsIdentity.BuilderImpl subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity != null ? subscriberIdentity.build() : null;
        }

        @Override
        public final Builder subscriberIdentity(AwsIdentity subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        public final String getSubscriberName() {
            return subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
