/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Security Lake can collect logs and events from natively-supported Amazon Web Services services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLogSourceResource implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLogSourceResource.Builder, AwsLogSourceResource> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(AwsLogSourceResource::sourceNameAsString))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(AwsLogSourceResource::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD,
            SOURCE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceName;

    private final String sourceVersion;

    private AwsLogSourceResource(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * <p>
     * The name for a Amazon Web Services source. This must be a Regionally unique value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceName} will
     * return {@link AwsLogSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceNameAsString}.
     * </p>
     * 
     * @return The name for a Amazon Web Services source. This must be a Regionally unique value.
     * @see AwsLogSourceName
     */
    public final AwsLogSourceName sourceName() {
        return AwsLogSourceName.fromValue(sourceName);
    }

    /**
     * <p>
     * The name for a Amazon Web Services source. This must be a Regionally unique value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceName} will
     * return {@link AwsLogSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceNameAsString}.
     * </p>
     * 
     * @return The name for a Amazon Web Services source. This must be a Regionally unique value.
     * @see AwsLogSourceName
     */
    public final String sourceNameAsString() {
        return sourceName;
    }

    /**
     * <p>
     * The version for a Amazon Web Services source. This must be a Regionally unique value.
     * </p>
     * 
     * @return The version for a Amazon Web Services source. This must be a Regionally unique value.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLogSourceResource)) {
            return false;
        }
        AwsLogSourceResource other = (AwsLogSourceResource) obj;
        return Objects.equals(sourceNameAsString(), other.sourceNameAsString())
                && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLogSourceResource").add("SourceName", sourceNameAsString())
                .add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceNameAsString()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLogSourceResource, T> g) {
        return obj -> g.apply((AwsLogSourceResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLogSourceResource> {
        /**
         * <p>
         * The name for a Amazon Web Services source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceName
         *        The name for a Amazon Web Services source. This must be a Regionally unique value.
         * @see AwsLogSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceName
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The name for a Amazon Web Services source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceName
         *        The name for a Amazon Web Services source. This must be a Regionally unique value.
         * @see AwsLogSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceName
         */
        Builder sourceName(AwsLogSourceName sourceName);

        /**
         * <p>
         * The version for a Amazon Web Services source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceVersion
         *        The version for a Amazon Web Services source. This must be a Regionally unique value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);
    }

    static final class BuilderImpl implements Builder {
        private String sourceName;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLogSourceResource model) {
            sourceName(model.sourceName);
            sourceVersion(model.sourceVersion);
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public final Builder sourceName(AwsLogSourceName sourceName) {
            this.sourceName(sourceName == null ? null : sourceName.toString());
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public AwsLogSourceResource build() {
            return new AwsLogSourceResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
