/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Security Lake can collect logs and events from third-party custom sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLogSourceResource implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLogSourceResource.Builder, CustomLogSourceResource> {
    private static final SdkField<CustomLogSourceAttributes> ATTRIBUTES_FIELD = SdkField
            .<CustomLogSourceAttributes> builder(MarshallingType.SDK_POJO).memberName("attributes")
            .getter(getter(CustomLogSourceResource::attributes)).setter(setter(Builder::attributes))
            .constructor(CustomLogSourceAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<CustomLogSourceProvider> PROVIDER_FIELD = SdkField
            .<CustomLogSourceProvider> builder(MarshallingType.SDK_POJO).memberName("provider")
            .getter(getter(CustomLogSourceResource::provider)).setter(setter(Builder::provider))
            .constructor(CustomLogSourceProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(CustomLogSourceResource::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(CustomLogSourceResource::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            PROVIDER_FIELD, SOURCE_NAME_FIELD, SOURCE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomLogSourceAttributes attributes;

    private final CustomLogSourceProvider provider;

    private final String sourceName;

    private final String sourceVersion;

    private CustomLogSourceResource(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.provider = builder.provider;
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * <p>
     * The attributes of a third-party custom source.
     * </p>
     * 
     * @return The attributes of a third-party custom source.
     */
    public final CustomLogSourceAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * The details of the log provider for a third-party custom source.
     * </p>
     * 
     * @return The details of the log provider for a third-party custom source.
     */
    public final CustomLogSourceProvider provider() {
        return provider;
    }

    /**
     * <p>
     * The name for a third-party custom source. This must be a Regionally unique value.
     * </p>
     * 
     * @return The name for a third-party custom source. This must be a Regionally unique value.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The version for a third-party custom source. This must be a Regionally unique value.
     * </p>
     * 
     * @return The version for a third-party custom source. This must be a Regionally unique value.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLogSourceResource)) {
            return false;
        }
        CustomLogSourceResource other = (CustomLogSourceResource) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(provider(), other.provider())
                && Objects.equals(sourceName(), other.sourceName()) && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLogSourceResource").add("Attributes", attributes()).add("Provider", provider())
                .add("SourceName", sourceName()).add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLogSourceResource, T> g) {
        return obj -> g.apply((CustomLogSourceResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLogSourceResource> {
        /**
         * <p>
         * The attributes of a third-party custom source.
         * </p>
         * 
         * @param attributes
         *        The attributes of a third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(CustomLogSourceAttributes attributes);

        /**
         * <p>
         * The attributes of a third-party custom source.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLogSourceAttributes.Builder}
         * avoiding the need to create one manually via {@link CustomLogSourceAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(CustomLogSourceAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link CustomLogSourceAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(CustomLogSourceAttributes)
         */
        default Builder attributes(Consumer<CustomLogSourceAttributes.Builder> attributes) {
            return attributes(CustomLogSourceAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * The details of the log provider for a third-party custom source.
         * </p>
         * 
         * @param provider
         *        The details of the log provider for a third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(CustomLogSourceProvider provider);

        /**
         * <p>
         * The details of the log provider for a third-party custom source.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLogSourceProvider.Builder} avoiding
         * the need to create one manually via {@link CustomLogSourceProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #provider(CustomLogSourceProvider)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link CustomLogSourceProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(CustomLogSourceProvider)
         */
        default Builder provider(Consumer<CustomLogSourceProvider.Builder> provider) {
            return provider(CustomLogSourceProvider.builder().applyMutation(provider).build());
        }

        /**
         * <p>
         * The name for a third-party custom source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceName
         *        The name for a third-party custom source. This must be a Regionally unique value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The version for a third-party custom source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceVersion
         *        The version for a third-party custom source. This must be a Regionally unique value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);
    }

    static final class BuilderImpl implements Builder {
        private CustomLogSourceAttributes attributes;

        private CustomLogSourceProvider provider;

        private String sourceName;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLogSourceResource model) {
            attributes(model.attributes);
            provider(model.provider);
            sourceName(model.sourceName);
            sourceVersion(model.sourceVersion);
        }

        public final CustomLogSourceAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(CustomLogSourceAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(CustomLogSourceAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final CustomLogSourceProvider.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        public final void setProvider(CustomLogSourceProvider.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public final Builder provider(CustomLogSourceProvider provider) {
            this.provider = provider;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public CustomLogSourceResource build() {
            return new CustomLogSourceResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
