/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataLakeOrganizationConfigurationRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<DeleteDataLakeOrganizationConfigurationRequest.Builder, DeleteDataLakeOrganizationConfigurationRequest> {
    private static final SdkField<List<DataLakeAutoEnableNewAccountConfiguration>> AUTO_ENABLE_NEW_ACCOUNT_FIELD = SdkField
            .<List<DataLakeAutoEnableNewAccountConfiguration>> builder(MarshallingType.LIST)
            .memberName("autoEnableNewAccount")
            .getter(getter(DeleteDataLakeOrganizationConfigurationRequest::autoEnableNewAccount))
            .setter(setter(Builder::autoEnableNewAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableNewAccount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeAutoEnableNewAccountConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeAutoEnableNewAccountConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTO_ENABLE_NEW_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataLakeAutoEnableNewAccountConfiguration> autoEnableNewAccount;

    private DeleteDataLakeOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableNewAccount = builder.autoEnableNewAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoEnableNewAccount property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoEnableNewAccount() {
        return autoEnableNewAccount != null && !(autoEnableNewAccount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoEnableNewAccount} method.
     * </p>
     * 
     * @return Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
     */
    public final List<DataLakeAutoEnableNewAccountConfiguration> autoEnableNewAccount() {
        return autoEnableNewAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoEnableNewAccount() ? autoEnableNewAccount() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataLakeOrganizationConfigurationRequest)) {
            return false;
        }
        DeleteDataLakeOrganizationConfigurationRequest other = (DeleteDataLakeOrganizationConfigurationRequest) obj;
        return hasAutoEnableNewAccount() == other.hasAutoEnableNewAccount()
                && Objects.equals(autoEnableNewAccount(), other.autoEnableNewAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataLakeOrganizationConfigurationRequest")
                .add("AutoEnableNewAccount", hasAutoEnableNewAccount() ? autoEnableNewAccount() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoEnableNewAccount":
            return Optional.ofNullable(clazz.cast(autoEnableNewAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoEnableNewAccount", AUTO_ENABLE_NEW_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataLakeOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteDataLakeOrganizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDataLakeOrganizationConfigurationRequest> {
        /**
         * <p>
         * Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
         * </p>
         * 
         * @param autoEnableNewAccount
         *        Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableNewAccount(Collection<DataLakeAutoEnableNewAccountConfiguration> autoEnableNewAccount);

        /**
         * <p>
         * Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
         * </p>
         * 
         * @param autoEnableNewAccount
         *        Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableNewAccount(DataLakeAutoEnableNewAccountConfiguration... autoEnableNewAccount);

        /**
         * <p>
         * Turns off automatic enablement of Security Lake for member accounts that are added to an organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #autoEnableNewAccount(List<DataLakeAutoEnableNewAccountConfiguration>)}.
         * 
         * @param autoEnableNewAccount
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoEnableNewAccount(java.util.Collection<DataLakeAutoEnableNewAccountConfiguration>)
         */
        Builder autoEnableNewAccount(Consumer<DataLakeAutoEnableNewAccountConfiguration.Builder>... autoEnableNewAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<DataLakeAutoEnableNewAccountConfiguration> autoEnableNewAccount = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataLakeOrganizationConfigurationRequest model) {
            super(model);
            autoEnableNewAccount(model.autoEnableNewAccount);
        }

        public final List<DataLakeAutoEnableNewAccountConfiguration.Builder> getAutoEnableNewAccount() {
            List<DataLakeAutoEnableNewAccountConfiguration.Builder> result = DataLakeAutoEnableNewAccountConfigurationListCopier
                    .copyToBuilder(this.autoEnableNewAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoEnableNewAccount(
                Collection<DataLakeAutoEnableNewAccountConfiguration.BuilderImpl> autoEnableNewAccount) {
            this.autoEnableNewAccount = DataLakeAutoEnableNewAccountConfigurationListCopier.copyFromBuilder(autoEnableNewAccount);
        }

        @Override
        public final Builder autoEnableNewAccount(Collection<DataLakeAutoEnableNewAccountConfiguration> autoEnableNewAccount) {
            this.autoEnableNewAccount = DataLakeAutoEnableNewAccountConfigurationListCopier.copy(autoEnableNewAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoEnableNewAccount(DataLakeAutoEnableNewAccountConfiguration... autoEnableNewAccount) {
            autoEnableNewAccount(Arrays.asList(autoEnableNewAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoEnableNewAccount(
                Consumer<DataLakeAutoEnableNewAccountConfiguration.Builder>... autoEnableNewAccount) {
            autoEnableNewAccount(Stream.of(autoEnableNewAccount)
                    .map(c -> DataLakeAutoEnableNewAccountConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataLakeOrganizationConfigurationRequest build() {
            return new DeleteDataLakeOrganizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
