/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations used for HTTPS subscriber notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpsNotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpsNotificationConfiguration.Builder, HttpsNotificationConfiguration> {
    private static final SdkField<String> AUTHORIZATION_API_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationApiKeyName").getter(getter(HttpsNotificationConfiguration::authorizationApiKeyName))
            .setter(setter(Builder::authorizationApiKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationApiKeyName").build())
            .build();

    private static final SdkField<String> AUTHORIZATION_API_KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationApiKeyValue").getter(getter(HttpsNotificationConfiguration::authorizationApiKeyValue))
            .setter(setter(Builder::authorizationApiKeyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationApiKeyValue").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(HttpsNotificationConfiguration::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(HttpsNotificationConfiguration::httpMethodAsString))
            .setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()).build();

    private static final SdkField<String> TARGET_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRoleArn").getter(getter(HttpsNotificationConfiguration::targetRoleArn))
            .setter(setter(Builder::targetRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZATION_API_KEY_NAME_FIELD, AUTHORIZATION_API_KEY_VALUE_FIELD, ENDPOINT_FIELD, HTTP_METHOD_FIELD,
            TARGET_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizationApiKeyName;

    private final String authorizationApiKeyValue;

    private final String endpoint;

    private final String httpMethod;

    private final String targetRoleArn;

    private HttpsNotificationConfiguration(BuilderImpl builder) {
        this.authorizationApiKeyName = builder.authorizationApiKeyName;
        this.authorizationApiKeyValue = builder.authorizationApiKeyValue;
        this.endpoint = builder.endpoint;
        this.httpMethod = builder.httpMethod;
        this.targetRoleArn = builder.targetRoleArn;
    }

    /**
     * <p>
     * The key name for the notification subscription.
     * </p>
     * 
     * @return The key name for the notification subscription.
     */
    public final String authorizationApiKeyName() {
        return authorizationApiKeyName;
    }

    /**
     * <p>
     * The key value for the notification subscription.
     * </p>
     * 
     * @return The key value for the notification subscription.
     */
    public final String authorizationApiKeyValue() {
        return authorizationApiKeyValue;
    }

    /**
     * <p>
     * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this
     * field.
     * </p>
     * 
     * @return The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate
     *         this field.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The HTTPS method used for the notification subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The HTTPS method used for the notification subscription.
     * @see HttpMethod
     */
    public final HttpMethod httpMethod() {
        return HttpMethod.fromValue(httpMethod);
    }

    /**
     * <p>
     * The HTTPS method used for the notification subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The HTTPS method used for the notification subscription.
     * @see HttpMethod
     */
    public final String httpMethodAsString() {
        return httpMethod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more
     * information about ARNs and how to use them in policies, see <a
     * href="https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html">Managing data
     * access</a> and <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html">Amazon Web Services
     * Managed Policies</a> in the <i>Amazon Security Lake User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more
     *         information about ARNs and how to use them in policies, see <a
     *         href="https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html">Managing
     *         data access</a> and <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html">Amazon Web
     *         Services Managed Policies</a> in the <i>Amazon Security Lake User Guide</i>.
     */
    public final String targetRoleArn() {
        return targetRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationApiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationApiKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpsNotificationConfiguration)) {
            return false;
        }
        HttpsNotificationConfiguration other = (HttpsNotificationConfiguration) obj;
        return Objects.equals(authorizationApiKeyName(), other.authorizationApiKeyName())
                && Objects.equals(authorizationApiKeyValue(), other.authorizationApiKeyValue())
                && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(httpMethodAsString(), other.httpMethodAsString())
                && Objects.equals(targetRoleArn(), other.targetRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpsNotificationConfiguration").add("AuthorizationApiKeyName", authorizationApiKeyName())
                .add("AuthorizationApiKeyValue", authorizationApiKeyValue()).add("Endpoint", endpoint())
                .add("HttpMethod", httpMethodAsString()).add("TargetRoleArn", targetRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationApiKeyName":
            return Optional.ofNullable(clazz.cast(authorizationApiKeyName()));
        case "authorizationApiKeyValue":
            return Optional.ofNullable(clazz.cast(authorizationApiKeyValue()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethodAsString()));
        case "targetRoleArn":
            return Optional.ofNullable(clazz.cast(targetRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizationApiKeyName", AUTHORIZATION_API_KEY_NAME_FIELD);
        map.put("authorizationApiKeyValue", AUTHORIZATION_API_KEY_VALUE_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("httpMethod", HTTP_METHOD_FIELD);
        map.put("targetRoleArn", TARGET_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpsNotificationConfiguration, T> g) {
        return obj -> g.apply((HttpsNotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpsNotificationConfiguration> {
        /**
         * <p>
         * The key name for the notification subscription.
         * </p>
         * 
         * @param authorizationApiKeyName
         *        The key name for the notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationApiKeyName(String authorizationApiKeyName);

        /**
         * <p>
         * The key value for the notification subscription.
         * </p>
         * 
         * @param authorizationApiKeyValue
         *        The key value for the notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationApiKeyValue(String authorizationApiKeyValue);

        /**
         * <p>
         * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this
         * field.
         * </p>
         * 
         * @param endpoint
         *        The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint,
         *        populate this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The HTTPS method used for the notification subscription.
         * </p>
         * 
         * @param httpMethod
         *        The HTTPS method used for the notification subscription.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The HTTPS method used for the notification subscription.
         * </p>
         * 
         * @param httpMethod
         *        The HTTPS method used for the notification subscription.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder httpMethod(HttpMethod httpMethod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more
         * information about ARNs and how to use them in policies, see <a
         * href="https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html">Managing data
         * access</a> and <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html">Amazon Web
         * Services Managed Policies</a> in the <i>Amazon Security Lake User Guide</i>.
         * </p>
         * 
         * @param targetRoleArn
         *        The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more
         *        information about ARNs and how to use them in policies, see <a
         *        href="https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html"
         *        >Managing data access</a> and <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html">Amazon
         *        Web Services Managed Policies</a> in the <i>Amazon Security Lake User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRoleArn(String targetRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationApiKeyName;

        private String authorizationApiKeyValue;

        private String endpoint;

        private String httpMethod;

        private String targetRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpsNotificationConfiguration model) {
            authorizationApiKeyName(model.authorizationApiKeyName);
            authorizationApiKeyValue(model.authorizationApiKeyValue);
            endpoint(model.endpoint);
            httpMethod(model.httpMethod);
            targetRoleArn(model.targetRoleArn);
        }

        public final String getAuthorizationApiKeyName() {
            return authorizationApiKeyName;
        }

        public final void setAuthorizationApiKeyName(String authorizationApiKeyName) {
            this.authorizationApiKeyName = authorizationApiKeyName;
        }

        @Override
        public final Builder authorizationApiKeyName(String authorizationApiKeyName) {
            this.authorizationApiKeyName = authorizationApiKeyName;
            return this;
        }

        public final String getAuthorizationApiKeyValue() {
            return authorizationApiKeyValue;
        }

        public final void setAuthorizationApiKeyValue(String authorizationApiKeyValue) {
            this.authorizationApiKeyValue = authorizationApiKeyValue;
        }

        @Override
        public final Builder authorizationApiKeyValue(String authorizationApiKeyValue) {
            this.authorizationApiKeyValue = authorizationApiKeyValue;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public final Builder httpMethod(HttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final String getTargetRoleArn() {
            return targetRoleArn;
        }

        public final void setTargetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
        }

        @Override
        public final Builder targetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
            return this;
        }

        @Override
        public HttpsNotificationConfiguration build() {
            return new HttpsNotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
