/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * To add a natively-supported Amazon Web Services service as a log source, use these parameters to specify the
 * configuration settings for the log source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLogSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLogSourceConfiguration.Builder, AwsLogSourceConfiguration> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accounts")
            .getter(getter(AwsLogSourceConfiguration::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(AwsLogSourceConfiguration::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(AwsLogSourceConfiguration::sourceNameAsString))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(AwsLogSourceConfiguration::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, REGIONS_FIELD,
            SOURCE_NAME_FIELD, SOURCE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final List<String> regions;

    private final String sourceName;

    private final String sourceVersion;

    private AwsLogSourceConfiguration(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Amazon Web Services account information where you want to enable Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return Specify the Amazon Web Services account information where you want to enable Security Lake.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Regions where you want to enable Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Specify the Regions where you want to enable Security Lake.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The name for a Amazon Web Services source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceName} will
     * return {@link AwsLogSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceNameAsString}.
     * </p>
     * 
     * @return The name for a Amazon Web Services source.
     * @see AwsLogSourceName
     */
    public final AwsLogSourceName sourceName() {
        return AwsLogSourceName.fromValue(sourceName);
    }

    /**
     * <p>
     * The name for a Amazon Web Services source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceName} will
     * return {@link AwsLogSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceNameAsString}.
     * </p>
     * 
     * @return The name for a Amazon Web Services source.
     * @see AwsLogSourceName
     */
    public final String sourceNameAsString() {
        return sourceName;
    }

    /**
     * <p>
     * The version for a Amazon Web Services source.
     * </p>
     * 
     * @return The version for a Amazon Web Services source.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLogSourceConfiguration)) {
            return false;
        }
        AwsLogSourceConfiguration other = (AwsLogSourceConfiguration) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(sourceNameAsString(), other.sourceNameAsString())
                && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLogSourceConfiguration").add("Accounts", hasAccounts() ? accounts() : null)
                .add("Regions", hasRegions() ? regions() : null).add("SourceName", sourceNameAsString())
                .add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceNameAsString()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accounts", ACCOUNTS_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLogSourceConfiguration, T> g) {
        return obj -> g.apply((AwsLogSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLogSourceConfiguration> {
        /**
         * <p>
         * Specify the Amazon Web Services account information where you want to enable Security Lake.
         * </p>
         * 
         * @param accounts
         *        Specify the Amazon Web Services account information where you want to enable Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * Specify the Amazon Web Services account information where you want to enable Security Lake.
         * </p>
         * 
         * @param accounts
         *        Specify the Amazon Web Services account information where you want to enable Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * Specify the Regions where you want to enable Security Lake.
         * </p>
         * 
         * @param regions
         *        Specify the Regions where you want to enable Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * Specify the Regions where you want to enable Security Lake.
         * </p>
         * 
         * @param regions
         *        Specify the Regions where you want to enable Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The name for a Amazon Web Services source.
         * </p>
         * 
         * @param sourceName
         *        The name for a Amazon Web Services source.
         * @see AwsLogSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceName
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The name for a Amazon Web Services source.
         * </p>
         * 
         * @param sourceName
         *        The name for a Amazon Web Services source.
         * @see AwsLogSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsLogSourceName
         */
        Builder sourceName(AwsLogSourceName sourceName);

        /**
         * <p>
         * The version for a Amazon Web Services source.
         * </p>
         * 
         * @param sourceVersion
         *        The version for a Amazon Web Services source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String sourceName;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLogSourceConfiguration model) {
            accounts(model.accounts);
            regions(model.regions);
            sourceName(model.sourceName);
            sourceVersion(model.sourceVersion);
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public final Builder sourceName(AwsLogSourceName sourceName) {
            this.sourceName(sourceName == null ? null : sourceName.toString());
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public AwsLogSourceConfiguration build() {
            return new AwsLogSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
