/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides lifecycle details of Amazon Security Lake object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeLifecycleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeLifecycleConfiguration.Builder, DataLakeLifecycleConfiguration> {
    private static final SdkField<DataLakeLifecycleExpiration> EXPIRATION_FIELD = SdkField
            .<DataLakeLifecycleExpiration> builder(MarshallingType.SDK_POJO).memberName("expiration")
            .getter(getter(DataLakeLifecycleConfiguration::expiration)).setter(setter(Builder::expiration))
            .constructor(DataLakeLifecycleExpiration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()).build();

    private static final SdkField<List<DataLakeLifecycleTransition>> TRANSITIONS_FIELD = SdkField
            .<List<DataLakeLifecycleTransition>> builder(MarshallingType.LIST)
            .memberName("transitions")
            .getter(getter(DataLakeLifecycleConfiguration::transitions))
            .setter(setter(Builder::transitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeLifecycleTransition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeLifecycleTransition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_FIELD,
            TRANSITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataLakeLifecycleExpiration expiration;

    private final List<DataLakeLifecycleTransition> transitions;

    private DataLakeLifecycleConfiguration(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.transitions = builder.transitions;
    }

    /**
     * <p>
     * Provides data expiration details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides data expiration details of Amazon Security Lake object.
     */
    public final DataLakeLifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransitions() {
        return transitions != null && !(transitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides data storage transition details of Amazon Security Lake object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitions} method.
     * </p>
     * 
     * @return Provides data storage transition details of Amazon Security Lake object.
     */
    public final List<DataLakeLifecycleTransition> transitions() {
        return transitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitions() ? transitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleConfiguration)) {
            return false;
        }
        DataLakeLifecycleConfiguration other = (DataLakeLifecycleConfiguration) obj;
        return Objects.equals(expiration(), other.expiration()) && hasTransitions() == other.hasTransitions()
                && Objects.equals(transitions(), other.transitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeLifecycleConfiguration").add("Expiration", expiration())
                .add("Transitions", hasTransitions() ? transitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "transitions":
            return Optional.ofNullable(clazz.cast(transitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expiration", EXPIRATION_FIELD);
        map.put("transitions", TRANSITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeLifecycleConfiguration, T> g) {
        return obj -> g.apply((DataLakeLifecycleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeLifecycleConfiguration> {
        /**
         * <p>
         * Provides data expiration details of Amazon Security Lake object.
         * </p>
         * 
         * @param expiration
         *        Provides data expiration details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(DataLakeLifecycleExpiration expiration);

        /**
         * <p>
         * Provides data expiration details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeLifecycleExpiration.Builder}
         * avoiding the need to create one manually via {@link DataLakeLifecycleExpiration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeLifecycleExpiration.Builder#build()} is called
         * immediately and its result is passed to {@link #expiration(DataLakeLifecycleExpiration)}.
         * 
         * @param expiration
         *        a consumer that will call methods on {@link DataLakeLifecycleExpiration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expiration(DataLakeLifecycleExpiration)
         */
        default Builder expiration(Consumer<DataLakeLifecycleExpiration.Builder> expiration) {
            return expiration(DataLakeLifecycleExpiration.builder().applyMutation(expiration).build());
        }

        /**
         * <p>
         * Provides data storage transition details of Amazon Security Lake object.
         * </p>
         * 
         * @param transitions
         *        Provides data storage transition details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Collection<DataLakeLifecycleTransition> transitions);

        /**
         * <p>
         * Provides data storage transition details of Amazon Security Lake object.
         * </p>
         * 
         * @param transitions
         *        Provides data storage transition details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(DataLakeLifecycleTransition... transitions);

        /**
         * <p>
         * Provides data storage transition details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition.Builder#build()} is
         * called immediately and its result is passed to {@link #transitions(List<DataLakeLifecycleTransition>)}.
         * 
         * @param transitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitions(java.util.Collection<DataLakeLifecycleTransition>)
         */
        Builder transitions(Consumer<DataLakeLifecycleTransition.Builder>... transitions);
    }

    static final class BuilderImpl implements Builder {
        private DataLakeLifecycleExpiration expiration;

        private List<DataLakeLifecycleTransition> transitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeLifecycleConfiguration model) {
            expiration(model.expiration);
            transitions(model.transitions);
        }

        public final DataLakeLifecycleExpiration.Builder getExpiration() {
            return expiration != null ? expiration.toBuilder() : null;
        }

        public final void setExpiration(DataLakeLifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        @Override
        public final Builder expiration(DataLakeLifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final List<DataLakeLifecycleTransition.Builder> getTransitions() {
            List<DataLakeLifecycleTransition.Builder> result = DataLakeLifecycleTransitionListCopier
                    .copyToBuilder(this.transitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitions(Collection<DataLakeLifecycleTransition.BuilderImpl> transitions) {
            this.transitions = DataLakeLifecycleTransitionListCopier.copyFromBuilder(transitions);
        }

        @Override
        public final Builder transitions(Collection<DataLakeLifecycleTransition> transitions) {
            this.transitions = DataLakeLifecycleTransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(DataLakeLifecycleTransition... transitions) {
            transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Consumer<DataLakeLifecycleTransition.Builder>... transitions) {
            transitions(Stream.of(transitions).map(c -> DataLakeLifecycleTransition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataLakeLifecycleConfiguration build() {
            return new DataLakeLifecycleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
