/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides replication details for objects stored in the Amazon Security Lake data lake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeReplicationConfiguration.Builder, DataLakeReplicationConfiguration> {
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(DataLakeReplicationConfiguration::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DataLakeReplicationConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(REGIONS_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> regions;

    private final String roleArn;

    private DataLakeReplicationConfiguration(BuilderImpl builder) {
        this.regions = builder.regions;
        this.roleArn = builder.roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
     * <code>region</code> parameter of the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
     * <code>CreateDataLake</code> </a> or <a
     * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
     * <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified in this
     * parameter.
     * </p>
     * <p>
     * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are
     * configured for object replication can be owned by the same Amazon Web Services account or by different accounts.
     * You can replicate objects to a single destination bucket or to multiple destination buckets. The destination
     * buckets can be in different Regions or within the same Region as the source bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
     *         <code>region</code> parameter of the <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
     *         <code>CreateDataLake</code> </a> or <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
     *         <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified in
     *         this parameter.</p>
     *         <p>
     *         Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that
     *         are configured for object replication can be owned by the same Amazon Web Services account or by
     *         different accounts. You can replicate objects to a single destination bucket or to multiple destination
     *         buckets. The destination buckets can be in different Regions or within the same Region as the source
     *         bucket.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM) role
     * you created that is managed by Security Lake, to ensure the replication setting is correct.
     * </p>
     * 
     * @return Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management
     *         (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeReplicationConfiguration)) {
            return false;
        }
        DataLakeReplicationConfiguration other = (DataLakeReplicationConfiguration) obj;
        return hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeReplicationConfiguration").add("Regions", hasRegions() ? regions() : null)
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regions", REGIONS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeReplicationConfiguration, T> g) {
        return obj -> g.apply((DataLakeReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeReplicationConfiguration> {
        /**
         * <p>
         * Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
         * <code>region</code> parameter of the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
         * <code>CreateDataLake</code> </a> or <a
         * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
         * <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified in
         * this parameter.
         * </p>
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are
         * configured for object replication can be owned by the same Amazon Web Services account or by different
         * accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The
         * destination buckets can be in different Regions or within the same Region as the source bucket.
         * </p>
         * 
         * @param regions
         *        Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
         *        <code>region</code> parameter of the <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
         *        <code>CreateDataLake</code> </a> or <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
         *        <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified
         *        in this parameter.</p>
         *        <p>
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets
         *        that are configured for object replication can be owned by the same Amazon Web Services account or by
         *        different accounts. You can replicate objects to a single destination bucket or to multiple
         *        destination buckets. The destination buckets can be in different Regions or within the same Region as
         *        the source bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
         * <code>region</code> parameter of the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
         * <code>CreateDataLake</code> </a> or <a
         * href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
         * <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified in
         * this parameter.
         * </p>
         * <p>
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are
         * configured for object replication can be owned by the same Amazon Web Services account or by different
         * accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The
         * destination buckets can be in different Regions or within the same Region as the source bucket.
         * </p>
         * 
         * @param regions
         *        Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the
         *        <code>region</code> parameter of the <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html">
         *        <code>CreateDataLake</code> </a> or <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html">
         *        <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified
         *        in this parameter.</p>
         *        <p>
         *        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets
         *        that are configured for object replication can be owned by the same Amazon Web Services account or by
         *        different accounts. You can replicate objects to a single destination bucket or to multiple
         *        destination buckets. The destination buckets can be in different Regions or within the same Region as
         *        the source bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM)
         * role you created that is managed by Security Lake, to ensure the replication setting is correct.
         * </p>
         * 
         * @param roleArn
         *        Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management
         *        (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeReplicationConfiguration model) {
            regions(model.regions);
            roleArn(model.roleArn);
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DataLakeReplicationConfiguration build() {
            return new DataLakeReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
