/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriberNotificationResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<UpdateSubscriberNotificationResponse.Builder, UpdateSubscriberNotificationResponse> {
    private static final SdkField<String> SUBSCRIBER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberEndpoint").getter(getter(UpdateSubscriberNotificationResponse::subscriberEndpoint))
            .setter(setter(Builder::subscriberEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subscriberEndpoint;

    private UpdateSubscriberNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.subscriberEndpoint = builder.subscriberEndpoint;
    }

    /**
     * <p>
     * The subscriber endpoint to which exception messages are posted.
     * </p>
     * 
     * @return The subscriber endpoint to which exception messages are posted.
     */
    public final String subscriberEndpoint() {
        return subscriberEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriberEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberNotificationResponse)) {
            return false;
        }
        UpdateSubscriberNotificationResponse other = (UpdateSubscriberNotificationResponse) obj;
        return Objects.equals(subscriberEndpoint(), other.subscriberEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriberNotificationResponse").add("SubscriberEndpoint", subscriberEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriberEndpoint":
            return Optional.ofNullable(clazz.cast(subscriberEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subscriberEndpoint", SUBSCRIBER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberNotificationResponse, T> g) {
        return obj -> g.apply((UpdateSubscriberNotificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSubscriberNotificationResponse> {
        /**
         * <p>
         * The subscriber endpoint to which exception messages are posted.
         * </p>
         * 
         * @param subscriberEndpoint
         *        The subscriber endpoint to which exception messages are posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberEndpoint(String subscriberEndpoint);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private String subscriberEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberNotificationResponse model) {
            super(model);
            subscriberEndpoint(model.subscriberEndpoint);
        }

        public final String getSubscriberEndpoint() {
            return subscriberEndpoint;
        }

        public final void setSubscriberEndpoint(String subscriberEndpoint) {
            this.subscriberEndpoint = subscriberEndpoint;
        }

        @Override
        public final Builder subscriberEndpoint(String subscriberEndpoint) {
            this.subscriberEndpoint = subscriberEndpoint;
            return this;
        }

        @Override
        public UpdateSubscriberNotificationResponse build() {
            return new UpdateSubscriberNotificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
